/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import java.util.Map;
import java.util.TreeMap;
import kd.fi.gl.report.accbalance.v2.collect.INodeFactory;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;

public abstract class AbstractSumTreeNode<VALUE, SOURCE, RESULT>
implements ISumNode<SOURCE, RESULT> {
    private int level;
    private TreeMap<VALUE, ISumNode<SOURCE, RESULT>> children = new TreeMap((o1, o2) -> {
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        throw new IllegalArgumentException();
    });
    private INodeFactory<VALUE, SOURCE, RESULT> nodeFactory;

    public abstract VALUE getValue();

    @Override
    public void addData(SOURCE sourceRow) {
        VALUE childValue = this.nodeFactory.extractChildValue(this, sourceRow);
        if (childValue != null) {
            ISumNode<SOURCE, RESULT> child = this.children.get(childValue);
            if (child == null && (child = this.nodeFactory.createChildNode(this, sourceRow)) != null) {
                this.children.put(childValue, child);
            }
            if (child != null) {
                child.addData(sourceRow);
            } else {
                this.setLeafData(sourceRow);
            }
        } else {
            this.setLeafData(sourceRow);
        }
    }

    protected abstract void setLeafData(SOURCE var1);

    public void setNodeFactory(INodeFactory<VALUE, SOURCE, RESULT> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public INodeFactory<VALUE, SOURCE, RESULT> getNodeFactory() {
        return this.nodeFactory;
    }

    public Map<VALUE, ISumNode<SOURCE, RESULT>> getChildren() {
        return this.children;
    }

    public Class<? extends ISumNode> getChildType() {
        return this.children.isEmpty() ? null : this.children.firstEntry().getValue().getClass();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void close() {
        this.children.clear();
    }
}

