/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.vo.RateBean;

public class CollectUtils {
    public static void sumTo(BalanceRow sumData, IBalanceRow sourceData, StateChart stateChart) {
        CollectUtils.sumAmtTo(sumData, sourceData, stateChart);
        if (stateChart.isShowQty()) {
            sumData.addBeginQty(sourceData.getBeginQty());
            sumData.addCreditQty(sourceData.getCreditQty());
            sumData.addDebitQty(sourceData.getDebitQty());
            sumData.addYearCreditQty(sourceData.getYearCreditQty());
            sumData.addYearDebitQty(sourceData.getYearDebitQty());
            sumData.addEndQty(sourceData.getEndQty());
        }
    }

    public static void sumAmtTo(BalanceRow sumData, IBalanceRow sourceData, StateChart stateChart) {
        sumData.addCount(sourceData.getCount());
        if (stateChart.isQueryLocalCurrency()) {
            sumData.addBeginLocal(sourceData.getBeginLocal());
            sumData.addCreditLocal(sourceData.getCreditLocal());
            sumData.addDebitLocal(sourceData.getDebitLocal());
            sumData.addYearCreditLocal(sourceData.getYearCreditLocal());
            sumData.addYearDebitLocal(sourceData.getYearDebitLocal());
            sumData.addEndLocal(sourceData.getEndLocal());
        }
        if (stateChart.isQueryCurrency()) {
            sumData.addBeginFor(sourceData.getBeginFor());
            sumData.addCreditFor(sourceData.getCreditFor());
            sumData.addDebitFor(sourceData.getDebitFor());
            sumData.addYearCreditFor(sourceData.getYearCreditFor());
            sumData.addYearDebitFor(sourceData.getYearDebitFor());
            sumData.addEndFor(sourceData.getEndFor());
        }
        if (stateChart.isShowRptCurr() && sourceData instanceof BalanceRow) {
            sumData.addBeginRpt(((BalanceRow)sourceData).getBeginRpt());
            sumData.addCreditRpt(((BalanceRow)sourceData).getCreditRpt());
            sumData.addDebitRpt(((BalanceRow)sourceData).getDebitRpt());
            sumData.addYearCreditRpt(((BalanceRow)sourceData).getYearCreditRpt());
            sumData.addYearDebitRpt(((BalanceRow)sourceData).getYearDebitRpt());
            sumData.addEndRpt(((BalanceRow)sourceData).getEndRpt());
        }
    }

    public static boolean checkAmt(BalanceRow row, List<Function<BalanceRow, BigDecimal>> amtGetters) {
        return amtGetters.isEmpty() || amtGetters.stream().anyMatch(amtGetter -> ((BigDecimal)amtGetter.apply(row)).signum() != 0);
    }

    public static boolean checkAmt(BalanceRow row, MulOrgQPRpt param) {
        return CollectUtils.checkAmt(row, CollectUtils.getCheckAmtGetters(param));
    }

    public static List<Function<BalanceRow, BigDecimal>> getCheckAmtGetters(MulOrgQPRpt param) {
        List<Function<BalanceRow, BigDecimal>> checkAmtGetters = CollectUtils.getCheckAmtGetters(param.isNoZeroBalance(), param.isNoZeroAmount(), param.isNoZeroYearBal());
        if (checkAmtGetters.isEmpty()) {
            checkAmtGetters = CollectUtils.getCheckAmtGetters(true, true, true);
        }
        return checkAmtGetters;
    }

    private static List<Function<BalanceRow, BigDecimal>> getCheckAmtGetters(boolean noZeroBal, boolean noZeroAmount, boolean noZeroYearBal) {
        ArrayList<Function<BalanceRow, BigDecimal>> checkAmtGetters = new ArrayList<Function<BalanceRow, BigDecimal>>();
        if (noZeroBal) {
            checkAmtGetters.add(BalanceRow::getEndLocal);
            checkAmtGetters.add(BalanceRow::getEndFor);
            checkAmtGetters.add(BalanceRow::getEndQty);
        }
        if (noZeroYearBal) {
            checkAmtGetters.add(BalanceRow::getYearCreditLocal);
            checkAmtGetters.add(BalanceRow::getYearCreditFor);
            checkAmtGetters.add(BalanceRow::getYearCreditQty);
            checkAmtGetters.add(BalanceRow::getYearDebitLocal);
            checkAmtGetters.add(BalanceRow::getYearDebitFor);
            checkAmtGetters.add(BalanceRow::getYearDebitQty);
        }
        if (noZeroAmount) {
            checkAmtGetters.add(r -> new BigDecimal(r.getCount()));
        }
        return checkAmtGetters;
    }

    public static BigDecimal balAdjust(BigDecimal endAmt, String acctDc, boolean showByDc, boolean returnDebit) {
        if (showByDc) {
            if (acctDc.equals("1")) {
                return returnDebit ? endAmt : BigDecimal.ZERO;
            }
            return returnDebit ? BigDecimal.ZERO : endAmt.negate();
        }
        if (endAmt.signum() > 0) {
            return returnDebit ? endAmt : BigDecimal.ZERO;
        }
        return returnDebit ? BigDecimal.ZERO : endAmt.abs();
    }

    public static void setRptAmt(BalanceRow mySumRow, RateBean rptRate) {
        if (rptRate != null) {
            mySumRow.setBeginRpt(rptRate);
            mySumRow.setDebitRpt(rptRate);
            mySumRow.setCreditRpt(rptRate);
            mySumRow.setYearDebitRpt(rptRate);
            mySumRow.setYearCreditRpt(rptRate);
            mySumRow.setEndRpt(rptRate);
        }
    }

    public static <T> Iterator<T> enhanceItr(final Iterator<T> itr, final Consumer<T> enhancer) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public T next() {
                Object next = itr.next();
                enhancer.accept(next);
                return next;
            }
        };
    }
}

