/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import com.google.common.collect.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.OrgTreeInfo;
import kd.fi.gl.report.accbalance.v2.collect.TreeNodeUtil;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AbstractAccBalNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.LeafAccountNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.LeafOrgNode;
import kd.fi.gl.report.accbalance.v2.collect.treenode.AccountTreeFactory;
import kd.fi.gl.report.accbalance.v2.collect.treenode.OrgSumTreeNode;
import kd.fi.gl.report.accbalance.v2.collect.treenode.OrgTreeFactory;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public class TreeDataCollectService {
    public static boolean showMultiLevelNode(Class<? extends AbstractAccBalNode> accBalNode, StateChart stateChart) {
        if (accBalNode.equals(LeafOrgNode.class) && stateChart.isShowOrgTree()) {
            return true;
        }
        return accBalNode.equals(LeafAccountNode.class) && !stateChart.isShowLeafAccount();
    }

    public static List<BalanceRowList> buildMultiLevelData(Class<? extends AbstractAccBalNode> nodeType, List<BalanceRowList> detailData, AccBalQueryContext context) {
        detailData.removeIf(rows -> CollectionUtils.isEmpty(rows.getAllData()));
        if (!detailData.isEmpty()) {
            if (nodeType.equals(LeafOrgNode.class)) {
                return TreeDataCollectService.buildOrgTree(detailData, context);
            }
            if (nodeType.equals(LeafAccountNode.class)) {
                return TreeDataCollectService.buildAccountTree(detailData, context);
            }
        }
        return Collections.emptyList();
    }

    private static List<BalanceRowList> buildAccountTree(List<BalanceRowList> detailData, AccBalQueryContext context) {
        AccountTreeFactory treeFactory = new AccountTreeFactory(context);
        ISumNode<BalanceRowList, List<BalanceRow>> root = treeFactory.createRoot();
        detailData.forEach(root::addData);
        return Collections.singletonList(new BalanceRowList(root.getAllData()));
    }

    private static List<BalanceRowList> buildOrgTree(List<BalanceRowList> detailData, AccBalQueryContext context) {
        int commonParentLevel;
        ThreeTuple<Map<Long, String>, Table<String, Integer, String>, Map<String, Long>> tup;
        if (detailData.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> allOrges = context.getEntityOrgIdSet();
        allOrges.addAll(context.getQueryParam().getOrgs());
        OrgTreeInfo orgTreeInfo = context.getOrgTreeInfo();
        if (orgTreeInfo != null) {
            tup = orgTreeInfo.getThree();
            commonParentLevel = orgTreeInfo.getCommonParentLevel();
        } else {
            tup = TreeNodeUtil.getAllSuperLevelTable(context.getQueryParam().getOrgViewId(), allOrges);
            commonParentLevel = TreeNodeUtil.getCommonParentLevel(new HashSet<String>(((Map)tup.item1).values()));
        }
        context.setOrgLongNum2IdMap((Map)tup.item3);
        context.setMinParentLevel(commonParentLevel);
        OrgSumTreeNode root = new OrgTreeFactory((Map)tup.item1, (Table<String, Integer, String>)((Table)tup.item2), (Map)tup.item3, context).createRoot();
        LinkedList<BalanceRow> res = new LinkedList<BalanceRow>();
        detailData.forEach(root::addData);
        res.addAll(0, root.getAllData().getAllData());
        return Collections.singletonList(new BalanceRowList(res));
    }
}

