/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.simplenode;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.INodeFactory;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AbstractAccBalNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.CurrencyNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.DetailGroupNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.LeafAccountNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.LeafOrgNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.RootNode;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public class AccSumTreeNodeFactory
implements INodeFactory<Object, IBalanceRow, List<BalanceRow>> {
    private final List<Class<? extends AbstractAccBalNode>> nodeTypes;
    private final List<Function<IBalanceRow, AbstractAccBalNode>> nodeCreators;
    private final List<Function<IBalanceRow, Object>> valueExtractor;
    private final AccBalQueryContext context;

    public AccSumTreeNodeFactory(AccBalQueryContext context) {
        boolean showDetail;
        this.context = context;
        StateChart stateChart = context.getStateChart();
        this.nodeTypes = new ArrayList<Class<? extends AbstractAccBalNode>>();
        this.nodeCreators = new ArrayList<Function<IBalanceRow, AbstractAccBalNode>>();
        this.valueExtractor = new ArrayList<Function<IBalanceRow, Object>>();
        this.nodeTypes.add(RootNode.class);
        this.nodeCreators.add(r -> new RootNode());
        this.valueExtractor.add(r -> null);
        this.nodeTypes.add(LeafAccountNode.class);
        this.nodeCreators.add(balRow -> {
            Tuple<Long, String> tuple = context.getShowAcctMidAndLongNum(balRow.getAccountMid());
            return new LeafAccountNode((Long)tuple.item1, (String)tuple.item2);
        });
        this.valueExtractor.add(balRow -> {
            Tuple<Long, String> midAndLongNum = context.getShowAcctMidAndLongNum(balRow.getAccountMid());
            return context.needShowAcctNum((String)midAndLongNum.item2) ? midAndLongNum.item2 : null;
        });
        if (stateChart.isShowCurrency()) {
            this.nodeTypes.add(CurrencyNode.class);
            this.nodeCreators.add(r -> new CurrencyNode(r.getCurrencyId()));
            this.valueExtractor.add(IBalanceRow::getCurrencyId);
        }
        if (stateChart.isShowOrg()) {
            this.nodeTypes.add(LeafOrgNode.class);
            this.nodeCreators.add(r -> new LeafOrgNode(r.getOrgId()));
            this.valueExtractor.add(IBalanceRow::getOrgId);
        }
        boolean bl = showDetail = stateChart.isShowQty() || stateChart.isShowComAssist() || stateChart.isQueryAssgrp();
        if (showDetail) {
            this.nodeTypes.add(DetailGroupNode.class);
            this.nodeCreators.add(r -> {
                boolean showAssist = stateChart.isQueryAssgrp() && context.needShowAssist(this.getAcctLongNum((IBalanceRow)r));
                return new DetailGroupNode(BalDetailGroup.createGrp(context, r.getMeasureUnit(), showAssist ? r.getAssgrpId() : 0L, r.getComAssistIds()));
            });
            this.valueExtractor.add(r -> {
                boolean showAssist = stateChart.isQueryAssgrp() && context.needShowAssist(this.getAcctLongNum((IBalanceRow)r));
                return BalDetailGroup.createGrp(context, r.getMeasureUnit(), showAssist ? r.getAssgrpId() : 0L, r.getComAssistIds());
            });
        }
    }

    @Override
    public ISumNode<IBalanceRow, List<BalanceRow>> createRoot() {
        return this.createChildNode(null, null);
    }

    @Override
    public ISumNode<IBalanceRow, List<BalanceRow>> createChildNode(ISumNode<IBalanceRow, List<BalanceRow>> parentNode, IBalanceRow sourceRow) {
        int childLevel;
        int n = childLevel = parentNode == null ? 0 : parentNode.getLevel() + 1;
        if (childLevel > this.valueExtractor.size()) {
            return null;
        }
        if (parentNode != null && !this.context.getRowLimit().tryDecrement()) {
            return null;
        }
        AbstractAccBalNode childNode = this.nodeCreators.get(childLevel).apply(sourceRow);
        childNode.setLevel(childLevel);
        childNode.setNodeFactory(this);
        return childNode;
    }

    private String getAcctLongNum(IBalanceRow sourceRow) {
        return (String)this.valueExtractor.get(1).apply(sourceRow);
    }

    @Override
    public Object extractChildValue(ISumNode<IBalanceRow, List<BalanceRow>> parentNode, IBalanceRow sourceRow) {
        int childLayer = parentNode.getLevel() + 1;
        if (childLayer >= this.valueExtractor.size()) {
            return null;
        }
        return this.valueExtractor.get(childLayer).apply(sourceRow);
    }

    public Class<? extends AbstractAccBalNode> getNodeType(int layer) {
        return layer < this.nodeTypes.size() ? this.nodeTypes.get(layer) : null;
    }
}

