/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.simplenode;

import java.util.List;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AbstractAccBalNode;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;

public class LeafOrgNode
extends AbstractAccBalNode {
    public LeafOrgNode(Long org) {
        super(org);
    }

    @Override
    protected void enhanceChildData(BalanceRowList childRows) {
        super.enhanceChildData(childRows);
        childRows.getAllData().forEach(r -> {
            r.setBalSumGroup(BalSumGroup.createGrp(this.context, (Long)this.getValue(), 0L, 0L));
            r.setOrgLongNum(this.context.getEntityOrgLongNum(r.getOrgId()));
            r.setDetailOrg(true);
        });
    }

    @Override
    protected BalanceRow enhanceSumData(BalanceRow mySumRow, List<BalanceRow> childRows) {
        if ((mySumRow = super.enhanceSumData(mySumRow, childRows)) != null) {
            Long orgId = (Long)this.getValue();
            mySumRow.setBalSumGroup(BalSumGroup.createGrp(this.context, orgId, 0L, 0L));
            mySumRow.setBalDetailGroup(BalDetailGroup.EMPTY);
            mySumRow.setOrgLongNum(this.context.getEntityOrgLongNum(orgId));
            mySumRow.setDetailOrg(true);
            mySumRow.setRowType(RowType.ORG_SUMMARY);
            mySumRow.setDetailSumRow(true);
        }
        return mySumRow;
    }
}

