/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.treenode;

import java.util.LinkedList;
import java.util.List;
import kd.fi.gl.report.accbalance.v2.AccBalActionTracer;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.AbstractSumTreeNode;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.CollectUtils;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;

public class OrgSumTreeNode
extends AbstractSumTreeNode<String, BalanceRowList, BalanceRowList> {
    private final String orgLongNum;
    private BalanceRow sumData;
    private final Long orgId;
    private final AccBalQueryContext context = AccBalQueryContext.getCurrent();
    private final AccBalActionTracer tracer = AccBalActionTracer.get();
    private final List<BalanceRowList> leafRowLists = new LinkedList<BalanceRowList>();

    public OrgSumTreeNode(String orgLongNum, Long orgId, int level) {
        this.orgLongNum = orgLongNum;
        this.orgId = orgId;
        this.sumData = BalanceRow.create(this.context);
        this.sumData.setOrgLevel(level - this.context.getMinParentLevel());
        this.tracer.logCreatingNode(this);
        this.setLevel(level);
    }

    @Override
    public String getValue() {
        return this.orgLongNum;
    }

    @Override
    public BalanceRowList getAllData() {
        LinkedList<BalanceRow> res = new LinkedList<BalanceRow>();
        if (!"".equals(this.orgLongNum)) {
            this.getChildren().forEach((k, child) -> {
                BalanceRowList childData = (BalanceRowList)child.getAllData();
                childData.getSumData().setPid(this.sumData.getRowId());
                res.addAll(childData.getAllData());
                CollectUtils.sumAmtTo(this.sumData, childData.getSumData(), AccBalQueryContext.getCurrent().getStateChart());
            });
            this.sumData.setOrgLongNum(this.orgLongNum);
            this.sumData.setSumRow(true);
            this.sumData.setBalSumGroup(BalSumGroup.createGrp(this.context, this.orgId, this.sumData.getAccountMid(), this.sumData.getCurrencyId()));
            this.sumData.setRowType(RowType.ORG_SUMMARY);
            this.leafRowLists.forEach(leafRowList -> res.addAll(0, leafRowList.getAllData()));
            res.add(0, this.sumData);
        } else {
            this.getChildren().values().stream().map(ISumNode::getAllData).map(BalanceRowList::getAllData).forEach(res::addAll);
            this.leafRowLists.forEach(leafRowList -> {
                List<BalanceRow> allData = leafRowList.getAllData();
                for (BalanceRow row : allData) {
                    row.setPid(0);
                    res.add(0, row);
                }
            });
        }
        this.tracer.logReturnData(this, res);
        this.close();
        return new BalanceRowList(this.orgLongNum, res);
    }

    @Override
    public void close() {
        super.close();
        this.sumData = BalanceRow.create(this.context);
        this.leafRowLists.clear();
    }

    @Override
    protected void setLeafData(BalanceRowList sources) {
        sources.getAllData().forEach(r -> r.setOrgLevel(this.sumData.getOrgLevel() + 1));
        sources.getSumData().setPid(this.sumData.getRowId());
        CollectUtils.sumAmtTo(this.sumData, sources.getSumData(), this.context.getStateChart());
        this.leafRowLists.add(sources);
    }
}

