/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.ds.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.ds.IDataSource;
import kd.fi.gl.report.accbalance.v2.ds.impl.AccBalanceDs;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.report.accbalance.v2.model.StreamBalRow;

public class DetailBalanceDS
implements IDataSource {
    private final Iterator<IBalanceRow> inner;
    private static final Set<String> SUM_FIELDS = new HashSet<String>(Arrays.asList("org", "currency", "account"));

    public DetailBalanceDS(BalSumGroup balSumGroup, AccBalQueryContext context) {
        long currencyId = balSumGroup.getCurrencyId();
        long selectCur = context.getQueryParam().getCurrency();
        if (currencyId <= 0L && selectCur > 0L) {
            currencyId = selectCur;
        }
        HashSet orgs = balSumGroup.getOrgId() <= 0L ? context.getEntityOrgIdSet() : Sets.newHashSet((Object[])new Long[]{balSumGroup.getOrgId()});
        List<Long> curIds = currencyId > 0L ? Collections.singletonList(currencyId) : Collections.emptyList();
        List<Long> acctMids = context.getEOrgAcctMidsByLongNum(context.getLongNumByMid(balSumGroup.getAccountId()));
        this.inner = AccBalQueryUtil.createItr(DetailBalanceDS.getRawDs(orgs, curIds, acctMids, context), row -> new StreamBalRow((Row)row, context, true));
    }

    static DataSet getRawDs(Set<Long> org, List<Long> currency, List<Long> account, AccBalQueryContext context) {
        MulOrgQPRpt queryParam = context.getQueryParam();
        StateChart stateChart = context.getStateChart();
        List<String> selectFields = AccBalanceDs.getSelectFields(queryParam, stateChart);
        selectFields.add("assgrp");
        String fields = String.join((CharSequence)", ", selectFields);
        List<QFilter> baseFilters = AccBalQueryUtil.getBalBaseFilters(queryParam, org, account);
        List<QFilter> filters = DetailBalanceDS.replaceFilter(baseFilters, org, currency, account);
        String orderBys = DetailBalanceDS.getOrderBys(stateChart, context.getCommonAssistKeys());
        return QueryServiceHelper.queryDataSet((String)"AccBalanceDS#getDs", (String)"gl_balance", (String)fields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys);
    }

    static List<QFilter> replaceFilter(List<QFilter> baseFilters, Set<Long> org, List<Long> currency, List<Long> account) {
        baseFilters.removeIf(filter -> SUM_FIELDS.contains(filter.getProperty()));
        if (CollectionUtils.isNotEmpty(org)) {
            baseFilters.add(new QFilter("org", "in", org));
        }
        if (CollectionUtils.isNotEmpty(currency)) {
            baseFilters.add(new QFilter("currency", "in", currency));
        }
        if (CollectionUtils.isNotEmpty(account)) {
            baseFilters.add(new QFilter("account", "in", account));
        }
        return baseFilters;
    }

    static String getOrderBys(StateChart stateChart, List<String> comAssists) {
        ArrayList<String> orderBys = new ArrayList<String>();
        if (stateChart.isShowAssist()) {
            orderBys.add("assgrp");
        }
        if (stateChart.isShowQty()) {
            orderBys.add("measureunit");
        }
        orderBys.addAll(comAssists);
        return String.join((CharSequence)",", orderBys);
    }

    @Override
    public Iterator<IBalanceRow> getData() {
        return this.inner;
    }
}

