/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.ds.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.AcctLevelTree;
import kd.fi.gl.report.accbalance.v2.ds.impl.PLInitBalanceDS;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.report.accbalance.v2.model.StreamPLProfitInitBalRow;

public class PLProfitInitBalanceDS
extends PLInitBalanceDS {
    private static final String ACCOUNT_MID = "account.masterid";

    public static PLProfitInitBalanceDS getInstance() {
        return new PLProfitInitBalanceDS();
    }

    @Override
    public Iterator<IBalanceRow> getData() {
        final AccBalQueryContext context = AccBalQueryContext.getCurrent();
        DataSet plInitBal = this.getDs(context);
        final int orgIndex = plInitBal.getRowMeta().getFieldIndex("org");
        plInitBal = plInitBal.filter(new FilterFunction(){
            private static final long serialVersionUID = -88769106449828128L;

            public boolean test(Row row) {
                return context.hasProfitAcct(row.getLong(orgIndex));
            }
        });
        return AccBalQueryUtil.createItr(plInitBal, row -> new StreamPLProfitInitBalRow((Row)row, context));
    }

    @Override
    protected List<String> getSelectFields(MulOrgQPRpt queryParam, StateChart stateChart) {
        HashSet<String> selectFields = new HashSet<String>(super.getSelectFields(queryParam, stateChart));
        selectFields.add("org");
        return new ArrayList<String>(selectFields);
    }

    @Override
    protected List<QFilter> getFilters(MulOrgQPRpt qpRpt, List<Long> orgIds, List<Long> acctMids) {
        List<QFilter> filters = super.getFilters(qpRpt, orgIds, acctMids);
        filters.removeIf(filter -> ACCOUNT_MID.equals(filter.getProperty()));
        QFilter plTypeFilter = new QFilter("pltype", "!=", (Object)Character.valueOf('0'));
        Set<Long> plAcctLeafIds = AcctLevelTree.create(qpRpt, plTypeFilter).getLeafIds();
        filters.add(new QFilter("account", "in", plAcctLeafIds));
        return filters;
    }
}

