/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.ds.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.ds.IDataSource;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.report.accbalance.v2.model.StreamPLVchRow;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class PLVoucherDS
implements IDataSource {
    public static PLVoucherDS getInstance() {
        return new PLVoucherDS();
    }

    @Override
    public Iterator<IBalanceRow> getData() {
        AccBalQueryContext context = AccBalQueryContext.getCurrent();
        return AccBalQueryUtil.createItr(this.getDs(context), row -> new StreamPLVchRow((Row)row, context));
    }

    private DataSet getDs(AccBalQueryContext context) {
        MulOrgQPRpt queryParam = context.getQueryParam();
        List<QFilter> filters = this.getFilters(queryParam, context.getEntityOrgIdSet(), context.getAcctMids());
        return QueryServiceHelper.queryDataSet((String)"PLVoucherDS", (String)"gl_voucher", (String)String.join((CharSequence)", ", this.getSelectFields(queryParam, context.getStateChart())), (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private List<QFilter> getFilters(MulOrgQPRpt qpRpt, Set<Long> orgIds, List<Long> acctMids) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", orgIds));
        list.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        DynamicObject curYearMinPeriod = GLUtil.getCurYearMinPeriod((Object)qpRpt.getStartPeriod());
        list.add(new QFilter("period", ">=", curYearMinPeriod.getPkValue()));
        list.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        list.add(new QFilter("entries.account.masterid", "in", acctMids));
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            list.add(new QFilter("entries.currency", "=", (Object)qpRpt.getCurrency()));
        }
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        list.add(new QFilter("sourcetype", "=", (Object)"1"));
        list.addAll(qpRpt.getComAssistFiltersForBill(key -> "entries." + key));
        return list;
    }

    private List<String> getSelectFields(MulOrgQPRpt qpRpt, StateChart stateChart) {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("entries.account.masterid account");
        if (!qpRpt.getComAssistValsList().isEmpty()) {
            qpRpt.getCommonAssistKeys().forEach(x -> sels.add("entries." + x + " " + x));
        }
        if (stateChart.isShowOrg()) {
            sels.add("org org");
        }
        if (stateChart.isShowAssist()) {
            sels.add("entries.assgrp assgrp");
        }
        sels.add("period");
        sels.addAll(MulCurReportUtil.getVoucherLocalAmountFields3((String)qpRpt.getLocaleCurType()));
        if (stateChart.isQueryCurrency()) {
            sels.add("entries.currency currency");
            sels.add("entries.debitori debitfor");
            sels.add("entries.creditori creditfor");
        }
        if (stateChart.isShowQty()) {
            sels.add("case when entries.entrydc ='1' then entries.quantity else 0.0 end as debitqty");
            sels.add("case when entries.entrydc ='-1' then entries.quantity else 0.0 end as creditqty");
            sels.add("entries.measureunit measureunit");
        }
        return sels;
    }
}

