/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public abstract class AbstractStreamBalRow
implements IBalanceRow {
    protected final Row streamRow;
    protected final StateChart stateChart;
    protected final AccBalQueryContext context;

    public AbstractStreamBalRow(Row streamRow, AccBalQueryContext context) {
        this.stateChart = context.getStateChart();
        this.streamRow = this.stateChart.isQueryMulLocalCur() ? new NoZeroRow((AbstractRow)streamRow) : streamRow;
        this.context = context;
    }

    @Override
    public long getOrgId() {
        return this.stateChart.isShowOrg() ? this.streamRow.getLong("org") : 0L;
    }

    @Override
    public long getAccountMid() {
        return this.streamRow.getLong("account");
    }

    @Override
    public long getCurrencyId() {
        return this.stateChart.isQueryCurrency() ? this.streamRow.getLong("currency") : 0L;
    }

    @Override
    public long getMeasureUnit() {
        return this.stateChart.isShowQty() ? this.streamRow.getLong("measureunit") : 0L;
    }

    @Override
    public long getAssgrpId() {
        return this.stateChart.isShowAssist() ? this.streamRow.getLong("assgrp") : 0L;
    }

    @Override
    public long[] getComAssistIds() {
        List<String> commonAssistKeys = this.context.getCommonAssistKeys();
        if (!commonAssistKeys.isEmpty()) {
            return commonAssistKeys.stream().mapToLong(arg_0 -> ((Row)this.streamRow).getLong(arg_0)).toArray();
        }
        return BalDetailGroup.NO_COM_ASSIST;
    }

    private static class NoZeroRow
    extends AbstractRow {
        private static final long serialVersionUID = 4981303437889490166L;
        private final AbstractRow streamRow;

        public NoZeroRow(AbstractRow streamRow) {
            this.streamRow = streamRow;
        }

        public BigDecimal getBigDecimal(int index) {
            BigDecimal bigDecimal = super.getBigDecimal(index);
            return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
        }

        public BigDecimal getBigDecimal(String field) {
            BigDecimal bigDecimal = super.getBigDecimal(field);
            return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
        }

        public Object[] values() {
            return this.streamRow.values();
        }

        public RowMeta getRowMeta() {
            return this.streamRow.getRowMeta();
        }

        public int size() {
            return this.streamRow.size();
        }

        public Object get(int i) {
            return this.streamRow.get(i);
        }
    }
}

