/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.util.GLUtil;

public class BalGroup
implements Serializable {
    private static final transient long serialVersionUID = 1764751411967174429L;
    private final BalSumGroup balSumGroup;
    private final BalDetailGroup balDetailGroup;
    private final String orgLongNum;
    private final String acctLongNum;
    public static final transient Comparator<BalGroup> COMPARATOR = Comparator.comparing(BalGroup::getAcctLongNum).thenComparing(BalGroup::getCurrencyId).thenComparing(BalGroup::getOrgLongNum).thenComparing(BalGroup::getMeasureUnit).thenComparing(BalGroup::getAssgrpId).thenComparing(GLUtil.longArrComparator(BalGroup::getComAssistIds));

    public BalGroup(AccBalQueryContext context, long orgId, String orgLongNum, long accountId, String acctLongNum, long currencyId, long measureUnit, long assgrpId, long[] comAssistIds) {
        this.balSumGroup = BalSumGroup.createGrp(context, orgId, accountId, currencyId);
        this.balDetailGroup = BalDetailGroup.createGrp(context, measureUnit, assgrpId, comAssistIds);
        this.acctLongNum = acctLongNum == null ? "" : acctLongNum;
        this.orgLongNum = orgLongNum == null ? "" : orgLongNum;
    }

    public static BalGroup createGrp(AccBalQueryContext context, IBalanceRow balRow) {
        return new BalGroup(context, balRow.getOrgId(), "", balRow.getAccountMid(), "", balRow.getCurrencyId(), balRow.getMeasureUnit(), balRow.getAssgrpId(), balRow.getComAssistIds());
    }

    public String getOrgLongNum() {
        return this.orgLongNum;
    }

    @JsonIgnore
    public long getOrgId() {
        return this.balSumGroup.getOrgId();
    }

    @JsonIgnore
    public long getAccountId() {
        return this.balSumGroup.getAccountId();
    }

    @JsonIgnore
    public long getCurrencyId() {
        return this.balSumGroup.getCurrencyId();
    }

    @JsonIgnore
    public long getMeasureUnit() {
        return this.balDetailGroup.getMeasureUnit();
    }

    @JsonIgnore
    public long getAssgrpId() {
        return this.balDetailGroup.getAssgrpId();
    }

    @JsonIgnore
    public long[] getComAssistIds() {
        return this.balDetailGroup.getComAssistIds();
    }

    public BalSumGroup getBalSumGroup() {
        return this.balSumGroup;
    }

    public BalDetailGroup getBalDetailGroup() {
        return this.balDetailGroup;
    }

    public String getAcctLongNum() {
        return this.acctLongNum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalGroup balGroup = (BalGroup)o;
        return Objects.equals(this.balSumGroup, balGroup.balSumGroup) && Objects.equals(this.balDetailGroup, balGroup.balDetailGroup);
    }

    public int hashCode() {
        return Objects.hash(this.balSumGroup, this.balDetailGroup);
    }

    public String toString() {
        return GLUtil.toJsonStr((Object)this);
    }
}

