/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import java.math.BigDecimal;
import kd.bos.algo.Row;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.AbstractStreamBalRow;
import kd.fi.gl.util.GLUtil;

public class StreamBalLogRow
extends AbstractStreamBalRow {
    private final PeriodState periodState;

    public StreamBalLogRow(Row streamRow, AccBalQueryContext context) {
        super(streamRow, context);
        this.periodState = StreamBalLogRow.getPeriodState(streamRow.getLong("period"), context.getQueryParam().getStartPeriod(), context.getQueryYear());
    }

    @Override
    public BigDecimal getBeginQty() {
        return PeriodState.period == this.periodState ? BigDecimal.ZERO : this.getEndQty();
    }

    @Override
    public BigDecimal getBeginFor() {
        return PeriodState.period == this.periodState ? BigDecimal.ZERO : this.getEndFor();
    }

    @Override
    public BigDecimal getBeginLocal() {
        return PeriodState.period == this.periodState ? BigDecimal.ZERO : this.getEndLocal();
    }

    @Override
    public int getCount() {
        return PeriodState.period != this.periodState ? 0 : this.streamRow.getInteger("count");
    }

    @Override
    public BigDecimal getDebitQty() {
        return PeriodState.period != this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitqty");
    }

    @Override
    public BigDecimal getDebitFor() {
        return PeriodState.period != this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitfor");
    }

    @Override
    public BigDecimal getDebitLocal() {
        return PeriodState.period != this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitlocal");
    }

    @Override
    public BigDecimal getCreditQty() {
        return PeriodState.period != this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditqty");
    }

    @Override
    public BigDecimal getCreditFor() {
        return PeriodState.period != this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditfor");
    }

    @Override
    public BigDecimal getCreditLocal() {
        return PeriodState.period != this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditlocal");
    }

    @Override
    public BigDecimal getYearDebitQty() {
        return PeriodState.veryBegin == this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitqty");
    }

    @Override
    public BigDecimal getYearDebitFor() {
        return PeriodState.veryBegin == this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitfor");
    }

    @Override
    public BigDecimal getYearDebitLocal() {
        return PeriodState.veryBegin == this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitlocal");
    }

    @Override
    public BigDecimal getYearCreditQty() {
        return PeriodState.veryBegin == this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditqty");
    }

    @Override
    public BigDecimal getYearCreditFor() {
        return PeriodState.veryBegin == this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditfor");
    }

    @Override
    public BigDecimal getYearCreditLocal() {
        return PeriodState.veryBegin == this.periodState ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditlocal");
    }

    @Override
    public BigDecimal getEndQty() {
        return this.streamRow.getBigDecimal("debitqty").subtract(this.streamRow.getBigDecimal("creditqty"));
    }

    @Override
    public BigDecimal getEndFor() {
        return this.streamRow.getBigDecimal("debitfor").subtract(this.streamRow.getBigDecimal("creditfor"));
    }

    @Override
    public BigDecimal getEndLocal() {
        return this.streamRow.getBigDecimal("debitlocal").subtract(this.streamRow.getBigDecimal("creditlocal"));
    }

    static PeriodState getPeriodState(long period, long selStartPeriod, long endPeriodYear) {
        long periodYear = GLUtil.getYear((long)period);
        PeriodState periodStates = period < selStartPeriod ? (periodYear == endPeriodYear ? PeriodState.begin : PeriodState.veryBegin) : PeriodState.period;
        return periodStates;
    }

    static enum PeriodState {
        veryBegin,
        begin,
        period;

    }
}

