/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.util.MulCurReportUtil;
import org.apache.commons.lang3.StringUtils;

public class BalancePureQueryService {
    private static final Log LOG = LogFactory.getLog(BalancePureQueryService.class);
    private static final String ENTITY_BALANCE_LOG = "gl_balance_log";
    private static final String QFILTER_CACHE_KEY = BalancePureQueryService.class + "commonfilter";
    private static final String[] VOUCHER_BALANCE_STATUS = new String[]{"B", "C", "P"};
    private static final String[] vamoutFileds = new String[]{"vdebitqty", "vcreditqty", "vdebitfor", "vcreditfor", "vdebitlocal", "vcreditlocal"};

    public static Tuple<List<QFilter>, IAccountTreeModel> buildBalanceQFilters(Long[] orgIds, long bookTypeId, long accountTableId, Long beginPeriodId, Long endPeriodId, boolean isShowPeriod, Set<Long> currencies, Set<Long> measureUnitIds, Set<Long> accountIds, boolean isShowLeafAccount, QueryParamRpt qParam) {
        Preconditions.checkArgument((null != endPeriodId && endPeriodId > 0L ? 1 : 0) != 0);
        if (null == orgIds || orgIds.length == 0) {
            throw new KDBizException("no orgs specificed. ");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setAccountFilter(new QFilter("id", "in", accountIds));
        queryParam.setSpecialAccount(false);
        FilterItemInfo itemInfo = qParam.getFilterInfo().getFilterItem("account");
        if (itemInfo != null && itemInfo.getValue() != null && ReportHelper.getLevelFilter()) {
            isShowLeafAccount = true;
        }
        queryParam.setOnlyLeafAcctBal(isShowLeafAccount);
        IAccountTreeModel accTreeModel = IAccountTreeModel.getInstance((Long[])orgIds, (long)accountTableId, (long)endPeriodId, (QueryParam)queryParam);
        Set refinedFilterAccIds = accTreeModel.getFilterAccountIds();
        LOG.info("Acc_masterIds: {}", (Object)refinedFilterAccIds);
        List<QFilter> qFilters = BalancePureQueryService.buildCommonQFilters(orgIds, bookTypeId, accountTableId, currencies, measureUnitIds, refinedFilterAccIds);
        ThreadCache.put((Object)QFILTER_CACHE_KEY, qFilters.stream().map(QFilter::copy).collect(Collectors.toList()));
        if (null != beginPeriodId && beginPeriodId > 0L) {
            qFilters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)beginPeriodId, (Long[])orgIds)));
        }
        if (isShowPeriod) {
            List periodIds = PeriodUtil.getPeriodIds((Long)beginPeriodId, (Long)endPeriodId);
            qFilters.add(new QFilter("period", "in", (Object)periodIds));
        } else {
            qFilters.add(new QFilter("period", "<=", (Object)endPeriodId));
            qFilters.add(new QFilter("period", ">=", (Object)(endPeriodId / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
        }
        qFilters.addAll(BalancePureQueryService.buildComAssistQFilters("", qParam));
        return Tuple.create(qFilters, (Object)accTreeModel);
    }

    private static List<QFilter> buildComAssistQFilters(String prefix, QueryParamRpt qParam) {
        if ("entries.".equals(prefix)) {
            return qParam.getComAssistFiltersForBill(key -> prefix + key);
        }
        return qParam.getComAssistFiltersForBal();
    }

    public static List<QFilter> buildBalanceLogQFilters(Long endPeriodId) {
        List qFilters = (List)ThreadCache.get((Object)QFILTER_CACHE_KEY);
        Preconditions.checkState((null != qFilters ? 1 : 0) != 0);
        qFilters.add(new QFilter("period", ">=", (Object)(endPeriodId / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
        qFilters.add(new QFilter("period", "<=", (Object)endPeriodId));
        qFilters.add(new QFilter("calculated", "=", (Object)"0"));
        return qFilters;
    }

    public static List<QFilter> buildPLVoucherQfilters(Long[] orgIds, long bookTypeId, long yearMinPeriodId, long endPeriodId, Set<Long> currencies, Set<Long> measureUnitIds, Set<Long> accIds, QueryParamRpt qParam) {
        ArrayList<QFilter> plQfilters = new ArrayList<QFilter>(8);
        plQfilters.add(new QFilter("sourcetype", "=", (Object)"1"));
        plQfilters.add(new QFilter("period.id", ">=", (Object)yearMinPeriodId));
        plQfilters.add(new QFilter("period.id", "<=", (Object)endPeriodId));
        plQfilters.add(new QFilter("billstatus", "in", (Object)VOUCHER_BALANCE_STATUS));
        plQfilters.add(new QFilter("booktype", "=", (Object)bookTypeId));
        plQfilters.add(new QFilter("org", "in", (Object)orgIds));
        if (!CollectionUtils.isEmpty(currencies)) {
            plQfilters.add(new QFilter("entries.currency", "in", currencies));
        }
        if (!CollectionUtils.isEmpty(measureUnitIds)) {
            plQfilters.add(new QFilter("entries.measureunit", "in", measureUnitIds));
        }
        if (!CollectionUtils.isEmpty(accIds)) {
            plQfilters.add(new QFilter("entries.account.id", "in", accIds));
        }
        plQfilters.addAll(BalancePureQueryService.buildComAssistQFilters("entries.", qParam));
        return plQfilters;
    }

    public static List<QFilter> buildInitBalanceQfilters(Long[] orgIds, long bookTypeId, Set<Long> currencies, Set<Long> measureUnitIds, Set<Long> accIds, QueryParamRpt qParam) {
        ArrayList<QFilter> plQfilters = new ArrayList<QFilter>(8);
        plQfilters.add(new QFilter("org", "in", (Object)orgIds));
        plQfilters.add(new QFilter("booktype", "=", (Object)bookTypeId));
        if (!CollectionUtils.isEmpty(currencies)) {
            plQfilters.add(new QFilter("currency", "in", currencies));
        }
        if (!CollectionUtils.isEmpty(measureUnitIds)) {
            plQfilters.add(new QFilter("measureunit", "in", measureUnitIds));
        }
        if (!CollectionUtils.isEmpty(accIds)) {
            plQfilters.add(new QFilter("account.id", "in", accIds));
        }
        plQfilters.addAll(BalancePureQueryService.buildComAssistQFilters("", qParam));
        return plQfilters;
    }

    private static List<QFilter> buildCommonQFilters(Long[] orgIds, long bookTypeId, long accountTableId, Set<Long> currencies, Set<Long> measureUnitIds, Set<Long> accountIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("booktype", "=", (Object)bookTypeId));
        qFilters.add(new QFilter("org", "in", (Object)orgIds));
        qFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        if (!CollectionUtils.isEmpty(currencies)) {
            qFilters.add(new QFilter("currency", "in", currencies));
        }
        if (!CollectionUtils.isEmpty(measureUnitIds)) {
            qFilters.add(new QFilter("measureunit", "in", measureUnitIds));
        }
        qFilters.add(new QFilter("account", "in", accountIds));
        return qFilters;
    }

    public static DataSet queryBalanceByAssist(MainEntityType ormBalanceEntity, String selectors, QFilter[] filters, String queryOrder, int limit, String entity) {
        Preconditions.checkArgument((ormBalanceEntity != null ? 1 : 0) != 0);
        ORM orm = ORM.create();
        orm.setDataEntityType(entity, (IDataEntityType)ormBalanceEntity);
        if (DebugTrace.enable()) {
            LOG.info("balance_query filters :{}, order: {}, limit: {}", new Object[]{String.join((CharSequence)" | ", Arrays.asList(filters).stream().map(x -> StringUtils.truncate((String)x.toString(), (int)1000)).collect(Collectors.toList())), queryOrder, limit});
        }
        long qTick = System.currentTimeMillis();
        DataSet balance = orm.queryDataSet(BalancePureQueryService.class.getName(), entity, selectors, Arrays.asList(filters).toArray(new QFilter[0]), queryOrder, limit);
        LOG.info("query balance table cost: {}", (Object)(System.currentTimeMillis() - qTick));
        return balance;
    }

    public static DataSet queryBalanceLog(MainEntityType ormBalanceLogEntity, String selectors, QFilter[] filters, String queryOrder, int limit) {
        Preconditions.checkArgument((ormBalanceLogEntity != null ? 1 : 0) != 0);
        ORM orm = ORM.create();
        orm.setDataEntityType(ENTITY_BALANCE_LOG, (IDataEntityType)ormBalanceLogEntity);
        if (DebugTrace.enable()) {
            LOG.info("balance_log_query filters :{}, order: {}, limit: {}", new Object[]{String.join((CharSequence)" | ", Arrays.asList(filters).stream().map(x -> StringUtils.truncate((String)x.toString(), (int)1000)).collect(Collectors.toList())), queryOrder, limit});
        }
        DataSet balance = orm.queryDataSet(BalancePureQueryService.class.getName(), ENTITY_BALANCE_LOG, selectors, Arrays.asList(filters).toArray(new QFilter[0]), queryOrder, limit);
        return balance;
    }

    public static DataSet queryVoucher(MainEntityType ormVoucherEntity, String selectors, QFilter[] filters, String queryOrder, int limit) {
        Preconditions.checkArgument((ormVoucherEntity != null ? 1 : 0) != 0);
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)ormVoucherEntity);
        if (DebugTrace.enable()) {
            LOG.info("voucher_query filters :{}, order: {}, limit: {}", new Object[]{String.join((CharSequence)" | ", Arrays.asList(filters).stream().map(x -> StringUtils.truncate((String)x.toString(), (int)1000)).collect(Collectors.toList())), queryOrder, limit});
        }
        return VoucherQueryUtils.ormQueryDataSet((IDataEntityType)ormVoucherEntity, (String)selectors, (QFilter[])filters, (String)queryOrder, (int)-1);
    }

    public static DataSet queryInitBalance(MainEntityType ormInitBalanceEntity, List<Long> orgList, MulOrgQPRpt qParam, long yearMinPeriodId, List<QFilter> initBalanceFilters, List<String> groupFields, List<String> initBalanceSelectors) {
        long bookTypeId = qParam.getBookType();
        long endPeriod = qParam.getEndPeriod();
        if (CollectionUtils.isEmpty(orgList) || bookTypeId == 0L) {
            return null;
        }
        List bookList = BDUtil.getBookFromAccSys(new HashSet<Long>(orgList), (long)bookTypeId);
        HashMap<Long, Long> startMap = new HashMap<Long, Long>();
        HashSet<Long> startPeriodIds = new HashSet<Long>(10);
        for (AccountBookInfo bookInfo : bookList) {
            long startPeriodId;
            if (!bookInfo.isIsendinit() || (startPeriodId = bookInfo.getStartPeriodId()) < yearMinPeriodId || startPeriodId > endPeriod) continue;
            long orgId = bookInfo.getOrgId();
            startMap.put(orgId, startPeriodId);
            startPeriodIds.add(startPeriodId);
        }
        String selPeriod = "id period, periodyear";
        QFilter fperiodId = new QFilter("id", "in", startPeriodIds);
        DataSet startPeriodSet = BalancePureQueryService.getPeriodSet(selPeriod, fperiodId.toArray());
        DataSet orgPeriodSet = BalancePureQueryService.getOrgPeriodDS(startMap);
        startPeriodSet = startPeriodSet.join(orgPeriodSet, JoinType.LEFT).on("period", "period").select(new String[]{"period", "periodyear"}, new String[]{"org"}).finish();
        List refinedSelectFields = initBalanceSelectors.stream().filter(x -> !x.equals("period") && !x.equals("periodyear")).collect(Collectors.toList());
        String mulcur = qParam.getFilterInfo().getString("mulcur");
        String localAmountField = MulCurReportUtil.getInitBalanceLocalAmountFields((String)mulcur);
        String initSel = String.join((CharSequence)",", refinedSelectFields) + ",yeardebitqty,yearcreditqty,yeardebitfor,yearcreditfor,yearprofitdebitqty,yearprofitcreditqty,yearprofitdebitfor,yearprofitcreditfor";
        initSel = initSel + "," + localAmountField;
        ArrayList<String> acctTypes = new ArrayList<String>();
        acctTypes.add("4");
        initBalanceFilters.add(new QFilter("account.accounttype.accounttype", "in", acctTypes));
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_initbalance", (IDataEntityType)ormInitBalanceEntity);
        DataSet initBalanceSet = orm.queryDataSet(BalancePureQueryService.class.getName(), "gl_initbalance", initSel, initBalanceFilters.toArray(new QFilter[0]), null);
        List<String> refinedGroupFields = groupFields.stream().filter(x -> !x.equals("period") && !x.equals("periodyear")).collect(Collectors.toList());
        String groupSel = BalancePureQueryService.sqltList(refinedGroupFields);
        initBalanceSet = initBalanceSet.select(groupSel + ",yeardebitqty-yearprofitdebitqty vdebitqty,yearcreditqty-yearprofitcreditqty vcreditqty,yeardebitfor-yearprofitdebitfor vdebitfor,yearcreditfor-yearprofitcreditfor vcreditfor,yeardebitlocal-yearprofitdebitlocal vdebitlocal,yearcreditlocal-yearprofitcreditlocal vcreditlocal");
        ArrayList<String> initAmountList = new ArrayList<String>();
        initAmountList.addAll(refinedGroupFields);
        initAmountList.addAll(Arrays.asList(vamoutFileds));
        initBalanceSet = initBalanceSet.join(startPeriodSet, JoinType.INNER).on("org", "org").select(initAmountList.toArray(new String[0]), new String[]{"0L period", "periodyear"}).finish();
        initBalanceSet = initBalanceSet.addField("0", "vcount");
        return initBalanceSet;
    }

    private static DataSet getOrgPeriodDS(Map<Long, Long> map) {
        String[] fieldNames = new String[]{"org", "period"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.LongType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        DataSetBuilder builder = Algo.create((String)BalancePureQueryService.class.getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            builder.append(new Object[]{entry.getKey(), entry.getValue()});
        }
        return builder.build();
    }

    private static String sqltList(List<String> list) {
        String sel = list.toString();
        return sel.substring(1, sel.length() - 1);
    }

    public List<String> getDSFileds(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> result = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            String alias = field.getAlias();
            result.add(alias);
        }
        return result;
    }

    private DataSet actIdToMasterId(DataSet voucherSet) {
        List<String> voucherList = this.getDSFileds(voucherSet);
        if (voucherList.contains("account")) {
            HashSet<Long> acctIds = new HashSet<Long>(100);
            for (Row row : voucherSet.copy()) {
                long acctId = row.getLong("account");
                acctIds.add(acctId);
            }
            DataSet acctSet = BalancePureQueryService.getAccountSet("id, masterid account", new QFilter("id", "in", acctIds));
            List<String> fieldList = this.getDSFileds(voucherSet);
            fieldList.remove("account");
            voucherSet = voucherSet.join(acctSet, JoinType.INNER).on("account", "id").select(fieldList.toArray(new String[0]), new String[]{"account"}).finish();
        }
        return voucherSet;
    }

    private static DataSet getAccountSet(String selector, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)(BalancePureQueryService.class.getName() + ".account"), (String)"bd_accountview", (String)selector, (QFilter[])filter.toArray(), null);
    }

    private static DataSet getPeriodSet(String selector, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)(BalancePureQueryService.class.getName() + ".period"), (String)"bd_period", (String)selector, (QFilter[])filters, null);
    }
}

