/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.service.balance.account.AccountTreeModel;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.TreeNodeRelationFactory;
import kd.fi.gl.report.assistbalance.AccIDSumUpTree;
import kd.fi.gl.report.assistbalance.model.AssistBalanceAmountRow;
import kd.fi.gl.report.assistbalance.model.AssistBalanceKey;
import kd.fi.gl.report.assistbalance.model.BalanceRow;

public class BalanceSumUpService {
    private static final Log LOG = LogFactory.getLog(BalanceSumUpService.class);
    public static final long MOCK_ACC_ROOT = -999L;
    private final Map<Long, List<BiTreeNode.TreeNodeRelation<Long>>> _orgNumReleationsIndex;
    private final Map<Long, AccIDSumUpTree> orgAccTreeMap;

    public BalanceSumUpService(Map<AccountTreeModel.OrgAccMidKey, BiTreeNode.TreeNodeRelation<Long>> orgAccRelations) {
        HashMap orgAccParentIndex = new HashMap(8);
        for (Map.Entry<AccountTreeModel.OrgAccMidKey, BiTreeNode.TreeNodeRelation<Long>> entry : orgAccRelations.entrySet()) {
            Long accId = (Long)entry.getValue().getSelf();
            Long accParentId = (Long)entry.getValue().getParent();
            long orgId = entry.getKey().getOrgId();
            if (null == orgAccParentIndex.get(orgId)) {
                orgAccParentIndex.put(orgId, new HashMap(1));
            }
            ((Map)orgAccParentIndex.get(orgId)).put(accId, accParentId);
        }
        this._orgNumReleationsIndex = new HashMap<Long, List<BiTreeNode.TreeNodeRelation<Long>>>(8);
        for (Map.Entry<Object, Object> entry : orgAccParentIndex.entrySet()) {
            long orgId = (Long)entry.getKey();
            Map accParentMap = (Map)orgAccParentIndex.get(orgId);
            List nodeRelations = accParentMap.entrySet().stream().map(x -> {
                long accId = (Long)x.getKey();
                Long parentAccId = (Long)x.getValue();
                return TreeNodeRelationFactory.get().getTreeNodeRelation(Long.valueOf(accId), parentAccId);
            }).collect(Collectors.toList());
            nodeRelations.stream().filter(x -> null == x.getParent()).forEach(x -> x.setParent((Object)-999L));
            nodeRelations.add(TreeNodeRelationFactory.get().getTreeNodeRelation(Long.valueOf(-999L), null));
            this._orgNumReleationsIndex.put(orgId, nodeRelations);
        }
        this.orgAccTreeMap = new HashMap<Long, AccIDSumUpTree>(1024);
    }

    public void accept(AssistBalanceKey balanceKey, AssistBalanceAmountRow amountRow) {
        AccIDSumUpTree tree;
        long orgId = balanceKey.getOrgId();
        if (!this.orgAccTreeMap.containsKey(orgId)) {
            tree = new AccIDSumUpTree(this._orgNumReleationsIndex.get(balanceKey.getOrgId()));
            this.orgAccTreeMap.put(orgId, tree);
        }
        tree = this.orgAccTreeMap.get(orgId);
        tree.accept(balanceKey.getTreeGroupKey(), new BalanceRow(balanceKey, amountRow));
    }

    public List<BalanceRow> collectAllAndClear() {
        if (DebugTrace.enable()) {
            LOG.info("{} build sumup tree size: {}", (Object)this.getClass().getSimpleName(), (Object)this.orgAccTreeMap.size());
        }
        ArrayList<BalanceRow> result = new ArrayList<BalanceRow>(this.orgAccTreeMap.size() * 5);
        for (Map.Entry<Long, AccIDSumUpTree> orgAccTreeEntry : this.orgAccTreeMap.entrySet()) {
            AccIDSumUpTree oneTree = orgAccTreeEntry.getValue();
            result.addAll(oneTree.collectAll());
            oneTree.clearAllKeyData();
        }
        return result;
    }

    public void executeSumUp() {
        for (Map.Entry<Long, AccIDSumUpTree> orgAccTreeEntry : this.orgAccTreeMap.entrySet()) {
            orgAccTreeEntry.getValue().sumUpAll();
        }
    }

    public long getTopAccountId(long orgId, long accountId) {
        if (!this.orgAccTreeMap.containsKey(orgId)) {
            AccIDSumUpTree tree = new AccIDSumUpTree(this._orgNumReleationsIndex.get(orgId));
            this.orgAccTreeMap.put(orgId, tree);
            return tree.getTopAccountId(accountId);
        }
        AccIDSumUpTree tree = this.orgAccTreeMap.get(orgId);
        return tree.getTopAccountId(accountId);
    }
}

