/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import kd.bos.exception.KDBizException;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.enums.CurrencyType;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.RateVO;
import kd.fi.gl.report.assistbalance.model.BalanceUnitVO;
import kd.fi.gl.report.assistbalance.model.RawBalanceRow;

public class AssistBalanceAmountRow
implements Cloneable,
Serializable {
    private static final MathContext MATCH_CONTEXT = new MathContext(4, RoundingMode.HALF_DOWN);
    private final Optional<BalanceUnitVO> origin;
    private final BalanceUnitVO local;
    private final Optional<BalanceUnitVO> qty;
    private Optional<BalanceUnitVO> rpt;
    private int ventryCount = 0;

    public AssistBalanceAmountRow(BalanceUnitVO origin, BalanceUnitVO local, BalanceUnitVO qty, RateVO rptRate, int ventryCount) {
        this.origin = Optional.ofNullable(origin);
        this.local = local;
        this.qty = Optional.ofNullable(qty);
        this.ventryCount = ventryCount;
        this._generateRpt(rptRate);
    }

    private AssistBalanceAmountRow(BalanceUnitVO origin, BalanceUnitVO local, BalanceUnitVO qty, BalanceUnitVO rpt, int ventryCount) {
        this.origin = Optional.ofNullable(origin);
        this.local = local;
        this.qty = Optional.ofNullable(qty);
        this.rpt = Optional.ofNullable(rpt);
        this.ventryCount = ventryCount;
    }

    public AssistBalanceAmountRow(boolean isShowByDC, int accountDc, boolean isShowOrigin, boolean isShowQty, RawBalanceRow balanceRow, RateVO rptRate, int ventryCount) {
        this.origin = isShowOrigin ? Optional.of(new BalanceUnitVO(CurrencyType.Origin, isShowByDC, accountDc, balanceRow.debitfor, balanceRow.creditfor, balanceRow.beginfor, balanceRow.endfor, balanceRow.yeardebitfor, balanceRow.yearcreditfor)) : Optional.empty();
        this.local = new BalanceUnitVO(CurrencyType.Local, isShowByDC, accountDc, balanceRow.debitlocal, balanceRow.creditlocal, balanceRow.beginlocal, balanceRow.endlocal, balanceRow.yeardebitlocal, balanceRow.yearcreditlocal);
        this.qty = !isShowQty ? Optional.empty() : Optional.of(new BalanceUnitVO(CurrencyType.Qty, isShowByDC, accountDc, balanceRow.debitqty, balanceRow.creditqty, balanceRow.beginqty, balanceRow.endqty, balanceRow.yeardebitqty, balanceRow.yearcreditqty));
        this._generateRpt(rptRate);
        this.ventryCount = ventryCount;
    }

    private void _generateRpt(RateVO rptRate) {
        if (null == rptRate) {
            this.rpt = Optional.empty();
        } else {
            this.rpt = Optional.of(new BalanceUnitVO(CurrencyType.Rpt));
            BalanceUnitVO rptVO = this.rpt.get();
            if (RateType.DIRECT_RATE == rptRate.getRateType()) {
                rptVO.setDebit(this.local.getDebit().multiply(rptRate.getRateValue()));
                rptVO.setCredit(this.local.getCredit().multiply(rptRate.getRateValue()));
                rptVO.setBeginDebit(this.local.getBeginDebit().multiply(rptRate.getRateValue()));
                rptVO.setBeginCredit(this.local.getBeginCredit().multiply(rptRate.getRateValue()));
                rptVO.setYearDebit(this.local.getYearDebit().multiply(rptRate.getRateValue()));
                rptVO.setYearCredit(this.local.getYearCredit().multiply(rptRate.getRateValue()));
                rptVO.setYearBeginDebit(this.local.getYearBeginDebit().multiply(rptRate.getRateValue()));
                rptVO.setYearBeginCredit(this.local.getYearBeginCredit().multiply(rptRate.getRateValue()));
                rptVO.setEndDebit(this.local.getEndDebit().multiply(rptRate.getRateValue()));
                rptVO.setEndCredit(this.local.getEndCredit().multiply(rptRate.getRateValue()));
            } else {
                rptVO.setDebit(this.local.getDebit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setCredit(this.local.getCredit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setBeginDebit(this.local.getBeginDebit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setBeginCredit(this.local.getBeginCredit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setYearDebit(this.local.getYearDebit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setYearCredit(this.local.getYearCredit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setYearBeginDebit(this.local.getYearBeginDebit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setYearBeginCredit(this.local.getYearBeginCredit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setEndDebit(this.local.getEndDebit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
                rptVO.setEndCredit(this.local.getEndCredit().divide(rptRate.getRateValue(), MATCH_CONTEXT));
            }
        }
    }

    public void autoAdjustByAmountDc() {
        if (this.origin.isPresent()) {
            this.origin.get().autoAdjustByAmountDc();
        }
        this.local.autoAdjustByAmountDc();
        if (this.qty.isPresent()) {
            this.qty.get().autoAdjustByAmountDc();
        }
        if (this.rpt.isPresent()) {
            this.rpt.get().autoAdjustByAmountDc();
        }
    }

    public void autoAdjustAmount(boolean isShowByDC, int dc) {
        if (this.origin.isPresent()) {
            this.origin.get().autoAdjustAmount(isShowByDC, dc);
        }
        this.local.autoAdjustAmount(isShowByDC, dc);
        if (this.qty.isPresent()) {
            this.qty.get().autoAdjustAmount(isShowByDC, dc);
        }
        if (this.rpt.isPresent()) {
            this.rpt.get().autoAdjustAmount(isShowByDC, dc);
        }
    }

    public boolean isBalanceNotEqZero() {
        if (this.local.isBalanceNotEqZero()) {
            return true;
        }
        if (this.origin.isPresent() && this.origin.get().isBalanceNotEqZero()) {
            return true;
        }
        return this.qty.isPresent() && this.qty.get().isBalanceNotEqZero();
    }

    public AssistBalanceAmountRow clone() throws CloneNotSupportedException {
        BalanceUnitVO origin = this.origin.isPresent() ? this.origin.get().clone() : null;
        BalanceUnitVO local = this.local.clone();
        BalanceUnitVO qty = this.qty.isPresent() ? this.qty.get().clone() : null;
        BalanceUnitVO rpt = this.rpt.isPresent() ? this.rpt.get().clone() : null;
        return new AssistBalanceAmountRow(origin, local, qty, rpt, this.ventryCount);
    }

    public AssistBalanceAmountRow negate() {
        if (this.origin.isPresent()) {
            this.origin.get().negate();
        }
        this.local.negate();
        if (this.qty.isPresent()) {
            this.qty.get().negate();
        }
        if (this.rpt.isPresent()) {
            this.rpt.get().negate();
        }
        return this;
    }

    public void resetToZero() {
        if (this.origin.isPresent()) {
            this.origin.get().resetToZero();
        }
        this.local.resetToZero();
        if (this.qty.isPresent()) {
            this.qty.get().resetToZero();
        }
        if (this.rpt.isPresent()) {
            this.rpt.get().resetToZero();
        }
        this.ventryCount = 0;
    }

    public void merge(AssistBalanceAmountRow anotherRow) {
        if (this == anotherRow) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        this.merge(anotherRow, false);
    }

    public void merge(AssistBalanceAmountRow anotherRow, boolean isSkipOriginCurrency) {
        if (this.origin.isPresent() && !isSkipOriginCurrency) {
            this.origin.get().merge(anotherRow.origin.get());
        }
        this.local.merge(anotherRow.local);
        if (this.qty.isPresent()) {
            this.qty.get().merge(anotherRow.qty.get());
        }
        if (this.rpt.isPresent()) {
            this.rpt.get().merge(anotherRow.getRpt().get());
        }
        this.ventryCount += anotherRow.ventryCount;
    }

    public Optional<BalanceUnitVO> getOrigin() {
        return this.origin;
    }

    public BalanceUnitVO getLocal() {
        return this.local;
    }

    public Optional<BalanceUnitVO> getRpt() {
        return this.rpt;
    }

    public Optional<BalanceUnitVO> getQty() {
        return this.qty;
    }

    public int getVentryCount() {
        return this.ventryCount;
    }

    public String toString() {
        return "{" + (this.origin.isPresent() ? "origin=" + this.origin.get() : "") + ", local=" + this.local + (this.qty.isPresent() ? ", qty=" + this.qty.get() : "") + (this.rpt.isPresent() ? ", rpt=" + this.rpt.get() : "") + ", ventryCount=" + this.ventryCount + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistBalanceAmountRow amountRow = (AssistBalanceAmountRow)o;
        return Objects.equals(this.origin, amountRow.origin) && Objects.equals(this.local, amountRow.local) && Objects.equals(this.qty, amountRow.qty) && Objects.equals(this.rpt, amountRow.rpt) && this.ventryCount == amountRow.ventryCount;
    }
}

