/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.assistbalance.model.AssistBalanceAmountRow;
import kd.fi.gl.report.assistbalance.model.AssistBalanceKey;
import kd.fi.gl.report.assistbalance.model.AssistTreeCategoryVO;
import kd.fi.gl.report.assistbalance.model.BalanceRow;
import kd.fi.gl.report.assistbalance.model.SubtotalType;
import kd.fi.gl.util.FastKey;

public class AssistBalanceSubtotal
implements Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(AssistBalanceSubtotal.class);
    private final SubtotalType type;
    private final Object distinguishKey;
    private final FastKey groupKey;
    private final AssistBalanceKey sampleBalanceKey;
    private AssistBalanceAmountRow amount;
    private List<AssistBalanceSubtotal> nestSubtotals = new ArrayList<AssistBalanceSubtotal>(2);
    private AssistTreeCategoryVO assistTreeCategoryVO = null;
    private AssistBalanceSubtotal parentPoint;
    private List<BalanceRow> detailRows = new ArrayList<BalanceRow>(8);

    public AssistBalanceSubtotal(SubtotalType type, AssistBalanceKey balanceKey, FastKey groupKey) {
        this.type = type;
        this.sampleBalanceKey = balanceKey;
        this.groupKey = groupKey;
        if (SubtotalType.Account == type) {
            this.distinguishKey = balanceKey.getAccountId();
        } else if (SubtotalType.Org == type) {
            this.distinguishKey = balanceKey.getOrgId();
        } else if (SubtotalType.Currency == type) {
            this.distinguishKey = balanceKey.currencyId;
        } else if (SubtotalType.MeasureUnit == type) {
            this.distinguishKey = balanceKey.measureUnitId;
        } else if (SubtotalType.ComAssist == type) {
            this.distinguishKey = balanceKey.comAssistVals;
        } else if (SubtotalType.Total == type) {
            this.distinguishKey = 0L;
        } else {
            throw new KDBizException(GLErrorCode.NOT_IMPLEMENT, new Object[0]);
        }
    }

    public void accept(BalanceRow entry, boolean isSkipOriginCurrency) {
        if (null == this.amount) {
            try {
                this.amount = entry.getAmount().clone();
                this.amount.resetToZero();
            }
            catch (CloneNotSupportedException e) {
                LOG.error("failed to clone on :" + e.getMessage(), (Throwable)e);
                throw new KDBizException("failed to clone:" + e.getMessage());
            }
        }
        this.amount.merge(entry.getAmount(), isSkipOriginCurrency);
        this.detailRows.add(entry);
    }

    public List<AssistBalanceSubtotal> collect() {
        ArrayList<AssistBalanceSubtotal> items = new ArrayList<AssistBalanceSubtotal>(2);
        items.add(this);
        for (AssistBalanceSubtotal nestItem : this.nestSubtotals) {
            nestItem.setAssistTreeCategoryVO(this.assistTreeCategoryVO);
            items.addAll(nestItem.collect());
        }
        return items;
    }

    public AssistBalanceSubtotal clone() throws CloneNotSupportedException {
        AssistBalanceSubtotal clone = new AssistBalanceSubtotal(this.type, this.sampleBalanceKey, this.groupKey);
        clone.amount = this.amount.clone();
        if (!CollectionUtils.isEmpty(this.nestSubtotals)) {
            clone.nestSubtotals = this.nestSubtotals.stream().map(x -> {
                try {
                    return x.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new KDBizException("AssistBalanceSubtotal clone failed. ");
                }
            }).collect(Collectors.toList());
        }
        return clone;
    }

    public void merge(AssistBalanceSubtotal another) {
        if (this.getType() != another.getType()) {
            throw new KDBizException("can not merge with differ subtotal type:" + (Object)((Object)this.getType()) + " vs. " + (Object)((Object)another.getType()));
        }
        this.amount.merge(another.getAmount());
        if (!CollectionUtils.isEmpty(this.nestSubtotals)) {
            SubtotalType type = this.nestSubtotals.get(0).getType();
            if (this.nestSubtotals.stream().anyMatch(x -> type != x.getType())) {
                LOG.error("inconsistent subtotal type:" + this.nestSubtotals);
                throw new KDBizException("logic error: inconsistent subtotal type");
            }
            Map<Object, AssistBalanceSubtotal> mySubtotalMap = this.nestSubtotals.stream().collect(Collectors.toMap(x -> x.distinguishKey, x -> x));
            for (AssistBalanceSubtotal anotherTotal : another.getNestSubtotals()) {
                if (!mySubtotalMap.containsKey(anotherTotal.distinguishKey)) {
                    try {
                        this.nestSubtotals.add(anotherTotal.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        LOG.error("failed to clone on :" + e.getMessage(), (Throwable)e);
                        throw new KDBizException("failed to clone:" + e.getMessage());
                    }
                }
                mySubtotalMap.get(anotherTotal.distinguishKey).merge(anotherTotal);
            }
            Collections.sort(this.nestSubtotals, new Comparator<AssistBalanceSubtotal>(){

                @Override
                public int compare(AssistBalanceSubtotal o1, AssistBalanceSubtotal o2) {
                    return String.valueOf(o1.distinguishKey).compareTo(String.valueOf(o2.distinguishKey));
                }
            });
        }
    }

    public AssistTreeCategoryVO getAssistTreeCategoryVO() {
        return this.assistTreeCategoryVO;
    }

    public void setAssistTreeCategoryVO(AssistTreeCategoryVO assistTreeCategoryVO) {
        this.assistTreeCategoryVO = assistTreeCategoryVO;
    }

    public AssistBalanceAmountRow getAmount() {
        return this.amount;
    }

    public void setAmount(AssistBalanceAmountRow amount) {
        this.amount = amount;
    }

    public void clearDetailRows() {
        if (null != this.detailRows) {
            this.detailRows.clear();
        }
        for (AssistBalanceSubtotal oneNestSubtotal : this.nestSubtotals) {
            oneNestSubtotal.clearDetailRows();
        }
    }

    public int estimateTargetRowCount() {
        return 1 + this.nestSubtotals.stream().mapToInt(x -> x.estimateTargetRowCount()).sum();
    }

    public String toString() {
        return "SubtotalType: " + (Object)((Object)this.type) + " | " + this.groupKey + " | " + this.distinguishKey + ", Value:" + this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistBalanceSubtotal that = (AssistBalanceSubtotal)o;
        return this.groupKey.equals((Object)that.groupKey);
    }

    public void setParentPoint(AssistBalanceSubtotal parentPoint) {
        this.parentPoint = parentPoint;
    }

    public AssistBalanceSubtotal getParentPoint() {
        return this.parentPoint;
    }

    public int hashCode() {
        return Objects.hash(this.groupKey);
    }

    public AssistBalanceKey getSampleBalanceKey() {
        return this.sampleBalanceKey;
    }

    public List<AssistBalanceSubtotal> getNestSubtotals() {
        return this.nestSubtotals;
    }

    public void setNestSubtotals(List<AssistBalanceSubtotal> nestSubtotals) {
        this.nestSubtotals = nestSubtotals;
    }

    public List<BalanceRow> getDetailRows() {
        return this.detailRows;
    }

    public SubtotalType getType() {
        return this.type;
    }
}

