/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.fi.gl.report.assistbalance.model.TreeGroupKey;
import kd.fi.gl.util.MultiIndexTreeCache;

public class BalanceAggregateKey {
    private static final String _CACHE_KEY = "fi.gl.assistbalance.balanceaggregatekey.cache";
    public static int INIT_COUNT = 0;
    private final List<Object> assistValues;
    private final Long measureUnitId;

    private BalanceAggregateKey(TreeGroupKey treeGroupKey) {
        ++INIT_COUNT;
        this.assistValues = treeGroupKey.getAssistValues();
        this.measureUnitId = treeGroupKey.getMeasureUnitId();
    }

    public static BalanceAggregateKey retrievalFromCacheOrBuild(TreeGroupKey treeGroupKey) {
        Object[] factorArray;
        BalanceAggregateKey value;
        MultiIndexTreeCache _keyCache = (MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY, () -> new MultiIndexTreeCache("BalanceAggregateKey", 100000));
        ArrayList<Object> _factors = new ArrayList<Object>(6);
        _factors.addAll(treeGroupKey.getAssistValues());
        if (null != treeGroupKey.getMeasureUnitId()) {
            _factors.add(treeGroupKey.getMeasureUnitId());
        }
        if (null != (value = (BalanceAggregateKey)_keyCache.retrieval(factorArray = _factors.toArray()))) {
            return value;
        }
        BalanceAggregateKey aggregateKey = new BalanceAggregateKey(treeGroupKey);
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).addData((Object)aggregateKey, factorArray);
        return aggregateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceAggregateKey that = (BalanceAggregateKey)o;
        return this.assistValues.equals(that.assistValues) && Objects.equals(this.measureUnitId, that.measureUnitId);
    }

    public int hashCode() {
        return Objects.hash(this.assistValues, this.measureUnitId);
    }

    public String toString() {
        return "BalanceAggregateKey{assistValues=" + this.assistValues + ", measureUnitId=" + this.measureUnitId + '}';
    }

    public static void clearAll() {
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).clearAll();
    }
}

