/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.cashflow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.business.BDGLServiceFactory;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.interfaces.service.ICashFlowItemService;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.dataset.GroupKey;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.CashFlowQueryParam;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.SumSchema;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.GLUtil;

public class CashFlowCollector
implements ICollector {
    private static final Log logger = LogFactory.getLog(CashFlowCollector.class);
    private final ICashFlowItemService cashFlowItemService = (ICashFlowItemService)BDGLServiceFactory.getService(ICashFlowItemService.class);
    public static final String ORDER_S = "\u3001";
    private final SumSchema sumSchema;
    private final Map<Object, TreeNode> cfMasterIdMap;
    private Map<Object, TreeNode> cfNumMap;
    private Map<Object, TreeNode> allCfIdMap;
    private final RowMeta rowMeta;
    private final CashFlowQueryParam qpRpt;
    private int cfitemIndex;
    private Set<String> comassists;
    Map<Long, Boolean> masterIsassistMap;
    private Map<String, String> errorMap = new HashMap<String, String>();
    private RowMeta outPutAccountRowMeta;
    private final SumSchema accountSumSchema;
    private Map<Object, TreeNode> accIdMap;
    private Map<Long, Tuple<Long, Object[]>> versionCfItemMap;
    private DataSet addVersionItemDs;

    public CashFlowCollector(CollectorParam param, RowMeta accRowMeta, SumSchema accountSumSchema, Set<String> comassistSet, long org, long endPeriod, Map<Object, TreeNode> numMap, Map<Object, TreeNode> msterIdMap) {
        this.cfMasterIdMap = param.getAccMasterIdMap();
        this.rowMeta = param.getRowMeta();
        this.outPutAccountRowMeta = accRowMeta;
        this.accountSumSchema = accountSumSchema;
        this.sumSchema = param.getSumSchema();
        this.qpRpt = (CashFlowQueryParam)param.getParam();
        this.cfitemIndex = this.rowMeta.getFieldIndex("cfitem", false);
        this.masterIsassistMap = this.getCashMasteridToIsassist(this.qpRpt.getPorg(), endPeriod);
        this.comassists = comassistSet;
        this.versionCfItemMap = new HashMap<Long, Tuple<Long, Object[]>>();
        if (!this.qpRpt.isQueryFromInit()) {
            Map addNewVersionCfItems = CashFlowItemHelper.getAddNewVersionCfItems((long)org, (long)endPeriod);
            addNewVersionCfItems.forEach((id, masterid) -> this.versionCfItemMap.put((Long)masterid, (Tuple<Long, Object[]>)new Tuple(id, (Object)new Object[]{id, DB.genLongId((String)"gl_cashflowitem")})));
            if (!CollectionUtils.isEmpty(this.versionCfItemMap)) {
                ArrayList<Field> fieldList = new ArrayList<Field>();
                fieldList.add(new Field("versionid", (DataType)DataType.LongType));
                fieldList.add(new Field("versionmasterid", (DataType)DataType.LongType));
                RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
                this.addVersionItemDs = Algo.create((String)this.getClass().getName()).createDataSet(this.versionCfItemMap.values().stream().map(m -> (Object[])m.item2).collect(Collectors.toSet()).iterator(), rowMeta);
            }
        }
        this.cfNumMap = numMap;
        this.allCfIdMap = msterIdMap;
    }

    public void putData(DataSet dataSource, OutPutFunction cashFlowOutPut) {
        for (Row row : dataSource) {
            cashFlowOutPut.output(row, this);
        }
    }

    @Override
    public void collect(Object[] data) {
        this.collectIt(data);
    }

    @Override
    public void addSelector(ISelector selector) {
    }

    private void collectIt(Object[] value) {
        boolean isOutPutLeaf = this.cfMasterIdMap.containsKey(value[this.cfitemIndex]);
        TreeNode treeNode = this.cfMasterIdMap.get(value[this.cfitemIndex]);
        Long originalItemMasterId = -1L;
        if (treeNode == null) {
            originalItemMasterId = (Long)value[this.cfitemIndex];
            treeNode = this.allCfIdMap.get(value[this.cfitemIndex]);
            int i = 0;
            while (treeNode != null && this.cfNumMap.get(treeNode.getPropValue("number")) == null) {
                treeNode = this.allCfIdMap.get(treeNode.getId()).getParent();
                if (++i < 15) continue;
                logger.info("foreach 15 time still not found, force quit");
                return;
            }
            if (treeNode == null) {
                logger.error(String.format("\u73b0\u91d1\u6d41\u91cf\u6570\u636e\u5f02\u5e38!masterid=%s,keySet not exist=%s", value[this.cfitemIndex], CollectionUtils.isEmpty(this.cfMasterIdMap) ? null : this.cfMasterIdMap.keySet()));
                return;
            }
            if (this.cfNumMap.containsKey(treeNode.getPropValue("number"))) {
                treeNode = this.cfNumMap.get(treeNode.getPropValue("number"));
            }
            value[this.cfitemIndex] = treeNode.getMasterId();
        } else if (!((Boolean)treeNode.getPropValue("isleaf")).booleanValue()) {
            treeNode.setPropValue("isleaf", (Object)true);
        }
        if (originalItemMasterId > 0L) {
            CashFlowItemVO cashFlowItemVO = this.cashFlowItemService.loadSingle(originalItemMasterId);
            Long parentId = cashFlowItemVO.getParentId();
            treeNode.setPropValue("direction", (Object)cashFlowItemVO.getDirection());
            if (parentId > 0L && cashFlowItemVO.getLeaf().booleanValue()) {
                CashFlowItemVO parentCashFlowItemVO = this.cashFlowItemService.loadSingle(parentId);
                treeNode.setPropValue("negateSum", (Object)("o".equals(cashFlowItemVO.getDirection()) && !cashFlowItemVO.getDirection().equals(parentCashFlowItemVO.getDirection()) ? 1 : 0));
            }
        }
        logger.info("collectIt value : " + Arrays.toString(value) + " ; treeNode : " + treeNode.toString());
        String type = (String)treeNode.getPropValue("type");
        if (type.equals("3")) {
            this.outPutSuppData(value, treeNode);
        } else {
            if (((Boolean)treeNode.getPropValue("isleaf")).booleanValue() || isOutPutLeaf) {
                this.outPutLeafData(value);
            }
            this.outPutParentData(value, treeNode);
            String direction = (String)treeNode.getPropValue("direction");
            if ("o".equals(direction)) {
                Object[] clone = (Object[])value.clone();
                for (int sumIndex : this.sumSchema.getTotalDataSchema().getSumIndex()) {
                    clone[sumIndex] = ((BigDecimal)clone[sumIndex]).negate();
                }
                this.sumSchema.getTotalDataSchema().outPutData(clone);
            } else {
                this.sumSchema.getTotalDataSchema().outPutData(value);
            }
        }
    }

    private Map<Long, Boolean> getCashMasteridToIsassist(Long orgId, long endPeriod) {
        QFilter endDate;
        DynamicObject endPeriodDyn;
        QFilter startDate;
        HashMap<Long, Boolean> masterIsassistMap = new HashMap<Long, Boolean>(16);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DynamicObjectCollection cashflowitems = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"masterid,isassist", (QFilter[])new QFilter[]{baseDataFilter, startDate = new QFilter("startdate", "<=", (Object)(endPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriod, (String)"bd_period")).getDate("enddate")), endDate = new QFilter("enddate", ">", (Object)endPeriodDyn.getDate("enddate"))}, (String)"startdate");
        if (cashflowitems == null || cashflowitems.size() == 0) {
            return masterIsassistMap;
        }
        for (DynamicObject dyn : cashflowitems) {
            masterIsassistMap.put(dyn.getLong("masterid"), dyn.getBoolean("isassist"));
        }
        return masterIsassistMap;
    }

    private void outPutLeafData(Object[] value) {
        if (this.filterCfitemLevel(value)) {
            Object[] copyObject = Arrays.copyOf(value, value.length);
            if (this.versionCfItemMap.containsKey(value[this.cfitemIndex])) {
                copyObject[this.cfitemIndex] = ((Object[])this.versionCfItemMap.get((Object)value[this.cfitemIndex]).item2)[1];
            }
            DataSchema leafDataSchema = this.sumSchema.getLeafDataSchema();
            leafDataSchema.outPutData(copyObject, x -> {
                if (this.qpRpt.isShowAssist()) {
                    Boolean hasAss = this.masterIsassistMap.get(value[this.cfitemIndex]);
                    if (hasAss == null) {
                        hasAss = Boolean.FALSE;
                    }
                    return hasAss != false || this.checkComassist(copyObject);
                }
                return Boolean.TRUE;
            }, true);
            this.outPutDimData(leafDataSchema.getParent(), copyObject);
        }
    }

    private void outPutSuppData(Object[] value, TreeNode treeNode) {
        this.outPutParentDataHelper(value, treeNode, treeNode);
    }

    private void outPutParentData(Object[] value, TreeNode treeNode) {
        if (((Boolean)treeNode.getPropValue("isleaf")).booleanValue()) {
            TreeNode parent = treeNode.getParent();
            if (this.versionCfItemMap.containsKey(treeNode.getMasterId())) {
                parent = treeNode;
            }
            this.outPutParentDataHelper(value, parent, treeNode);
        } else {
            this.outPutParentDataHelper(value, treeNode, treeNode);
        }
    }

    private void outPutParentDataHelper(Object[] value, TreeNode parentNode, TreeNode leafNode) {
        if (parentNode == null) {
            return;
        }
        if (this.filterCfitemLevel(parentNode)) {
            DataSchema parentDataSchema = this.sumSchema.getParentDataSchema();
            Long masterId = parentNode.getMasterId();
            Object[] parentValue = (Object[])value.clone();
            parentValue[this.cfitemIndex] = masterId;
            String leafDirect = (String)leafNode.getPropValue("direction");
            String parentDirect = (String)parentNode.getPropValue("direction");
            boolean reliableNegateSum = Boolean.parseBoolean(String.valueOf(leafNode.getPropValue("negateSum")));
            if (reliableNegateSum || "o".equals(leafDirect) && !leafDirect.equals(parentDirect)) {
                int[] sumIndex;
                for (int index : sumIndex = parentDataSchema.getSumIndex()) {
                    parentValue[index] = ((BigDecimal)parentValue[index]).negate();
                }
            }
            parentDataSchema.outPutData(parentValue);
            this.outPutDimData(parentDataSchema.getParent(), parentValue);
        }
        this.outPutParentDataHelper(value, parentNode.getParent(), leafNode);
    }

    private void outPutDimData(DataSchema schema, Object[] value) {
        if (schema == null) {
            return;
        }
        schema.outPutData(value);
        this.outPutDimData(schema.getParent(), value);
    }

    private boolean filterCfitemLevel(Object[] value) {
        TreeNode treeNode = this.cfMasterIdMap.get(value[this.cfitemIndex]);
        return (Integer)treeNode.getPropValue("level") <= this.qpRpt.getItemLevel();
    }

    private boolean filterCfitemLevel(TreeNode node) {
        return (Integer)node.getPropValue("level") <= this.qpRpt.getItemLevel();
    }

    @Override
    public DataSet finish() {
        logger.info("finish---create");
        Collection<Object[]> values = this.accountSumSchema.getLeafDataSchema().getData().values();
        DataSet accBalance = Algo.create((String)this.getClass().getName()).createDataSet(values.iterator(), this.outPutAccountRowMeta);
        DataSet finish = this.finish(accBalance);
        logger.info("finish--end");
        long currency = this.qpRpt.getCurrency();
        finish = finish.addField(currency + "L ", "currencyid");
        return finish;
    }

    private DataSet finish(DataSet accountBalance) {
        logger.info("finish start--putAll");
        HashMap<GroupKey, Object[]> allData = new HashMap<GroupKey, Object[]>();
        this.putAll(allData, this.sumSchema.getLeafDataSchema());
        this.putAll(allData, this.sumSchema.getParentDataSchema());
        logger.info("putAll allDataSize" + allData.size());
        List<Object[]> sort = this.sort(allData);
        DataSet leafDataSet = Algo.create((String)this.getClass().getName()).createDataSet(sort.iterator(), this.rowMeta);
        logger.info("addCashFlowInfo");
        leafDataSet = this.addCashFlowInfo(leafDataSet, false);
        if (this.qpRpt.isNoZeroAmount()) {
            leafDataSet = leafDataSet.filter("type='2' or type='4' or (amount!=0 and amount!=null) or (yearamount!=0 and yearamount!=null)");
        }
        logger.info("gainSecondLevelSet+gainFirstLevelSet");
        DataSet secondLevelSet = this.gainSecondLevelSet(leafDataSet);
        DataSet firstLevelSet = this.gainFirstLevelSet(leafDataSet);
        leafDataSet = this.clearData(leafDataSet).union(secondLevelSet).union(firstLevelSet);
        logger.info("getNetAmount");
        DataSet netAmount = this.getNetAmount(accountBalance);
        logger.info("orderBy");
        return leafDataSet.union(netAmount).addField("REPLACE(longnumber, '@', ' ')", "sortable_longnumber").orderBy(this.getOrder());
    }

    private DataSet clearData(DataSet ds) {
        List dataSetCols = GLUtil.getDataSetCols((DataSet)ds);
        ArrayList<String> sel = new ArrayList<String>();
        for (String col : dataSetCols) {
            if ("amount".equalsIgnoreCase(col) || "yearamount".equalsIgnoreCase(col)) {
                String s = "case when isleaf = false then null else " + col + " end as " + col + "";
                sel.add(s);
                continue;
            }
            sel.add(col);
        }
        return ds.select(sel.toArray(new String[0]));
    }

    private DataSet getNetAmount(DataSet accountBalance) {
        DataSchema totalDataSchema = this.sumSchema.getTotalDataSchema();
        Map<GroupKey, Object[]> data = totalDataSchema.getData();
        if (data.size() == 0) {
            Object[] obj = new Object[this.rowMeta.getFieldCount()];
            data.put(new GroupKey(new Object[0]), obj);
        }
        DataSet total = Algo.create((String)this.getClass().getName()).createDataSet(data.values().iterator(), this.rowMeta);
        total = this.addCashFlowInfo(total, true);
        List cols = GLUtil.getDataSetCols((DataSet)total);
        ArrayList<Object> sel = new ArrayList<Object>();
        for (String col : cols) {
            if ("longnumber".equals(col = col.toLowerCase(Locale.ENGLISH))) {
                sel.add("'\u3001' longnumber");
                continue;
            }
            if ("name".equals(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269\u51c0\u589e\u52a0\u989d%2$s", (String)"CashFlowCollector_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("level".equals(col)) {
                sel.add("1 LEVEL");
                continue;
            }
            if ("type".equals(col)) {
                sel.add("'2' TYPE");
                continue;
            }
            if ("amount".equals(col) || "yearamount".equals(col)) {
                sel.add(col);
                continue;
            }
            sel.add("null " + col);
        }
        DataSet netAmount = total.select(sel.toArray(new String[0]));
        DataSet beginSet = accountBalance.copy().filter("iscash=true or isbank=true or iscasheq=true");
        DynamicObjectCollection accBalance = this.sumDataSet(beginSet);
        BigDecimal beginlocal = BigDecimal.ZERO;
        BigDecimal endlocal = BigDecimal.ZERO;
        BigDecimal yearlocal = BigDecimal.ZERO;
        for (DynamicObject dyn : accBalance) {
            beginlocal = beginlocal.add(dyn.getBigDecimal("beginlocal"));
            endlocal = endlocal.add(dyn.getBigDecimal("endlocal"));
            yearlocal = yearlocal.add(dyn.getBigDecimal("yearlocal"));
        }
        yearlocal = endlocal.subtract(yearlocal);
        sel = new ArrayList();
        for (String col : cols) {
            if ("longnumber".equalsIgnoreCase(col)) {
                sel.add("'\u3001.{' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u52a0\uff1a\u671f\u521d\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269\u4f59\u989d%2$s", (String)"CashFlowCollector_1", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("amount".equalsIgnoreCase(col)) {
                sel.add(beginlocal + " amount");
                continue;
            }
            if ("yearamount".equalsIgnoreCase(col)) {
                sel.add(yearlocal + " yearamount");
                continue;
            }
            if ("level".equalsIgnoreCase(col)) {
                sel.add("2 LEVEL");
                continue;
            }
            if ("type".equalsIgnoreCase(col)) {
                sel.add("'2' TYPE");
                continue;
            }
            sel.add("null " + col);
        }
        DataSet cashAllBegin = netAmount.select(sel.toArray(new String[0]));
        DataSet cashAllEnd = netAmount.union(cashAllBegin).select(new String[]{"amount", "yearamount"}).groupBy(null).sum("amount").sum("yearamount").finish();
        sel = new ArrayList();
        for (String col : cols) {
            if ("longnumber".equalsIgnoreCase(col)) {
                sel.add("'\u3001\u3001' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u671f\u672b\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269\u4f59\u989d%2$s", (String)"CashFlowCollector_2", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("amount".equalsIgnoreCase(col) || "yearamount".equalsIgnoreCase(col)) {
                sel.add(col);
                continue;
            }
            if ("level".equalsIgnoreCase(col)) {
                sel.add("1 LEVEL");
                continue;
            }
            if ("type".equalsIgnoreCase(col)) {
                sel.add("'2' TYPE");
                continue;
            }
            sel.add("null " + col);
        }
        cashAllEnd = cashAllEnd.select(sel.toArray(new String[0]));
        DataSet endSet = accountBalance.copy().filter("iscash=true or isbank=true");
        DynamicObjectCollection endBalance = this.sumDataSet(endSet);
        BigDecimal bdCashBegin = BigDecimal.ZERO;
        BigDecimal bdCashEnd = BigDecimal.ZERO;
        BigDecimal bdCashYear = BigDecimal.ZERO;
        for (Object dyn : endBalance) {
            bdCashBegin = bdCashBegin.add(dyn.getBigDecimal("beginlocal"));
            bdCashEnd = bdCashEnd.add(dyn.getBigDecimal("endlocal"));
            bdCashYear = bdCashYear.add(dyn.getBigDecimal("yearlocal"));
        }
        sel = new ArrayList();
        BigDecimal bdCashAmount = this.qpRpt.isQueryFromInit() ? bdCashBegin : bdCashEnd;
        for (String col : cols) {
            if ("longnumber".equalsIgnoreCase(col)) {
                sel.add("'\u3001.{1' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u73b0\u91d1\u7684\u671f\u672b\u4f59\u989d%2$s", (String)"CashFlowCollector_3", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("amount".equalsIgnoreCase(col)) {
                sel.add(bdCashAmount + " amount");
                continue;
            }
            if ("yearamount".equalsIgnoreCase(col)) {
                sel.add(bdCashAmount + " yearamount");
                continue;
            }
            if ("level".equalsIgnoreCase(col)) {
                sel.add("2 LEVEL");
                continue;
            }
            if ("type".equalsIgnoreCase(col)) {
                sel.add("'4' TYPE");
                continue;
            }
            sel.add(col);
        }
        DataSet cashEnd = cashAllEnd.select(sel.toArray(new String[0]));
        sel = new ArrayList();
        BigDecimal cashYear = bdCashEnd.subtract(bdCashYear);
        for (String col : cols) {
            if ("longnumber".equalsIgnoreCase(col)) {
                sel.add("'\u3001.{2' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u51cf\uff1a\u73b0\u91d1\u7684\u671f\u521d\u4f59\u989d%2$s", (String)"CashFlowCollector_4", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("amount".equalsIgnoreCase(col)) {
                sel.add(bdCashBegin + " amount");
                continue;
            }
            if ("yearamount".equalsIgnoreCase(col)) {
                sel.add(cashYear + " yearamount");
                continue;
            }
            sel.add(col);
        }
        DataSet cashBegin = cashEnd.select(sel.toArray(new String[0]));
        DataSet endEqSet = accountBalance.copy().filter("iscasheq=true");
        DynamicObjectCollection endEqBalance = this.sumDataSet(endEqSet);
        BigDecimal bdCashEQBegin = BigDecimal.ZERO;
        BigDecimal bdCashEQEnd = BigDecimal.ZERO;
        BigDecimal bdCashEQYear = BigDecimal.ZERO;
        for (Object dyn : endEqBalance) {
            bdCashEQBegin = bdCashEQBegin.add(dyn.getBigDecimal("beginlocal"));
            bdCashEQEnd = bdCashEQEnd.add(dyn.getBigDecimal("endlocal"));
            bdCashEQYear = bdCashEQYear.add(dyn.getBigDecimal("yearlocal"));
        }
        BigDecimal bdCashEQAmount = this.qpRpt.isQueryFromInit() ? bdCashEQBegin : bdCashEQEnd;
        sel = new ArrayList();
        for (String col : cols) {
            if ("longnumber".equalsIgnoreCase(col)) {
                sel.add("'\u3001.{3' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u52a0\uff1a\u73b0\u91d1\u7b49\u4ef7\u7269\u7684\u671f\u672b\u4f59\u989d%2$s", (String)"CashFlowCollector_5", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("amount".equalsIgnoreCase(col)) {
                sel.add(bdCashEQAmount + " amount");
                continue;
            }
            if ("yearamount".equalsIgnoreCase(col)) {
                sel.add(bdCashEQAmount + " yearamount");
                continue;
            }
            sel.add(col);
        }
        DataSet cashEQEnd = cashEnd.select(sel.toArray(new String[0]));
        BigDecimal cashEqYear = bdCashEQEnd.subtract(bdCashEQYear);
        sel = new ArrayList();
        for (Object col : cols) {
            if ("longnumber".equalsIgnoreCase((String)col)) {
                sel.add("'\u3001.{4' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase((String)col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u51cf\uff1a\u73b0\u91d1\u7b49\u4ef7\u7269\u7684\u671f\u521d\u4f59\u989d%2$s", (String)"CashFlowCollector_6", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("amount".equalsIgnoreCase((String)col)) {
                sel.add(bdCashEQBegin + " amount");
                continue;
            }
            if ("yearamount".equalsIgnoreCase((String)col)) {
                sel.add(cashEqYear + " yearamount");
                continue;
            }
            sel.add(col);
        }
        DataSet cashEQBegin = cashEnd.select(sel.toArray(new String[0]));
        sel = new ArrayList();
        for (String col : cols) {
            if ("longnumber".equalsIgnoreCase(col)) {
                sel.add("'\u3001' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269\u51c0\u53d8\u52a8\u60c5\u51b5\uff1a%2$s", (String)"CashFlowCollector_7", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("level".equalsIgnoreCase(col)) {
                sel.add("1 LEVEL");
                continue;
            }
            if ("type".equalsIgnoreCase(col)) {
                sel.add("'4' TYPE");
                continue;
            }
            sel.add("null " + col);
        }
        DataSet cashNet = cashEnd.select(sel.toArray(new String[0]));
        BigDecimal bdNetCash = bdCashEnd.subtract(bdCashBegin).add(bdCashEQEnd).subtract(bdCashEQBegin);
        BigDecimal bdNetCashYear = bdCashAmount.subtract(cashYear).add(bdCashEQAmount).subtract(cashEqYear);
        sel = new ArrayList();
        for (String col : cols) {
            if ("longnumber".equalsIgnoreCase(col)) {
                sel.add("'\u3001.\u3001' longnumber");
                continue;
            }
            if ("name".equalsIgnoreCase(col)) {
                sel.add(String.format(ResManager.loadKDString((String)"%1$s\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269\u51c0\u589e\u52a0\u989d%2$s", (String)"CashFlowCollector_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' NAME"));
                continue;
            }
            if ("amount".equalsIgnoreCase(col)) {
                sel.add(bdNetCash + " amount");
                continue;
            }
            if ("yearamount".equalsIgnoreCase(col)) {
                sel.add(bdNetCashYear + " yearamount");
                continue;
            }
            sel.add(col);
        }
        DataSet cashNetSum = cashEnd.select(sel.toArray(new String[0]));
        return netAmount.union(cashAllBegin).union(cashAllEnd).union(cashEnd).union(cashBegin).union(cashEQEnd).union(cashEQBegin).union(cashNet).union(cashNetSum);
    }

    private DynamicObjectCollection sumDataSet(DataSet ds) {
        ds = ds.select(new String[]{"beginlocal", "endlocal", "yearlocal"}).groupBy(null).sum("beginlocal").sum("endlocal").sum("yearlocal").finish();
        return ORM.create().toPlainDynamicObjectCollection(ds);
    }

    private String[] getOrder() {
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("type");
        orderList.add("sortable_longnumber");
        if (this.qpRpt.isShowOrg()) {
            orderList.add("orgid");
        }
        if (this.qpRpt.isShowAssist()) {
            orderList.add("assgrp");
        }
        return orderList.toArray(new String[0]);
    }

    private DataSet gainFirstLevelSet(DataSet dataSet) {
        DataSet result = dataSet.filter("level = 1 and type = '1' and isleaf = false");
        ArrayList<String> sel = new ArrayList<String>();
        for (String col : GLUtil.getDataSetCols((DataSet)result)) {
            String s;
            if ("name".equalsIgnoreCase(col)) {
                s = String.format(ResManager.loadKDString((String)"%1$s\u51c0\u989d%2$s", (String)"CashFlowCollector_8", (String)"fi-gl-report", (Object[])new Object[0]), "name + '", "' NAME");
                sel.add(s);
                continue;
            }
            if ("longnumber".equalsIgnoreCase(col)) {
                s = "longnumber + '@\u3001' longnumber";
                sel.add(s);
                continue;
            }
            if ("level".equalsIgnoreCase(col)) {
                s = "2 LEVEL";
                sel.add(s);
                continue;
            }
            sel.add(col);
        }
        return result.select(sel.toArray(new String[0]));
    }

    private DataSet gainSecondLevelSet(DataSet dataSet) {
        DataSet suppCfDs = dataSet.copy().filter("type = '3' and isleaf = true and isscheduleitem = true").groupBy().sum("amount").sum("yearamount").finish();
        Optional<Object> suppAmount = Optional.empty();
        Optional<Object> suppYearAmount = Optional.empty();
        for (Row row : suppCfDs) {
            suppAmount = Optional.ofNullable(row.getBigDecimal("amount"));
            suppYearAmount = Optional.ofNullable(row.getBigDecimal("yearamount"));
        }
        DataSet result = dataSet.copy().filter("level <> 1 and isleaf = false");
        ArrayList<String> mainSel = new ArrayList<String>(16);
        ArrayList<String> suppSel = new ArrayList<String>(16);
        Iterator iterator = GLUtil.getDataSetCols((DataSet)result).iterator();
        while (iterator.hasNext()) {
            String col;
            String mainCol = col = (String)iterator.next();
            String suppCol = col;
            if ("name".equalsIgnoreCase(col)) {
                mainCol = String.format(ResManager.loadKDString((String)"%1$s\u7ecf\u8425\u6d3b\u52a8\u4ea7\u751f\u7684\u73b0\u91d1\u6d41\u91cf\u51c0\u989d%2$s", (String)"CashFlowCollector_9", (String)"fi-gl-report", (Object[])new Object[0]), "case type when '3' then '", "' else name + '") + String.format(ResManager.loadKDString((String)"\u5c0f\u8ba1%s", (String)"CashFlowCollector_10", (String)"fi-gl-report", (Object[])new Object[0]), "' end as NAME");
                suppCol = String.format(ResManager.loadKDString((String)"'\u7ecf\u8425\u6d3b\u52a8\u4ea7\u751f\u7684\u73b0\u91d1\u6d41\u91cf\u51c0\u989d'%1$s", (String)"CashFlowCollector_11", (String)"fi-gl-report", (Object[])new Object[0]), " as NAME");
            } else if ("longnumber".equalsIgnoreCase(col)) {
                String s;
                mainCol = s = "longnumber + '@\u3001' longnumber";
                suppCol = s;
            } else if ("amount".equalsIgnoreCase(col)) {
                suppCol = suppAmount.orElse(BigDecimal.ZERO).toPlainString() + " amount";
            } else if ("yearamount".equalsIgnoreCase(col)) {
                suppCol = suppYearAmount.orElse(BigDecimal.ZERO).toPlainString() + " yearamount";
            } else if ("level".equalsIgnoreCase(col)) {
                suppCol = "2 level";
            }
            mainSel.add(mainCol);
            suppSel.add(suppCol);
        }
        if (DebugTrace.enable()) {
            logger.info("gainSecondLevelSet dataSet : " + DataSetHelper.printDataSet((DataSet)dataSet));
            logger.info("gainSecondLevelSet mainSel : " + mainSel + " suppSel: " + suppSel);
        }
        DataSet type1 = result.select(mainSel.toArray(new String[0])).filter("type = '1'");
        DataSet suppResult = dataSet.filter("type = '3' and level <> 1 and isleaf = false  and isscheduleitem = true ").orderBy(new String[]{"longnumber desc"}).top(1);
        DataSet type3 = suppResult.select(suppSel.toArray(new String[0]));
        result = type1.union(type3);
        return result;
    }

    private DataSet addCashFlowInfo(DataSet ds, boolean isTotal) {
        DataSet selAllAcctSet = this.getSelAllCashFlowSet();
        if (DebugTrace.enable()) {
            logger.info("addCashFlowInfo selAllAcctSet data : " + DataSetHelper.printDataSet((DataSet)selAllAcctSet));
            logger.info("addCashFlowInfo ds data : " + DataSetHelper.printDataSet((DataSet)ds));
        }
        JoinType joinType = isTotal ? JoinType.LEFT : JoinType.RIGHT;
        ds = ds.join(selAllAcctSet, joinType).on("cfitem", "masterid").select(GLUtil.getDataSetCols((DataSet)ds).toArray(new String[0]), new String[]{"cfitemid", "number", "name", "level", "isleaf", "type", "direction", "parent", "isprefit", "isscheduleitem", "longnumber"}).finish();
        if (this.addVersionItemDs != null) {
            ArrayList<String> dataSetCols = new ArrayList<String>(10);
            for (String col : GLUtil.getDataSetCols((DataSet)ds)) {
                if ("cfitem".equals(col)) {
                    col = "case when versionmasterid is not null then versionid else cfitem end cfitem";
                }
                dataSetCols.add(col);
            }
            ds = ds.join(this.addVersionItemDs, JoinType.LEFT).on("cfitem", "versionmasterid").select(dataSetCols.toArray(new String[0])).finish();
        }
        return ds;
    }

    private DataSet getSelAllCashFlowSet() {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)this.qpRpt.getPorg());
        QFilter levelFilter = new QFilter("level", "<=", (Object)this.qpRpt.getItemLevel());
        DynamicObject endPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)this.qpRpt.getPeriodEndIdByQueryType(), (String)"bd_period");
        QFilter startDate = new QFilter("startdate", "<=", (Object)endPeriod.getDate("enddate"));
        QFilter endDate = new QFilter("enddate", ">", (Object)endPeriod.getDate("enddate"));
        DataSet cfItemDs = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".cfitem"), (String)"gl_cashflowitem", (String)"id cfitemid,longnumber,number,name,level,isleaf,type,parent,direction,isdealactivity,isexchangerate,isprefit,masterid,isscheduleitem", (QFilter[])new QFilter[]{baseDataFilter, levelFilter, startDate, endDate}, null);
        if (!CollectionUtils.isEmpty(this.versionCfItemMap)) {
            DataSet versionCfItemDs = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".cfitem"), (String)"gl_cashflowitem", (String)"id cfitemid,longnumber,number, name,(level+1) level,isleaf,type,parent,direction,isdealactivity,isexchangerate,isprefit,id masterid,isscheduleitem", (QFilter[])new QFilter[]{new QFilter("id", "in", this.versionCfItemMap.values().stream().map(m -> (Long)m.item1).collect(Collectors.toSet()))}, null);
            ArrayList<String> dataSetCols = new ArrayList<String>(10);
            for (String col : GLUtil.getDataSetCols((DataSet)versionCfItemDs)) {
                if ("masterid".equals(col)) {
                    col = "case when versionmasterid is not null then versionmasterid else masterid end masterid";
                }
                dataSetCols.add(col);
            }
            versionCfItemDs = versionCfItemDs.join(this.addVersionItemDs, JoinType.LEFT).on("cfitemid", "versionid").select(dataSetCols.toArray(new String[0])).finish();
            cfItemDs = cfItemDs.union(versionCfItemDs);
        }
        return cfItemDs;
    }

    private void putAll(Map<GroupKey, Object[]> data, DataSchema dataSchema) {
        if (dataSchema != null) {
            Map<GroupKey, Object[]> schemaData = dataSchema.getData();
            for (Map.Entry<GroupKey, Object[]> groupKeyEntry : schemaData.entrySet()) {
                data.compute(groupKeyEntry.getKey(), (k, v) -> {
                    if (v == null) {
                        return (Object[])groupKeyEntry.getValue();
                    }
                    return dataSchema.sum((Object[])v, (Object[])groupKeyEntry.getValue());
                });
            }
            this.putAll(data, dataSchema.getParent());
        }
    }

    private List<Object[]> sort(Map<GroupKey, Object[]> data) {
        return data.entrySet().stream().sorted((e1, e2) -> {
            Object[] k1 = ((GroupKey)e1.getKey()).getIds();
            Object[] k2 = ((GroupKey)e2.getKey()).getIds();
            return (Integer)k1[0] - (Integer)k2[0];
        }).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public Map<String, String> getErrorMap() {
        return this.errorMap;
    }

    public SumSchema getAccountSumSchema() {
        return this.accountSumSchema;
    }

    public RowMeta getOutPutAccountRowMeta() {
        return this.outPutAccountRowMeta;
    }

    public Map<Object, TreeNode> getAccIdMap() {
        return this.accIdMap;
    }

    public void setAccIdMap(Map<Object, TreeNode> accIdMap) {
        this.accIdMap = accIdMap;
    }

    private boolean checkComassist(Object[] value) {
        if (this.qpRpt.isShowComassist()) {
            for (String comassist : this.comassists) {
                int index = this.rowMeta.getFieldIndex(comassist, false);
                if (value.length <= index || value[index] == null || (Long)value[index] == 0L) continue;
                return true;
            }
        }
        return false;
    }
}

