/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.cashflow;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.CashFlowQueryParam;
import kd.fi.gl.report.cashflow.CashFlowCollector;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.SumSchema;

public class CashFlowVouFunction
implements OutPutFunction {
    private static final Log logger = LogFactory.getLog(CashFlowVouFunction.class);
    private int accountIndex;
    private int bookeddateIndex;
    private int orgIdex;
    private int debitlocalIndex;
    private int creditlocalIndex;
    private int maincfitemIndex;
    private int maincfassgrpIndex;
    private int maincfamountIndex;
    private int suppcfitemIndex;
    private int suppcfamountIndex;
    private int opAmountIndex;
    private int opYearAmountIndex;
    private int opCFIndex;
    private int opOrgIndex;
    private int opAssgrpIndex;
    private Date dateBegin;
    private Date dateEnd;
    private Map<Object, TreeNode> cfItemIdMap;
    private RowMeta outPutRowMeta;
    private long profitCF;
    private Set<Long> assgrpIds;
    private int opBBeginlocalIndex;
    private int opBEndlocalIndex;
    private int opBYearlocalIndex;
    private int opBIscashIndex;
    private int opBIsbankIndex;
    private int opBIscasheqIndex;
    private int opAccCount;
    private Map<Integer, Integer> comassistIndex = new HashMap<Integer, Integer>(2);

    public CashFlowVouFunction(RowMeta inputRowMeta, CollectorParam param, Map<Object, TreeNode> cfItemIdMap, Set<Long> assgrpIds, RowMeta outPutAccountRowMeta) {
        CashFlowQueryParam qpRpt = (CashFlowQueryParam)param.getParam();
        this.assgrpIds = assgrpIds;
        this.dateBegin = qpRpt.getDateBegin();
        this.dateEnd = qpRpt.getDateEnd();
        this.cfItemIdMap = cfItemIdMap;
        this.outPutRowMeta = param.getRowMeta();
        this.opAmountIndex = this.outPutRowMeta.getFieldIndex("amount", false);
        this.opYearAmountIndex = this.outPutRowMeta.getFieldIndex("yearamount", false);
        this.opCFIndex = this.outPutRowMeta.getFieldIndex("cfitem", false);
        this.opOrgIndex = this.outPutRowMeta.getFieldIndex("orgid", false);
        this.opAssgrpIndex = this.outPutRowMeta.getFieldIndex("assgrp", false);
        this.accountIndex = inputRowMeta.getFieldIndex("account", false);
        this.bookeddateIndex = inputRowMeta.getFieldIndex("bookeddate", false);
        this.orgIdex = inputRowMeta.getFieldIndex("org", false);
        this.debitlocalIndex = inputRowMeta.getFieldIndex("debitlocal", false);
        this.creditlocalIndex = inputRowMeta.getFieldIndex("creditlocal", false);
        this.maincfitemIndex = inputRowMeta.getFieldIndex("maincfitem", false);
        this.maincfassgrpIndex = inputRowMeta.getFieldIndex("maincfassgrp", false);
        this.maincfamountIndex = inputRowMeta.getFieldIndex("maincfamount", false);
        this.suppcfitemIndex = inputRowMeta.getFieldIndex("suppcfitem", false);
        this.suppcfamountIndex = inputRowMeta.getFieldIndex("suppcfamount", false);
        this.opBBeginlocalIndex = outPutAccountRowMeta.getFieldIndex("beginlocal");
        this.opBEndlocalIndex = outPutAccountRowMeta.getFieldIndex("endlocal");
        this.opBYearlocalIndex = outPutAccountRowMeta.getFieldIndex("yearlocal");
        this.opBIscashIndex = outPutAccountRowMeta.getFieldIndex("iscash");
        this.opBIsbankIndex = outPutAccountRowMeta.getFieldIndex("isbank");
        this.opBIscasheqIndex = outPutAccountRowMeta.getFieldIndex("iscasheq");
        this.opAccCount = outPutAccountRowMeta.getFieldCount();
        for (TreeNode value : cfItemIdMap.values()) {
            if (!((Boolean)value.getPropValue("isprefit")).booleanValue()) continue;
            this.profitCF = value.getMasterId();
            break;
        }
        List commonAssists = ((CashFlowQueryParam)param.getParam()).getCommonAssistKeys();
        for (String comassist : commonAssists) {
            this.comassistIndex.put(inputRowMeta.getFieldIndex(comassist, false), this.outPutRowMeta.getFieldIndex(comassist, false));
        }
    }

    @Override
    public void output(Row row, ICollector collector) {
        Long maincf = row.getLong(this.maincfitemIndex);
        Long suppcf = row.getLong(this.suppcfitemIndex);
        Long org = this.orgIdex == -1 ? null : row.getLong(this.orgIdex);
        Date bookedDate = row.getDate(this.bookeddateIndex);
        if (maincf != 0L) {
            Long assgrp;
            TreeNode treeNode = this.cfItemIdMap.get(maincf);
            maincf = treeNode != null ? Long.valueOf(treeNode.getMasterId()) : CashFlowItemHelper.loadSingle((Long)maincf).getMasterId();
            Long l = assgrp = this.maincfassgrpIndex == -1 ? Long.valueOf(0L) : row.getLong(this.maincfassgrpIndex);
            if (this.assgrpIds == null || this.assgrpIds.contains(assgrp)) {
                this.outputData(row.getBigDecimal(this.maincfamountIndex), maincf, org, assgrp, bookedDate, collector, row);
            }
        }
        if (suppcf != 0L) {
            suppcf = this.cfItemIdMap.get(suppcf).getMasterId();
            this.outputData(row.getBigDecimal(this.suppcfamountIndex), suppcf, org, 0L, bookedDate, collector, row);
        }
        CashFlowCollector cashFlowCollector = (CashFlowCollector)collector;
        Long accId = row.getLong(this.accountIndex);
        TreeNode accNode = cashFlowCollector.getAccIdMap().get(accId);
        if (accNode == null) {
            logger.error(String.format("\u79d1\u76ee\u6570\u636e\u5f02\u5e38!accountId=%s,ketSet not exist=%s", accId, CollectionUtils.isEmpty(cashFlowCollector.getAccIdMap()) ? null : cashFlowCollector.getAccIdMap().keySet()));
            throw new KDBizException("accountid not exist: " + accId);
        }
        int plType = (Integer)accNode.getPropValue("pltype");
        BigDecimal accValue = row.getBigDecimal(this.debitlocalIndex).subtract(row.getBigDecimal(this.creditlocalIndex));
        if (plType != 0 && this.profitCF != 0L) {
            this.outputData(accValue.negate(), this.profitCF, org, 0L, bookedDate, collector, row);
        }
        boolean isCash = (Boolean)accNode.getPropValue("iscash");
        boolean isBank = (Boolean)accNode.getPropValue("isbank");
        boolean isCashEq = (Boolean)accNode.getPropValue("iscasheq");
        if (isCash || isBank || isCashEq) {
            SumSchema accountSumSchema = cashFlowCollector.getAccountSumSchema();
            Object[] accResult = new Object[this.opAccCount];
            BigDecimal cashValue = accValue.negate();
            accResult[this.opBIscashIndex] = isCash;
            accResult[this.opBIsbankIndex] = isBank;
            accResult[this.opBIscasheqIndex] = isCashEq;
            for (Map.Entry<Integer, Integer> entry : this.comassistIndex.entrySet()) {
                int inIndex = entry.getKey();
                if (inIndex == -1) continue;
                accResult[entry.getValue().intValue()] = row.get(inIndex);
            }
            if (bookedDate.compareTo(this.dateBegin) < 0) {
                accResult[this.opBBeginlocalIndex] = cashValue.negate();
                accResult[this.opBEndlocalIndex] = BigDecimal.ZERO;
                accResult[this.opBYearlocalIndex] = BigDecimal.ZERO;
                accountSumSchema.getLeafDataSchema().outPutData(accResult);
            } else if (bookedDate.compareTo(this.dateEnd) > 0) {
                accResult[this.opBBeginlocalIndex] = BigDecimal.ZERO;
                accResult[this.opBEndlocalIndex] = cashValue;
                accResult[this.opBYearlocalIndex] = cashValue;
                accountSumSchema.getLeafDataSchema().outPutData(accResult);
            }
        }
    }

    private void outputData(BigDecimal value, Long cfItem, Long org, Long assgrp, Date bookedDate, ICollector collector, Row row) {
        Object[] result = new Object[this.outPutRowMeta.getFieldCount()];
        result[this.opCFIndex] = cfItem;
        if (this.opOrgIndex != -1) {
            result[this.opOrgIndex] = org;
        }
        if (this.opAssgrpIndex != -1) {
            result[this.opAssgrpIndex] = assgrp;
        }
        if (bookedDate.compareTo(this.dateBegin) < 0) {
            result[this.opAmountIndex] = value.negate();
            result[this.opYearAmountIndex] = BigDecimal.ZERO;
        } else if (bookedDate.compareTo(this.dateEnd) > 0) {
            result[this.opAmountIndex] = value.negate();
            result[this.opYearAmountIndex] = value.negate();
        }
        for (Map.Entry<Integer, Integer> entry : this.comassistIndex.entrySet()) {
            int inIndex = entry.getKey();
            if (inIndex == -1) continue;
            result[entry.getValue().intValue()] = row.get(inIndex);
        }
        collector.collect(result);
    }
}

