/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.dataset.GroupKey;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.IReportQuery;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.OutPutIndex;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.common.SumSchema;
import kd.fi.gl.util.GLUtil;

public abstract class AbstractCollector
implements ICollector {
    private static final Log logger = LogFactory.getLog(AbstractCollector.class);
    private static final int PARALLELISM = 4;
    private Map<String, String> errorMap = new HashMap<String, String>();
    private IReportQuery reportQuery;
    private SumSchema sumSchema;
    private QueryParamRpt qpRpt;
    private OutPutIndex fieldIndex;
    private int accountIndex;
    private List<ISelector> selectors;
    private static final int MAX_SIZE = 262144;

    public AbstractCollector(IReportQuery reportQuery) {
        this.reportQuery = reportQuery;
        this.sumSchema = reportQuery.getSumSchema();
        this.qpRpt = reportQuery.getQueryParam();
        this.fieldIndex = reportQuery.getOutPutIndex();
        this.accountIndex = this.fieldIndex.getAccountIndex();
        this.selectors = new ArrayList<ISelector>();
    }

    @Override
    public void addSelector(ISelector selector) {
        this.selectors.add(selector);
    }

    @Override
    public void collect(Object[] data) {
        if (this.isDifYearAndZero(data)) {
            return;
        }
        TreeNode account = this.reportQuery.getMasterIdMap().get(data[this.accountIndex]);
        if (account != null) {
            data[this.accountIndex] = this.reportQuery.getMasterIdMap().get(data[this.accountIndex]).getId();
            this.outPutRawData(data);
        } else {
            account = this.reportQuery.getAllMasterIdMap().get(data[this.accountIndex]);
            int i = 0;
            while (account != null && this.reportQuery.getAccNumIdMap().get(account.getPropValue("number")) == null) {
                account = this.reportQuery.getAllMasterIdMap().get(account.getId()).getParent();
                if (++i < 15) continue;
                logger.info("foreach 15 time still not found, force quit");
                return;
            }
            if (account == null) {
                logger.info("masterid " + data[this.accountIndex] + "not found!");
                return;
            }
            if (this.reportQuery.getIdMap().get(account.getId()) == null) {
                account = this.reportQuery.getAccNumIdMap().get(account.getPropValue("number"));
            }
            data[this.accountIndex] = account.getId();
            boolean isLeaf = (Boolean)account.getPropValue("isleaf");
            if (!isLeaf && this.fieldIndex.getAssgrpIndex() != -1) {
                data[this.fieldIndex.getAssgrpIndex()] = null;
            }
            if (isLeaf) {
                this.outPutRawData(data);
            } else {
                this.outPutParentRawData(data, account);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet finish() {
        List splitQFilters;
        ArrayList<Tuple2> selToQFilterList = new ArrayList<Tuple2>(8);
        int cnt = 0;
        int splitSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.accbalance.org.splitsize", (int)5);
        for (ISelector selector : this.selectors) {
            QFilter[] qFilters = selector.getQFilters();
            List<QFilter[]> splitQFilters2 = RptUtil.splitQFilterByFixedSize(qFilters, selector.getSplitField(), splitSize);
            cnt += splitQFilters2.size();
            selToQFilterList.add(new Tuple2((Object)selector, splitQFilters2));
        }
        List cacheIds = Collections.synchronizedList(new ArrayList());
        CountDownLatch cdl = new CountDownLatch(cnt);
        for (Tuple2 tuple : selToQFilterList) {
            splitQFilters = (List)tuple.t2;
            for (QFilter[] splitQFilter : splitQFilters) {
                ThreadService.execute(() -> {
                    try {
                        ISelector selector = (ISelector)tuple.t1;
                        OutPutFunction opFunction = selector.getOutPutFunction();
                        try (DataSet dataSet = selector.getDataSet(splitQFilter);){
                            for (Row row : dataSet) {
                                if ("gl_rpt_accbalance_qing".equals(this.qpRpt.getEntityId())) {
                                    SumSchema sumSchema = this.sumSchema;
                                    synchronized (sumSchema) {
                                        opFunction.output(row, this);
                                        if (this.sumSchema.getLeafDataSchema().getData().size() >= 262144 || this.sumSchema.getParentDataSchema().getData().size() >= 262144 || this.sumSchema.getRawLeafDataSchema().getData().size() >= 262144 || this.sumSchema.getRawParentDataSchema().getData().size() >= 262144 || this.sumSchema.getTotalDataSchema().getData().size() >= 262144) {
                                            cacheIds.add(this.cacheDs(this.getData()).cache(CacheHint.getDefault()).getCacheId());
                                            this.sumSchema.getLeafDataSchema().getData().clear();
                                            this.sumSchema.getParentDataSchema().getData().clear();
                                            this.sumSchema.getRawLeafDataSchema().getData().clear();
                                            this.sumSchema.getRawParentDataSchema().getData().clear();
                                            this.sumSchema.getTotalDataSchema().getData().clear();
                                        }
                                        continue;
                                    }
                                }
                                opFunction.output(row, this);
                            }
                        }
                    }
                    catch (Exception e) {
                        String error = GLUtil.printError((Throwable)e);
                        logger.error("AbstractCollector calculate error\uff1a" + error, (Throwable)e);
                        this.errorMap.put(Thread.currentThread().getName(), error);
                    }
                    finally {
                        cdl.countDown();
                    }
                }, (TaskType)TaskType.GL_ACCOUNT_BALANCE_QUERY_DATA);
            }
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new BOSException((Throwable)ex);
        }
        if (this.errorMap.size() > 0) {
            String errorInfo = this.errorMap.values().iterator().next();
            throw new KDBizException(ResManager.loadKDString((String)"report query error\uff1a", (String)"AbstractCollector_0", (String)"fi-gl-report", (Object[])new Object[0]) + errorInfo);
        }
        DataSet build = null;
        int i = 0;
        splitQFilters = cacheIds;
        synchronized (splitQFilters) {
            for (String cacheId : cacheIds) {
                build = i == 0 ? Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)"cache"), true) : build.union(Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)"cache"), true));
                ++i;
            }
        }
        List<Object[]> data = this.getData();
        DataSet ds = this.cacheDs(data);
        build = build != null ? build.union(ds) : ds;
        DataSet result = this.execute(build);
        return result;
    }

    private DataSet cacheDs(List<Object[]> data) {
        DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(this.reportQuery.getRowMeta());
        data.forEach(e -> builder.append(e));
        DataSet dataSet = builder.build();
        return dataSet;
    }

    private List<Object[]> getData() {
        this.sumUpData();
        HashMap<GroupKey, Object[]> allData = new HashMap<GroupKey, Object[]>();
        this.putAll(allData, this.sumSchema.getLeafDataSchema());
        this.putAll(allData, this.sumSchema.getParentDataSchema());
        for (Map.Entry entry : allData.entrySet()) {
            this.mergeBalanceAmount((Object[])entry.getValue());
            this.setDefaultAmount((Object[])entry.getValue());
        }
        List<Object[]> sort = this.sort(allData);
        return sort;
    }

    private DataSet execute(DataSet subTotal) {
        subTotal = this.getAllAccount(subTotal);
        subTotal = this.addAccountInfo(subTotal, false);
        DataSet total = Algo.create((String)this.getClass().getName()).createDataSet(this.sumSchema.getTotalDataSchema().getData().values().iterator(), this.reportQuery.getRowMeta());
        if (this.sumSchema.getTotalDataSchema().getData().isEmpty() && !subTotal.isEmpty() && !"gl_rpt_accbalance_qing".equals(this.qpRpt.getEntityId())) {
            ArrayList<Object[]> totalList = new ArrayList<Object[]>();
            totalList.add(new Object[this.reportQuery.getRowMeta().getFieldCount()]);
            total = Algo.create((String)this.getClass().getName()).createDataSet(totalList.iterator(), this.reportQuery.getRowMeta());
        }
        DataSet result = subTotal.union(this.addAccountInfo(total, true));
        return this.addCurLocal(result);
    }

    private DataSet getAllAccount(DataSet result) {
        if (!(this.qpRpt.isNoZeroAmount() || this.qpRpt.isNoZeroBalance() || this.qpRpt.isNoZeroYearBal() || this.qpRpt.isShowLeafAccount() || this.qpRpt.isHideUnused())) {
            long porg = this.qpRpt.getPorg();
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)porg);
            QFilter accFilter = new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable());
            if (this.qpRpt.isShowLeafAccount()) {
                accFilter.and(new QFilter("isleaf", "=", (Object)true));
            } else {
                accFilter.and(new QFilter("level", "<=", (Object)this.qpRpt.getAccountLevel()));
            }
            if (this.qpRpt.getAccountList() != null) {
                accFilter.and(new QFilter("id", "in", this.reportQuery.getIdMap().keySet()));
            }
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.qpRpt.getEndPeriod(), (String)"bd_period");
            QFilter startDate = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
            QFilter endDate = new QFilter("enddate", ">=", (Object)period.getDate("enddate"));
            if (orgFilter != null) {
                DataSet accountSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "." + "account"), (String)"bd_accountview", (String)"id accmid", (QFilter[])new QFilter[]{orgFilter, accFilter, startDate, endDate}, null);
                DataSet finish = result.fullJoin(accountSet).on("account", "accmid").select(this.reportQuery.getRowMeta().getFieldNames(), new String[]{"accmid"}).finish();
                ArrayList<String> sel = new ArrayList<String>();
                for (String fieldName : this.reportQuery.getRowMeta().getFieldNames()) {
                    if ("account".equalsIgnoreCase(fieldName)) {
                        sel.add("case account when null then accmid else account end as account");
                        continue;
                    }
                    sel.add(fieldName);
                }
                result = finish.select(sel.toArray(new String[0]));
                if (this.qpRpt.isShowPeriod()) {
                    QFilter type = new QFilter("periodtype", "=", (Object)this.qpRpt.getPeriodType());
                    QFilter start = new QFilter("id", "<=", (Object)this.qpRpt.getEndPeriod());
                    QFilter end = new QFilter("id", ">=", (Object)this.qpRpt.getStartPeriod());
                    DataSet periodSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{type, start, end}, null);
                    DataSet filter = result.join(accountSet, JoinType.RIGHT).on("account", "accmid").select(this.reportQuery.getRowMeta().getFieldNames(), new String[]{"accmid"}).finish().filter("account is null");
                    DataSet finish1 = filter.join(periodSet, JoinType.CROSS).select(filter.getRowMeta().getFieldNames(), new String[]{"id"}).finish();
                    ArrayList<String> nullAccSel = new ArrayList<String>();
                    for (String fieldName : this.reportQuery.getRowMeta().getFieldNames()) {
                        if ("account".equalsIgnoreCase(fieldName)) {
                            nullAccSel.add("case account when null then accmid else account end as account");
                            continue;
                        }
                        if ("period".equalsIgnoreCase(fieldName)) {
                            nullAccSel.add("case period when null then id else account end as period");
                            continue;
                        }
                        if ("id".equalsIgnoreCase(fieldName)) continue;
                        nullAccSel.add(fieldName);
                    }
                    DataSet select = finish1.select(nullAccSel.toArray(new String[0]));
                    result = result.union(select);
                }
            }
        }
        return result;
    }

    private DataSet addCurLocal(DataSet finish) {
        finish = this.qpRpt.addCurLocal("org", finish);
        if (this.qpRpt.isShowRpt()) {
            finish = finish.addField("" + this.qpRpt.getCurRpt(), "currencyrptid");
        }
        return finish;
    }

    private void outPutRawData(Object[] value) {
        if (this.qpRpt.isShowLeafAccount() || this.filterAccountLevel(value)) {
            Object[] val = this.sumSchema.getRawLeafDataSchema().outPutData(value);
            if (val == null) {
                this.outPutDimData(this.sumSchema.getLeafDataSchema().getParent(), value);
                this.outPutParentData(value);
                this.outPutTotalData(value);
            }
        } else {
            TreeNode node = this.reportQuery.getIdMap().get(value[this.accountIndex]);
            if (node != null) {
                this.outPutParentRawData(value, node.getParent());
            } else {
                throw new KDBizException("account masterid not exist\uff1a" + value[this.accountIndex]);
            }
        }
    }

    private void outPutParentRawData(Object[] value, TreeNode parentNode) {
        if (parentNode == null) {
            return;
        }
        if ((Integer)parentNode.getPropValue("level") <= this.qpRpt.getAccountLevel()) {
            Object[] parentValue = this.getParentValue(value, parentNode);
            Object[] val = this.sumSchema.getRawParentDataSchema().outPutData(parentValue);
            if (val == null) {
                this.outPutDimData(this.sumSchema.getParentDataSchema().getParent(), value);
                this.outPutParentData(parentValue);
                this.outPutTotalData(parentValue);
            }
        } else {
            this.outPutParentRawData(this.getParentValue(value, parentNode), parentNode.getParent());
        }
    }

    private Object[] getParentValue(Object[] value, TreeNode parentNode) {
        Object[] parentValue = (Object[])value.clone();
        parentValue[this.accountIndex] = parentNode.getId();
        return parentValue;
    }

    private void outPutData(Object[] value) {
        this.outPutLeafData(value);
        this.outPutParentData(value);
        this.outPutTotalData(value);
    }

    private void outPutDimData(DataSchema schema, Object[] value) {
        if (schema == null || this.qpRpt.isOnlyShowDetailData()) {
            return;
        }
        schema.outPutData(value);
        this.outPutDimData(schema.getParent(), value);
    }

    private void outPutLeafData(Object[] value) {
        if (this.qpRpt.isShowLeafAccount() || this.filterAccountLevel(value)) {
            this.sumSchema.getLeafDataSchema().outPutData(value, x -> this.filterAssistAndQty(value), true);
            this.outPutDimData(this.sumSchema.getLeafDataSchema().getParent(), value);
        }
    }

    private void outPutParentData(Object[] value) {
        if (!this.qpRpt.isShowLeafAccount()) {
            this.outPutParentDataHelper(value, this.reportQuery.getIdMap().get(value[this.accountIndex]).getParent());
        }
    }

    private void outPutTotalData(Object[] value) {
        DataSchema totalDataSchema;
        if (!this.qpRpt.isOnlyShowDetailData() && (totalDataSchema = this.sumSchema.getTotalDataSchema()) != null) {
            totalDataSchema.outPutData(value);
        }
    }

    private void outPutParentDataHelper(Object[] value, TreeNode parentNode) {
        if (parentNode == null) {
            return;
        }
        if (this.filterAccountLevel(parentNode)) {
            Object[] parentValue = this.getParentValue(value, parentNode);
            DataSchema parentDataSchema = this.sumSchema.getParentDataSchema();
            parentDataSchema.outPutData(parentValue, x -> this.filterQty(value), !this.qpRpt.isShowQty());
            this.outPutDimData(parentDataSchema.getParent(), parentValue);
        }
        this.outPutParentDataHelper(value, parentNode.getParent());
    }

    private boolean filterAccountLevel(Object[] value) {
        TreeNode node = this.reportQuery.getIdMap().get(value[this.accountIndex]);
        if (node == null) {
            logger.error("account masterid not exist: " + value[this.accountIndex]);
            throw new KDBizException("account masterid not exist: " + value[this.accountIndex]);
        }
        return (Integer)node.getPropValue("level") <= this.qpRpt.getAccountLevel();
    }

    private boolean filterAccountLevel(TreeNode node) {
        return (Integer)node.getPropValue("level") <= this.qpRpt.getAccountLevel();
    }

    private void putAll(Map<GroupKey, Object[]> data, DataSchema dataSchema) {
        if (dataSchema != null) {
            Map<GroupKey, Object[]> schemaData = dataSchema.getData();
            for (Map.Entry<GroupKey, Object[]> groupKeyEntry : schemaData.entrySet()) {
                data.compute(groupKeyEntry.getKey(), (k, v) -> {
                    if (v == null) {
                        return (Object[])groupKeyEntry.getValue();
                    }
                    return dataSchema.sum((Object[])v, (Object[])groupKeyEntry.getValue());
                });
            }
            this.putAll(data, dataSchema.getParent());
        }
    }

    private List<Object[]> sort(Map<GroupKey, Object[]> data) {
        return data.entrySet().stream().sorted((e1, e2) -> {
            Object[] k1 = ((GroupKey)e1.getKey()).getIds();
            Object[] k2 = ((GroupKey)e2.getKey()).getIds();
            return (Integer)k1[0] - (Integer)k2[0];
        }).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void sumUpData() {
        logger.info("sumUpData_Size:{}", (Object)this.sumSchema.getRawLeafDataSchema().getData().size());
        Iterator<Map.Entry<GroupKey, Object[]>> leafIter = this.sumSchema.getRawLeafDataSchema().getData().entrySet().iterator();
        while (leafIter.hasNext()) {
            Object[] value = leafIter.next().getValue();
            this.mergeBalanceAmount(value);
            if (this.filterRawData(value)) {
                this.outPutData(value);
            }
            leafIter.remove();
        }
        Iterator<Map.Entry<GroupKey, Object[]>> parentIter = this.sumSchema.getRawParentDataSchema().getData().entrySet().iterator();
        while (parentIter.hasNext()) {
            Object[] value = parentIter.next().getValue();
            this.mergeBalanceAmount(value);
            if (this.filterRawData(value)) {
                this.outPutParentDataHelper(value, this.reportQuery.getIdMap().get(value[this.accountIndex]));
                this.outPutTotalData(value);
            }
            parentIter.remove();
        }
    }

    private boolean filterRawData(Object[] value) {
        boolean result = false;
        boolean noFilter = true;
        if (this.qpRpt.isNoZeroAmount()) {
            result = this.filterAmount(value);
            noFilter = false;
        }
        if (this.qpRpt.isNoZeroBalance()) {
            result = result || this.filterBalance(value);
            noFilter = false;
        }
        if (this.qpRpt.isNoZeroYearBal()) {
            result = result || this.filterYearBal(value);
            noFilter = false;
        }
        if (this.isDifYearAndZero(value)) {
            result = false;
            noFilter = false;
        }
        return result || noFilter;
    }

    private boolean isDifYearAndZero(Object[] value) {
        if (this.qpRpt.isHideUnused()) {
            return false;
        }
        boolean hasCount = this.filterAmount(value);
        boolean hasYearBal = this.filterYearBal(value);
        boolean hasBal = this.filterBeginEndBalance(value);
        return !hasCount && !hasYearBal && !hasBal;
    }

    private DataSet getSelAllAcctSet() {
        boolean isShowAccountFullName = this.qpRpt.isShowAccountFullName();
        String selectFields = String.format("id,number,%s name,dc,level,isleaf", isShowAccountFullName ? "fullname" : "name");
        QFilter filter = this.reportQuery.getIdMap() == null ? new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()) : new QFilter("id", "in", this.reportQuery.getIdMap().keySet());
        DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        selectFields = "id,number,name,dc,level,isleaf";
        ds = ds.select(selectFields);
        return ds;
    }

    private boolean filterAssistAndQty(Object[] value) {
        if (this.qpRpt.isOnlyShowDetailData()) {
            return true;
        }
        if (this.qpRpt.isShowComassist()) {
            return true;
        }
        if (this.qpRpt.isShowAssist() || this.qpRpt.isShowQty()) {
            TreeNode node = this.reportQuery.getIdMap().get(value[this.accountIndex]);
            if (this.qpRpt.isShowAssist() && this.qpRpt.isShowQty()) {
                return (Boolean)node.getPropValue("isLeafHasAssist") != false || (Boolean)node.getPropValue("isLeafHasQty") != false;
            }
            if (this.qpRpt.isShowAssist()) {
                return (Boolean)node.getPropValue("isLeafHasAssist");
            }
            return (Boolean)node.getPropValue("isLeafHasQty");
        }
        return true;
    }

    private Boolean filterQty(Object[] value) {
        if (this.qpRpt.isOnlyShowDetailData()) {
            return true;
        }
        if (this.qpRpt.isShowQty()) {
            TreeNode node = this.reportQuery.getIdMap().get(value[this.accountIndex]);
            return (Boolean)node.getPropValue("isLeafHasQty");
        }
        return true;
    }

    private DataSet addAccountInfo(DataSet ds, boolean isTotal) {
        DataSet finish;
        if (isTotal) {
            finish = ds.addNullField("number").addField("'" + AbstractCollector.getTotalName() + "'", "name").addNullField(new String[]{"dc", "level", "isleaf"});
        } else {
            DataSet selAllAcctSet = this.getSelAllAcctSet();
            finish = ds.join(selAllAcctSet, JoinType.LEFT).on("account", "id").select(GLUtil.getDataSetCols((DataSet)ds).toArray(new String[0]), new String[]{"number", "name", "dc", "level", "isleaf"}).finish();
        }
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("number");
        if (this.qpRpt.isShowCurrency()) {
            orderList.add("currency");
        }
        if (this.qpRpt.isShowOrg() || this.qpRpt.isShowOrgTree()) {
            orderList.add("org");
        }
        if (this.qpRpt.isShowAssist()) {
            orderList.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            orderList.add("measureunit");
        }
        finish = finish.orderBy(orderList.toArray(new String[0]));
        return finish;
    }

    private static String getTotalName() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AbstractCollector_1", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private boolean filterYearBal(Object[] value) {
        for (Integer endIndex : this.fieldIndex.getYearIndexes()) {
            Object val = value[endIndex];
            if (val == null || ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) continue;
            return true;
        }
        return false;
    }

    private boolean filterBalance(Object[] value) {
        for (Integer endIndex : this.fieldIndex.getEndIndexes()) {
            Object val = value[endIndex];
            if (val == null || ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) continue;
            return true;
        }
        return false;
    }

    private boolean filterBeginEndBalance(Object[] value) {
        ArrayList<Integer> beginEndIndexes = new ArrayList<Integer>(4);
        beginEndIndexes.addAll(this.fieldIndex.getBeginIndexes());
        beginEndIndexes.addAll(this.fieldIndex.getEndIndexes());
        for (Integer endIndex : beginEndIndexes) {
            Object val = value[endIndex];
            if (val == null || ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) continue;
            return true;
        }
        return false;
    }

    private boolean filterAmount(Object[] value) {
        for (Integer countIndex : this.fieldIndex.getCountIndexes()) {
            Object val = value[countIndex];
            if (val == null || (Integer)val <= 0) continue;
            return true;
        }
        return false;
    }

    private void mergeBalanceAmount(Object[] value) {
        if (this.qpRpt.isShowDataByDC()) {
            TreeNode node = this.reportQuery.getIdMap().get(value[this.accountIndex]);
            String dc = (String)node.getPropValue("dc");
            String accDc = dc != null ? dc : (String)node.getPropValue("dc");
            for (int i = 0; i < this.fieldIndex.getDebitBalanceIndexes().size(); ++i) {
                Integer debitIndex = this.fieldIndex.getDebitBalanceIndexes().get(i);
                Integer creditIndex = this.fieldIndex.getCreditBalanceIndexes().get(i);
                if ("1".equals(accDc)) {
                    value[debitIndex.intValue()] = RptUtil.subtract(value[debitIndex], value[creditIndex]);
                    value[creditIndex.intValue()] = BigDecimal.ZERO;
                    continue;
                }
                value[creditIndex.intValue()] = RptUtil.subtract(value[creditIndex], value[debitIndex]);
                value[debitIndex.intValue()] = BigDecimal.ZERO;
            }
        } else {
            for (int i = 0; i < this.fieldIndex.getDebitBalanceIndexes().size(); ++i) {
                Integer debitIndex = this.fieldIndex.getDebitBalanceIndexes().get(i);
                Integer creditIndex = this.fieldIndex.getCreditBalanceIndexes().get(i);
                Object val = RptUtil.subtract(value[debitIndex], value[creditIndex]);
                if (val == null) continue;
                BigDecimal valB = (BigDecimal)val;
                if (valB.compareTo(BigDecimal.ZERO) >= 0) {
                    value[debitIndex.intValue()] = valB;
                    value[creditIndex.intValue()] = BigDecimal.ZERO;
                    continue;
                }
                value[debitIndex.intValue()] = BigDecimal.ZERO;
                value[creditIndex.intValue()] = valB.negate();
            }
        }
    }

    private void setDefaultAmount(Object[] value) {
        List<Integer> indexes = this.fieldIndex.getYearIndexes();
        Arrays.stream(this.fieldIndex.getDebitIndexes()).forEach(x -> indexes.add(x));
        Arrays.stream(this.fieldIndex.getCreditIndexes()).forEach(x -> indexes.add(x));
        for (int i = 0; i < indexes.size(); ++i) {
            int index = indexes.get(i);
            if (!Objects.isNull(value[index])) continue;
            value[index] = BigDecimal.ZERO;
        }
    }
}

