/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.dataset.GroupKey;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.DataFetchFunction;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.common.SumSchema;
import kd.fi.gl.util.GLUtil;

public class DailyRptCollector {
    private final SumSchema sumSchema;
    private final Map<Object, TreeNode> accMasterIdMap;
    private final Map<Object, TreeNode> accIdMap;
    private final RowMeta rowMeta;
    private final MulOrgQPRpt qpRpt;
    private int accountIndex;
    private Map<String, String> errorMap = new HashMap<String, String>();
    private DataSchema rawDataSchema;
    private DataSchema rawParentDataSchema;
    private List<Integer> countIndexes;
    private List<Integer> endIndexes;
    private List<Integer> debitBalanceIndexes;
    private List<Integer> creditBalanceIndexes;

    public DailyRptCollector(CollectorParam param) {
        this.accMasterIdMap = param.getAccMasterIdMap();
        this.accIdMap = param.getAccIdMap();
        this.rowMeta = param.getRowMeta();
        this.sumSchema = param.getSumSchema();
        this.qpRpt = param.getParam();
        this.accountIndex = this.rowMeta.getFieldIndex("account", false);
        this.countIndexes = new ArrayList<Integer>();
        this.endIndexes = new ArrayList<Integer>();
        this.debitBalanceIndexes = new ArrayList<Integer>();
        this.creditBalanceIndexes = new ArrayList<Integer>();
        this.putIt(this.countIndexes, this.rowMeta.getFieldIndex("debitcount", false));
        this.putIt(this.countIndexes, this.rowMeta.getFieldIndex("creditcount", false));
        String endField = "todebitfor,tocreditfor,todebitlocal,tocreditlocal,todebitqty,tocreditqty";
        for (String s : endField.split(",")) {
            this.putIt(this.endIndexes, this.rowMeta.getFieldIndex(s, false));
        }
        String prefix = "pre,to";
        String suffix = "for,local,qty,rpt";
        for (String pre : prefix.split(",")) {
            for (String suf : suffix.split(",")) {
                this.putIt(this.debitBalanceIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "debit", suf), false));
                this.putIt(this.creditBalanceIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "credit", suf), false));
            }
        }
        this.rawDataSchema = this.sumSchema.getLeafDataSchema().copy();
        this.rawParentDataSchema = this.sumSchema.getParentDataSchema().copy();
    }

    private void putIt(List<Integer> list, int idx) {
        if (idx != -1) {
            list.add(idx);
        }
    }

    public void collectData(DataSet dataSource, DataFetchFunction function) {
        for (Row row : dataSource) {
            TreeNode account;
            Object[] values = function.fetch(row);
            if (values == null || (account = this.accMasterIdMap.get(values[this.accountIndex])) == null) continue;
            values[this.accountIndex] = account.getId();
            this.outPutRawData(values);
        }
    }

    private void outPutData(Object[] value) {
        this.outPutLeafData(value);
        this.outPutParentData(value);
        this.outPutTotalData(value);
    }

    private void outPutRawData(Object[] value) {
        if (this.qpRpt.isShowLeafAccount() || this.filterAccountLevel(value)) {
            Object[] val = this.rawDataSchema.outPutData(value);
            if (val == null) {
                this.outPutLeafDimData(value);
                this.outPutParentData(value);
                this.outPutTotalData(value);
            }
        } else {
            this.outPutParentRawData(value, this.accIdMap.get(value[this.accountIndex]).getParent());
        }
    }

    private void outPutParentRawData(Object[] value, TreeNode parentNode) {
        if (parentNode == null) {
            return;
        }
        if (((Integer)parentNode.getPropValue("level")).intValue() == this.qpRpt.getAccountLevel()) {
            Object[] parentValue = this.getParentValue(value, parentNode);
            Object[] val = this.rawParentDataSchema.outPutData(parentValue);
            if (val == null) {
                this.outPutParentDimData(parentValue);
                this.outPutParentData(parentValue);
                this.outPutTotalData(parentValue);
            }
        } else {
            this.outPutParentRawData(this.getParentValue(value, parentNode), parentNode.getParent());
        }
    }

    private void outPutLeafData(Object[] value) {
        if (this.qpRpt.isShowLeafAccount() || this.filterAccountLevel(value)) {
            this.sumSchema.getLeafDataSchema().outPutData(value, x -> this.filterAssistAndQty(value), true);
            this.outPutDimData(this.sumSchema.getLeafDataSchema().getParent(), value);
        }
    }

    private void outPutLeafDimData(Object[] value) {
        this.outPutDimData(this.sumSchema.getLeafDataSchema().getParent(), value);
    }

    private void outPutParentDimData(Object[] value) {
        this.outPutDimData(this.sumSchema.getParentDataSchema().getParent(), value);
    }

    private void outPutTotalData(Object[] value) {
        this.sumSchema.getTotalDataSchema().outPutData(value);
    }

    private void outPutParentData(Object[] value) {
        if (!this.qpRpt.isShowLeafAccount()) {
            this.outPutParentDataHelper(value, this.accIdMap.get(value[this.accountIndex]).getParent());
        }
    }

    private void outPutSelfAndParentData(Object[] value) {
        if (!this.qpRpt.isShowLeafAccount()) {
            this.outPutParentDataHelper(value, this.accIdMap.get(value[this.accountIndex]));
        }
    }

    private void outPutParentDataHelper(Object[] value, TreeNode parentNode) {
        if (parentNode == null) {
            return;
        }
        if (this.filterAccountLevel(parentNode)) {
            Object[] parentValue = this.getParentValue(value, parentNode);
            DataSchema parentDataSchema = this.sumSchema.getParentDataSchema();
            parentDataSchema.outPutData(parentValue, x -> this.filterQty(value), !this.qpRpt.isShowQty());
            this.outPutDimData(parentDataSchema.getParent(), parentValue);
        }
        this.outPutParentDataHelper(value, parentNode.getParent());
    }

    private boolean filterAssistAndQty(Object[] value) {
        if (this.qpRpt.isShowAssist() || this.qpRpt.isShowQty()) {
            TreeNode node = this.accIdMap.get(value[this.accountIndex]);
            if (this.qpRpt.isShowAssist() && this.qpRpt.isShowQty()) {
                return (Boolean)node.getPropValue("isLeafHasAssist") != false || (Boolean)node.getPropValue("isLeafHasQty") != false;
            }
            if (this.qpRpt.isShowAssist()) {
                return (Boolean)node.getPropValue("isLeafHasAssist");
            }
            return (Boolean)node.getPropValue("isLeafHasQty");
        }
        return true;
    }

    private Boolean filterQty(Object[] value) {
        if (this.qpRpt.isShowQty()) {
            TreeNode node = this.accIdMap.get(value[this.accountIndex]);
            return (Boolean)node.getPropValue("isLeafHasQty");
        }
        return true;
    }

    private Object[] getParentValue(Object[] value, TreeNode parentNode) {
        Long parentId = parentNode.getId();
        Object[] parentValue = (Object[])value.clone();
        parentValue[this.accountIndex] = parentId;
        return parentValue;
    }

    private void outPutDimData(DataSchema schema, Object[] value) {
        if (schema == null) {
            return;
        }
        schema.outPutData(value);
        this.outPutDimData(schema.getParent(), value);
    }

    private boolean filterAccountLevel(Object[] value) {
        return (Integer)this.accIdMap.get(value[this.accountIndex]).getPropValue("level") <= this.qpRpt.getAccountLevel();
    }

    private boolean filterAccountLevel(TreeNode node) {
        return (Integer)node.getPropValue("level") <= this.qpRpt.getAccountLevel();
    }

    public DataSet finish() {
        this.filterData();
        HashMap<GroupKey, Object[]> allData = new HashMap<GroupKey, Object[]>();
        this.putAll(allData, this.sumSchema.getLeafDataSchema());
        this.putAll(allData, this.sumSchema.getParentDataSchema());
        Iterator leafIter = allData.entrySet().iterator();
        while (leafIter.hasNext()) {
            this.mergeBalanceAmount((Object[])leafIter.next().getValue());
        }
        List<Object[]> sort = this.sort(allData);
        DataSet subTotal = Algo.create((String)this.getClass().getName()).createDataSet(sort.iterator(), this.rowMeta);
        subTotal = this.addAccountInfo(subTotal);
        DataSet total = Algo.create((String)this.getClass().getName()).createDataSet(this.sumSchema.getTotalDataSchema().getData().values().iterator(), this.rowMeta);
        return subTotal.union(this.addAccountInfo(total));
    }

    private void mergeBalanceAmount(Object[] value) {
        if (this.qpRpt.isShowDataByDC()) {
            TreeNode node = this.accIdMap.get(value[this.accountIndex]);
            String accDc = (String)node.getPropValue("dc");
            for (int i = 0; i < this.debitBalanceIndexes.size(); ++i) {
                Integer debitIndex = this.debitBalanceIndexes.get(i);
                Integer creditIndex = this.creditBalanceIndexes.get(i);
                if ("1".equals(accDc)) {
                    value[debitIndex.intValue()] = RptUtil.subtract(value[debitIndex], value[creditIndex]);
                    value[creditIndex.intValue()] = BigDecimal.ZERO;
                    continue;
                }
                value[creditIndex.intValue()] = RptUtil.subtract(value[creditIndex], value[debitIndex]);
                value[debitIndex.intValue()] = BigDecimal.ZERO;
            }
        } else {
            for (int i = 0; i < this.debitBalanceIndexes.size(); ++i) {
                Integer debitIndex = this.debitBalanceIndexes.get(i);
                Integer creditIndex = this.creditBalanceIndexes.get(i);
                Object val = RptUtil.subtract(value[debitIndex], value[creditIndex]);
                if (val == null) continue;
                BigDecimal valB = (BigDecimal)val;
                if (valB.compareTo(BigDecimal.ZERO) >= 0) {
                    value[debitIndex.intValue()] = valB;
                    value[creditIndex.intValue()] = BigDecimal.ZERO;
                    continue;
                }
                value[debitIndex.intValue()] = BigDecimal.ZERO;
                value[creditIndex.intValue()] = valB.negate();
            }
        }
    }

    private void filterData() {
        Object[] value;
        Map.Entry<GroupKey, Object[]> next;
        Iterator<Map.Entry<GroupKey, Object[]>> iterator = this.rawDataSchema.getData().entrySet().iterator();
        Map accMasterIdAndDCMap = ReportUtils.getActAndDCMap((Long)this.qpRpt.getPorg(), (Long)this.qpRpt.getAccountTable());
        while (iterator.hasNext()) {
            next = iterator.next();
            value = next.getValue();
            this.setBalanceAmount(value, accMasterIdAndDCMap);
            if (this.filter(value)) {
                this.outPutData(value);
            }
            iterator.remove();
        }
        iterator = this.rawParentDataSchema.getData().entrySet().iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            value = next.getValue();
            this.setBalanceAmount(value, accMasterIdAndDCMap);
            if (this.filter(value)) {
                this.outPutSelfAndParentData(value);
                this.outPutTotalData(value);
            }
            iterator.remove();
        }
    }

    private void setBalanceAmount(Object[] value, Map<Long, String> accMasterIdAndDCMap) {
        String accDc = accMasterIdAndDCMap.get(value[this.accountIndex]);
        if (accDc == null) {
            TreeNode node = this.accIdMap.get(value[this.accountIndex]);
            accDc = (String)node.getPropValue("dc");
        }
        for (int i = 0; i < this.debitBalanceIndexes.size(); ++i) {
            Integer debitIndex = this.debitBalanceIndexes.get(i);
            Integer creditIndex = this.creditBalanceIndexes.get(i);
            if (this.qpRpt.isShowDataByDC()) {
                if ("1".equals(accDc)) {
                    value[debitIndex.intValue()] = RptUtil.subtract(value[debitIndex], value[creditIndex]);
                    value[creditIndex.intValue()] = BigDecimal.ZERO;
                    continue;
                }
                value[creditIndex.intValue()] = RptUtil.subtract(value[creditIndex], value[debitIndex]);
                value[debitIndex.intValue()] = BigDecimal.ZERO;
                continue;
            }
            BigDecimal balAmt = (BigDecimal)RptUtil.subtract(value[debitIndex], value[creditIndex]);
            if (balAmt != null) {
                if (balAmt.compareTo(BigDecimal.ZERO) > 0) {
                    value[debitIndex.intValue()] = balAmt;
                    value[creditIndex.intValue()] = BigDecimal.ZERO;
                    continue;
                }
                value[debitIndex.intValue()] = BigDecimal.ZERO;
                value[creditIndex.intValue()] = balAmt.negate();
                continue;
            }
            value[debitIndex.intValue()] = BigDecimal.ZERO;
            value[creditIndex.intValue()] = BigDecimal.ZERO;
        }
    }

    private boolean filter(Object[] value) {
        if (this.qpRpt.isNoZeroAmount()) {
            if (this.qpRpt.isNoZeroBalance()) {
                return this.filterAmount(value) || this.filterBalance(value);
            }
            return this.filterAmount(value);
        }
        if (this.qpRpt.isNoZeroBalance()) {
            return this.filterBalance(value);
        }
        return true;
    }

    private boolean filterBalance(Object[] value) {
        for (Integer endIndex : this.endIndexes) {
            Object val = value[endIndex];
            if (val == null || ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) continue;
            return true;
        }
        return false;
    }

    private boolean filterAmount(Object[] value) {
        for (Integer countIndex : this.countIndexes) {
            Object val = value[countIndex];
            if (val == null || (Integer)val <= 0) continue;
            return true;
        }
        return false;
    }

    private DataSet addAccountInfo(DataSet ds) {
        DataSet selAllAcctSet = this.getSelAllAcctSet();
        DataSet finish = ds.join(selAllAcctSet, JoinType.LEFT).on("account", "id").select(GLUtil.getDataSetCols((DataSet)ds).toArray(new String[0]), new String[]{"number", "name", "dc", "level", "isleaf"}).finish();
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("number");
        if (this.qpRpt.isShowCurrency()) {
            orderList.add("currencyid");
        }
        if (this.qpRpt.isShowOrg()) {
            orderList.add("orgid");
        }
        if (this.qpRpt.isShowAssist()) {
            orderList.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            orderList.add("measureunit");
        }
        finish = finish.orderBy(orderList.toArray(new String[0]));
        return finish;
    }

    private DataSet getSelAllAcctSet() {
        String selectFields = String.format("id,number,%s name,dc,level,isleaf", this.qpRpt.isShowAccountFullName() ? "fullname" : "name");
        List ids = this.accMasterIdMap.values().stream().map(x -> x.getId()).collect(Collectors.toList());
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
    }

    private void putAll(Map<GroupKey, Object[]> data, DataSchema dataSchema) {
        if (dataSchema != null) {
            Map<GroupKey, Object[]> schemaData = dataSchema.getData();
            for (Map.Entry<GroupKey, Object[]> groupKeyEntry : schemaData.entrySet()) {
                data.compute(groupKeyEntry.getKey(), (k, v) -> {
                    if (v == null) {
                        return (Object[])groupKeyEntry.getValue();
                    }
                    return dataSchema.sum((Object[])v, (Object[])groupKeyEntry.getValue());
                });
            }
            this.putAll(data, dataSchema.getParent());
        }
    }

    private List<Object[]> sort(Map<GroupKey, Object[]> data) {
        return data.entrySet().stream().sorted((e1, e2) -> {
            Object[] k1 = ((GroupKey)e1.getKey()).getIds();
            Object[] k2 = ((GroupKey)e2.getKey()).getIds();
            return (Integer)k1[0] - (Integer)k2[0];
        }).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public Map<String, String> getErrorMap() {
        return this.errorMap;
    }
}

