/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.DailyRptQueryParam;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.DataFetchFunction;
import kd.fi.gl.vo.RateBean;

public class VoucherFetchFunction
implements DataFetchFunction {
    private final Date dateBegin;
    private final Field[] fields;
    private final Map<Object, TreeNode> accIdMap;
    private final int grpSize;
    private final boolean showFor;
    private final boolean showQty;
    private final boolean showRpt;
    private final int inputOrgIndex;
    private Map<Long, RateBean> orgRateMap;
    private Object[] result;
    private int idx;
    private Long account;
    private Date bookedDate;
    private String dc;
    private String accDc;
    private BigDecimal debitFor;
    private BigDecimal creditFor;
    private BigDecimal debitLocal;
    private BigDecimal creditLocal;
    private BigDecimal debitqty;
    private BigDecimal creditqty;
    private RateBean rate;
    private TreeNode node;
    private boolean isPlvoucher;
    private boolean isInitBal;
    private Date initDate;
    private boolean showChart;
    private Map<String, BigDecimal[]> chartDataMap;
    private String dateStr;
    private boolean isSameDay;
    private DateFormat dFormat;

    public VoucherFetchFunction(CollectorParam param, Map<Object, TreeNode> accIdMap, Map<String, BigDecimal[]> chartDataMap, RowMeta inputRowMeta, boolean isPlvoucher, boolean isInitBal) {
        this.chartDataMap = chartDataMap;
        this.accIdMap = accIdMap;
        this.fields = param.getRowMeta().getFields();
        DailyRptQueryParam qpRpt = (DailyRptQueryParam)param.getParam();
        this.dateBegin = qpRpt.getDateBegin();
        String[] grpFields = (String[])qpRpt.getCustomParam("groupByFields");
        this.grpSize = grpFields.length;
        this.showFor = qpRpt.getCurType() == CurType.ALL || qpRpt.getCurType() == CurType.FOREIGN;
        this.showQty = qpRpt.isShowQty();
        this.showChart = qpRpt.getOrgType() != OrgType.VIRTUAL_M;
        this.dFormat = DateFormat.getDateInstance();
        Date dateEnd = qpRpt.getDateEnd();
        this.isSameDay = this.dFormat.format(this.dateBegin).equals(this.dFormat.format(dateEnd));
        this.orgRateMap = new HashMap<Long, RateBean>();
        this.showRpt = qpRpt.isShowRpt();
        if (this.showRpt) {
            this.orgRateMap = qpRpt.getOrgRateMap();
        }
        this.inputOrgIndex = inputRowMeta.getFieldIndex("orgid", false);
        this.isPlvoucher = isPlvoucher;
        this.isInitBal = isInitBal;
        this.initDate = new Date(this.dateBegin.getTime() - 86400000L);
    }

    @Override
    public Object[] fetch(Row row) {
        this.result = new Object[this.fields.length];
        this.idx = this.grpSize;
        this.account = row.getLong(0);
        if (this.isInitBal) {
            this.bookedDate = this.initDate;
            ++this.idx;
        } else {
            this.bookedDate = row.getDate(this.idx++);
        }
        this.dc = row.getString(this.idx++);
        this.debitLocal = row.getBigDecimal(this.idx++);
        this.creditLocal = row.getBigDecimal(this.idx++);
        if (this.isInitBal && this.creditLocal.compareTo(BigDecimal.ZERO) != 0) {
            this.dc = String.valueOf(-1 * Integer.parseInt(this.dc));
        }
        if (this.showFor) {
            this.debitFor = row.getBigDecimal(this.idx++);
            this.creditFor = row.getBigDecimal(this.idx++);
        }
        if (this.isPlvoucher) {
            this.debitLocal = this.debitLocal.negate();
            this.creditLocal = this.creditLocal.negate();
            if (this.debitFor != null) {
                this.debitFor = this.debitFor.negate();
            }
            if (this.creditFor != null) {
                this.creditFor = this.creditFor.negate();
            }
        }
        if (this.showQty) {
            this.debitqty = row.getBigDecimal(this.idx++);
            this.creditqty = row.getBigDecimal(this.idx);
        }
        if (this.showRpt) {
            this.rate = this.orgRateMap.get(row.getLong(this.inputOrgIndex));
        }
        this.node = this.accIdMap.get(this.account);
        if (this.node == null) {
            return null;
        }
        this.accDc = (String)this.node.getPropValue("dc");
        this.result[0] = this.node.getMasterId();
        for (int i = 1; i < this.grpSize; ++i) {
            this.result[i] = row.get(i);
        }
        this.idx = this.grpSize;
        if (this.dateBegin.compareTo(this.bookedDate) > 0) {
            this.result[this.idx++] = 0;
            this.result[this.idx++] = 0;
            if ("1".equals(this.accDc)) {
                this.result[this.idx++] = "1".equals(this.dc) ? this.debitLocal : this.creditLocal.negate();
                this.result[this.idx++] = BigDecimal.ZERO;
            } else {
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = "1".equals(this.dc) ? this.debitLocal.negate() : this.creditLocal;
            }
            this.result[this.idx++] = BigDecimal.ZERO;
            this.result[this.idx++] = BigDecimal.ZERO;
            this.result[this.idx++] = this.result[this.idx - 5];
            this.result[this.idx++] = this.result[this.idx - 5];
            if (this.showFor) {
                if ("1".equals(this.accDc)) {
                    this.result[this.idx++] = "1".equals(this.dc) ? this.debitFor : this.creditFor.negate();
                    this.result[this.idx++] = BigDecimal.ZERO;
                } else {
                    this.result[this.idx++] = BigDecimal.ZERO;
                    this.result[this.idx++] = "1".equals(this.dc) ? this.debitFor.negate() : this.creditFor;
                }
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = this.result[this.idx - 5];
                this.result[this.idx++] = this.result[this.idx - 5];
            }
            if (this.showQty) {
                if ("1".equals(this.accDc)) {
                    this.result[this.idx++] = "1".equals(this.dc) ? this.debitqty : this.debitqty.negate();
                    this.result[this.idx++] = BigDecimal.ZERO;
                } else {
                    this.result[this.idx++] = BigDecimal.ZERO;
                    this.result[this.idx++] = "1".equals(this.dc) ? this.creditqty.negate() : this.creditqty;
                }
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = this.result[this.idx - 5];
                this.result[this.idx++] = this.result[this.idx - 5];
            }
            if (this.showRpt) {
                if ("1".equals(this.accDc)) {
                    this.result[this.idx++] = this.getRptAmount();
                    this.result[this.idx++] = BigDecimal.ZERO;
                } else {
                    this.result[this.idx++] = BigDecimal.ZERO;
                    this.result[this.idx++] = this.getRptAmount();
                }
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = this.result[this.idx - 5];
                this.result[this.idx++] = this.result[this.idx - 5];
            }
        } else {
            this.result[this.idx++] = "1".equals(this.dc) ? 1 : 0;
            this.result[this.idx++] = "1".equals(this.dc) ? 0 : 1;
            this.result[this.idx++] = BigDecimal.ZERO;
            this.result[this.idx++] = BigDecimal.ZERO;
            this.result[this.idx++] = this.debitLocal;
            this.result[this.idx++] = this.creditLocal;
            if ("1".equals(this.accDc)) {
                this.result[this.idx++] = "1".equals(this.dc) ? this.debitLocal : this.creditLocal.negate();
                this.result[this.idx++] = BigDecimal.ZERO;
            } else {
                this.result[this.idx++] = BigDecimal.ZERO;
                Object object = this.result[this.idx++] = "1".equals(this.dc) ? this.debitLocal.negate() : this.creditLocal;
            }
            if (this.showFor) {
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = this.debitFor;
                this.result[this.idx++] = this.creditFor;
                if ("1".equals(this.accDc)) {
                    this.result[this.idx++] = "1".equals(this.dc) ? this.debitFor : this.creditFor.negate();
                    this.result[this.idx++] = BigDecimal.ZERO;
                } else {
                    this.result[this.idx++] = BigDecimal.ZERO;
                    Object object = this.result[this.idx++] = "1".equals(this.dc) ? this.debitFor.negate() : this.creditFor;
                }
            }
            if (this.showQty) {
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = "1".equals(this.dc) ? this.debitqty : BigDecimal.ZERO;
                Object object = this.result[this.idx++] = "1".equals(this.dc) ? BigDecimal.ZERO : this.creditqty;
                if ("1".equals(this.accDc)) {
                    this.result[this.idx++] = "1".equals(this.dc) ? this.debitqty : this.debitqty.negate();
                    this.result[this.idx++] = BigDecimal.ZERO;
                } else {
                    this.result[this.idx++] = BigDecimal.ZERO;
                    Object object2 = this.result[this.idx++] = "1".equals(this.dc) ? this.creditqty.negate() : this.creditqty;
                }
            }
            if (this.showRpt) {
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = BigDecimal.ZERO;
                this.result[this.idx++] = this.rate.isDirect() ? this.debitLocal.multiply(this.rate.getRateVal()) : this.debitLocal.divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP);
                Object object = this.result[this.idx++] = this.rate.isDirect() ? this.creditLocal.multiply(this.rate.getRateVal()) : this.creditLocal.divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP);
                if ("1".equals(this.accDc)) {
                    this.result[this.idx++] = this.getRptAmount();
                    this.result[this.idx++] = BigDecimal.ZERO;
                } else {
                    this.result[this.idx++] = BigDecimal.ZERO;
                    this.result[this.idx++] = this.getRptAmount();
                }
            }
        }
        if (this.showChart && (this.isSameDay || this.dateBegin.compareTo(this.bookedDate) <= 0)) {
            this.dateStr = this.dFormat.format(this.bookedDate);
            if ("1".equals(this.dc)) {
                this.chartDataMap.compute(this.dateStr, (k, v) -> {
                    if (v == null) {
                        return new BigDecimal[]{this.debitLocal, BigDecimal.ZERO};
                    }
                    v[0] = v[0].add(this.debitLocal);
                    return v;
                });
            } else {
                this.chartDataMap.compute(this.dateStr, (k, v) -> {
                    if (v == null) {
                        return new BigDecimal[]{BigDecimal.ZERO, this.creditLocal};
                    }
                    v[1] = v[1].add(this.creditLocal);
                    return v;
                });
            }
        }
        return this.result;
    }

    private BigDecimal getRptAmount() {
        BigDecimal rptAmt = "1".equals(this.accDc) ? ("1".equals(this.dc) ? (this.rate.isDirect() ? this.debitLocal.multiply(this.rate.getRateVal()) : this.debitLocal.divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP)) : (this.rate.isDirect() ? this.creditLocal.multiply(this.rate.getRateVal()) : this.creditLocal.divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP)).negate()) : ("1".equals(this.dc) ? (this.rate.isDirect() ? this.debitLocal.multiply(this.rate.getRateVal()) : this.debitLocal.divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP)).negate() : (this.rate.isDirect() ? this.creditLocal.multiply(this.rate.getRateVal()) : this.creditLocal.divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP)));
        return rptAmt;
    }
}

