/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.qing;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.report.ReciprocalAcctQueryRpt;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.util.GLUtil;

public class ReciprocalQingDataProvider
extends AbstractFormPlugin
implements IQingDataProvider {
    private static final String CACHE_RECIPROCAL_QUERY_PARAM = "reciprocalqueryparam";
    private static final String DATA_CACHE_ID = "reciprocalQingDataProvider_data_cacheId";
    private static final String QING_META = "reciprocalQingDataProvider_qingMeta";
    private static final String ACCOUNT_FIELDS = "id, number , %s accountname";
    private static final Log logger = LogFactory.getLog(ReciprocalQingDataProvider.class);

    public void setFilterParameter(String filterParameter) {
        this.getPageCache().put(CACHE_RECIPROCAL_QUERY_PARAM, filterParameter);
    }

    public String getFilterParameter() {
        return this.getPageCache().get(CACHE_RECIPROCAL_QUERY_PARAM);
    }

    public QingMeta getMeta(String pageId) {
        try {
            return this._getMeta(pageId);
        }
        catch (Throwable e) {
            String errorStr = GLUtil.printError((Throwable)e);
            logger.error(errorStr);
            throw new KDBizException(errorStr);
        }
    }

    private QingMeta _getMeta(String pageId) throws Throwable {
        IAppCache appCache = AppCache.get((String)"gl");
        IPageCache pageCache = this.getPageCache(pageId);
        ReportQueryParam queryParam = this.getReportQueryParam(pageCache);
        DataSet dataSet = new ReciprocalAcctQueryRpt().queryQing(queryParam, null);
        List<AbstractReportColumn> assgrpColList = this.getAssgrpColList(dataSet.copy());
        CachedDataSet cachedDataSet = dataSet.cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        appCache.put(DATA_CACHE_ID + pageId, (Object)SerializationUtils.serializeToBase64((Object)cacheId));
        ArrayList<AbstractReportColumn> columnList = new ArrayList<AbstractReportColumn>();
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ReciprocalQingDataProvider_1", (String)"fi-gl-report", (Object[])new Object[0])), "org", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"ReciprocalQingDataProvider_2", (String)"fi-gl-report", (Object[])new Object[0])), "accountname", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"ReciprocalQingDataProvider_3", (String)"fi-gl-report", (Object[])new Object[0])), "accountno", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"ReciprocalQingDataProvider_4", (String)"fi-gl-report", (Object[])new Object[0])), "assgrp", "basedata"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ReciprocalQingDataProvider_5", (String)"fi-gl-report", (Object[])new Object[0])), "currencyfield", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"ReciprocalQingDataProvider_6", (String)"fi-gl-report", (Object[])new Object[0])), "periodnumber", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"ReciprocalQingDataProvider_7", (String)"fi-gl-report", (Object[])new Object[0])), "bizdate", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f", (String)"ReciprocalQingDataProvider_18", (String)"fi-gl-report", (Object[])new Object[0])), "bookeddate", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u53f7", (String)"ReciprocalQingDataProvider_8", (String)"fi-gl-report", (Object[])new Object[0])), "biznum", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b", (String)"ReciprocalQingDataProvider_9", (String)"fi-gl-report", (Object[])new Object[0])), "vouchertype", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7", (String)"ReciprocalQingDataProvider_10", (String)"fi-gl-report", (Object[])new Object[0])), "voucherno", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u51ed\u8bc1\u53f7", (String)"ReciprocalQingDataProvider_11", (String)"fi-gl-report", (Object[])new Object[0])), "writeoffvoucherno", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6458\u8981", (String)"ReciprocalQingDataProvider_12", (String)"fi-gl-report", (Object[])new Object[0])), "desc", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5230\u671f\u65e5", (String)"ReciprocalQingDataProvider_13", (String)"fi-gl-report", (Object[])new Object[0])), "expiredate", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6302\u8d26\u91d1\u989d", (String)"ReciprocalQingDataProvider_14", (String)"fi-gl-report", (Object[])new Object[0])), "amountfor", "price"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u91d1\u989d", (String)"ReciprocalQingDataProvider_15", (String)"fi-gl-report", (Object[])new Object[0])), "reciprocalamount", "price"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"ReciprocalQingDataProvider_16", (String)"fi-gl-report", (Object[])new Object[0])), "amountbalfor", "price"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5f80\u6765\u8bb0\u5f55id", (String)"ReciprocalQingDataProvider_17", (String)"fi-gl-report", (Object[])new Object[0])), "entryid", "text"));
        columnList.addAll(assgrpColList);
        List<ReportColumn> allReportColumns = this.getAllReportColumns(columnList, null);
        ArrayList<String> needHideFields = new ArrayList<String>();
        needHideFields.add("assgrp");
        needHideFields.add("bookeddate");
        QingMeta qingMeta = this.createQingMeta(allReportColumns, needHideFields);
        appCache.put(QING_META + pageId, (Object)SerializationUtils.serializeToBase64((Object)qingMeta));
        return qingMeta;
    }

    public QingData getData(String pageId, int startRow, int limit) {
        IAppCache appCache = AppCache.get((String)"gl");
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(QING_META + pageId, String.class)));
        String cacheId = (String)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(DATA_CACHE_ID + pageId, String.class)));
        QingData qingData = new QingData();
        Map<String, Integer> fieldMap = this.buildQingDataIndexMap(qingMeta);
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        Map<String, Set<Long>> baseDataMap = this.initBaseDataMap(fieldMap);
        HashMap<Long, List<String>> buyerentryVchNoMap = new HashMap<Long, List<String>>();
        HashBasedTable orgBookedDateAssgrpId = HashBasedTable.create();
        if (cacheId != null) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cacheDataSet.getRowCount();
            List list = startRow - 1 >= rowCount ? new ArrayList(0) : cacheDataSet.getList(startRow - 1, limit);
            int size = fieldMap.size();
            String[] fieldNames = cacheDataSet.getRowMeta().getFieldNames();
            HashMap<Long, String> reciIdVchNoMap = new HashMap<Long, String>();
            ArrayList<Long> acccurrentIds = new ArrayList<Long>();
            ArrayList<Long> buyerEntryIds = new ArrayList<Long>();
            ArrayList<Long> writeoffEntryIds = new ArrayList<Long>();
            for (Row row : list) {
                if (row.getLong("entryid") == null) continue;
                HashSet<Long> assgrpIdSet = (HashSet<Long>)orgBookedDateAssgrpId.get((Object)row.getLong("org"), (Object)row.getDate("bookeddate"));
                if (CollectionUtils.isEmpty((Collection)assgrpIdSet)) {
                    assgrpIdSet = new HashSet<Long>(32);
                    Long orgId = row.getLong("org");
                    Date date = row.getDate("bookeddate");
                    if (orgId == null || date == null) continue;
                    orgBookedDateAssgrpId.put((Object)orgId, (Object)date, assgrpIdSet);
                }
                assgrpIdSet.add(row.getLong("assgrp"));
                this.processWriteOffVchNO(reciIdVchNoMap, acccurrentIds, buyerEntryIds, writeoffEntryIds, row);
                for (Map.Entry entry : baseDataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Set ids = (Set)entry.getValue();
                    if (row.getLong(key) == null) continue;
                    ids.add(row.getLong(key));
                }
                Object[] data = new Object[size];
                for (String fieldName : fieldNames) {
                    Integer idx = fieldMap.get(fieldName);
                    if (idx == null) continue;
                    data[idx.intValue()] = row.get(fieldName);
                }
                rowList.add(data);
            }
            this.processWriteOffData(buyerentryVchNoMap, reciIdVchNoMap, buyerEntryIds, writeoffEntryIds);
        }
        HashMap<String, List<String>> flexFieldAndPropMap = new HashMap<String, List<String>>(8);
        this.setWriteOffVchNo(fieldMap, rowList, buyerentryVchNoMap);
        this.setBaseDataName(rowList, fieldMap, baseDataMap, flexFieldAndPropMap, (Table<Long, Date, Set<Long>>)orgBookedDateAssgrpId);
        qingData.setDataindex(fieldMap);
        qingData.setRows(rowList);
        return qingData;
    }

    private void setWriteOffVchNo(Map<String, Integer> fieldMap, List<Object[]> rowList, Map<Long, List<String>> buyerentryVchNoMap) {
        for (Object[] obj : rowList) {
            Integer idx = fieldMap.get("writeoffvoucherno");
            Long entryid = (Long)obj[fieldMap.get("entryid")];
            List<String> writeoffentryList = buyerentryVchNoMap.get(entryid);
            if (writeoffentryList == null) continue;
            if (writeoffentryList.size() == 1) {
                obj[idx.intValue()] = writeoffentryList.get(0);
                continue;
            }
            obj[idx.intValue()] = String.join((CharSequence)",", writeoffentryList);
        }
    }

    private void processWriteOffData(Map<Long, List<String>> buyerentryVchNoMap, Map<Long, String> reciIdVchNoMap, List<Long> buyerEntryIds, List<Long> writeoffEntryIds) {
        List<String> vchNoList;
        String logSelectFields = "id entryid,buyerentry buyerentryid,writeoffentry writeoffentry";
        QFilter[] logFilters = new QFilter[]{new QFilter("buyerentry", "in", buyerEntryIds)};
        DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_querylog", (String)"gl_reciprocal_log", (String)logSelectFields, (QFilter[])logFilters, null);
        ArrayList<Long> byAndWrIds = new ArrayList<Long>();
        for (Row row : logDataSet.copy()) {
            Long writeoffentryId = row.getLong("writeoffentry");
            if (reciIdVchNoMap.get(writeoffentryId) != null) continue;
            byAndWrIds.add(writeoffentryId);
        }
        QFilter[] wrOfflogFilters = new QFilter[]{new QFilter("writeoffentry", "in", writeoffEntryIds)};
        DataSet wrOfflogDataSet = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_querylog", (String)"gl_reciprocal_log", (String)logSelectFields, (QFilter[])wrOfflogFilters, null);
        for (Row row : wrOfflogDataSet.copy()) {
            Long buyerentryid = row.getLong("buyerentryid");
            if (reciIdVchNoMap.get(buyerentryid) != null) continue;
            byAndWrIds.add(buyerentryid);
        }
        String byAndWroffentryField = "voucherid byAndWroffentryVoucherid,id";
        QFilter byAndWroffentryFilter = new QFilter("id", "in", byAndWrIds);
        DataSet byAndWroffentryDataSet = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_queryrecord", (String)"gl_acccurrent", (String)byAndWroffentryField, (QFilter[])new QFilter[]{byAndWroffentryFilter}, null);
        ArrayList<Long> byAndWroffVoucherIds = new ArrayList<Long>();
        for (Row row : byAndWroffentryDataSet.copy()) {
            Long voucherid = row.getLong("byAndWroffentryVoucherid");
            if (voucherid == 0L) continue;
            byAndWroffVoucherIds.add(voucherid);
        }
        QFilter byAndWroffVoucherQFilter = new QFilter("id", "in", byAndWroffVoucherIds);
        String byAndWroffVoucherField = "id vchid,billno voucherno";
        DataSet byAndWroffVoucherDt = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_querywriteoffvoucher", (String)"gl_voucher", (String)byAndWroffVoucherField, (QFilter[])new QFilter[]{byAndWroffVoucherQFilter}, null);
        DataSet byAndWroffVoucherJoinDt = byAndWroffentryDataSet.join(byAndWroffVoucherDt, JoinType.INNER).on("byAndWroffentryVoucherid", "vchid").select(new String[]{"id", "voucherno"}).finish();
        for (Row row : byAndWroffVoucherJoinDt) {
            reciIdVchNoMap.put(row.getLong("id"), row.getString("voucherno"));
        }
        for (Row row : logDataSet) {
            String writeoffentry;
            vchNoList = buyerentryVchNoMap.get(row.getLong("buyerentryid"));
            if (vchNoList == null) {
                vchNoList = new ArrayList<String>();
            }
            if (!StringUtils.isNotEmpty((String)(writeoffentry = reciIdVchNoMap.get(row.getLong("writeoffentry"))))) continue;
            vchNoList.add(writeoffentry);
            buyerentryVchNoMap.put(row.getLong("buyerentryid"), vchNoList);
        }
        for (Row row : wrOfflogDataSet) {
            String buyerentryid;
            vchNoList = buyerentryVchNoMap.get(row.getLong("writeoffentry"));
            if (vchNoList == null) {
                vchNoList = new ArrayList<String>();
            }
            if (!StringUtils.isNotEmpty((String)(buyerentryid = reciIdVchNoMap.get(row.getLong("buyerentryid"))))) continue;
            vchNoList.add(buyerentryid);
            buyerentryVchNoMap.put(row.getLong("writeoffentry"), vchNoList);
        }
    }

    private void processWriteOffVchNO(Map<Long, String> reciIdVchNoMap, List<Long> acccurrentIds, List<Long> buyerEntryIds, List<Long> writeoffEntryIds, Row row) {
        Long acccurrentId = row.getLong("entryid");
        acccurrentIds.add(acccurrentId);
        BigDecimal amountfor = row.getBigDecimal("amountfor");
        BigDecimal amountbalfor = row.getBigDecimal("amountbalfor");
        if (amountfor.compareTo(amountbalfor) != 0) {
            String voucherno = row.getString("voucherno");
            if (StringUtils.isNotEmpty((String)voucherno)) {
                reciIdVchNoMap.put(acccurrentId, voucherno);
            }
            if (amountfor.compareTo(BigDecimal.ZERO) > 0) {
                buyerEntryIds.add(acccurrentId);
            } else if (amountfor.compareTo(BigDecimal.ZERO) < 0) {
                writeoffEntryIds.add(acccurrentId);
            }
        }
    }

    private void setBaseDataName(List<Object[]> rowList, Map<String, Integer> fieldMap, Map<String, Set<Long>> baseDataMap, Map<String, List<String>> flexFieldAndPropMap, Table<Long, Date, Set<Long>> orgBookedDateAssgrpId) {
        HashMap<String, String> keyToTypeMap = new HashMap<String, String>();
        keyToTypeMap.put("currencyfield", "bd_currency");
        keyToTypeMap.put("org", "bos_org");
        keyToTypeMap.put("accountno", "bd_accountview");
        keyToTypeMap.put("vouchertype", "gl_vouchertype");
        for (Map.Entry<String, Set<Long>> entry : baseDataMap.entrySet()) {
            String entityId;
            String key = entry.getKey();
            Integer idx = fieldMap.get(key);
            Set<Long> ids = entry.getValue();
            if ("assgrp".equals(key)) {
                Map<String, Map<String, Map<String, String>>> assgrpPropsById = RptUtil.getAssgrpNameById(orgBookedDateAssgrpId, flexFieldAndPropMap);
                for (Object[] obj : rowList) {
                    String assgrpKey;
                    Map<String, Map<String, String>> flexMap;
                    Long assgrp = (Long)obj[idx];
                    if (assgrp == null || assgrp == 0L || (flexMap = assgrpPropsById.get(assgrpKey = this.buildAssgrpKey(fieldMap, obj))) == null) continue;
                    for (Map.Entry<String, Map<String, String>> ff : flexMap.entrySet()) {
                        Map<String, String> propAndVals = ff.getValue();
                        String flexField = ff.getKey();
                        if (CollectionUtils.isEmpty(propAndVals)) continue;
                        for (Map.Entry<String, String> propAndVal : propAndVals.entrySet()) {
                            String prop = propAndVal.getKey();
                            String fieldKey = "";
                            fieldKey = prop.equals(flexField) ? prop : flexField + "." + prop;
                            Integer ffIndex = fieldMap.get(fieldKey);
                            if (ffIndex == null) continue;
                            obj[ffIndex.intValue()] = propAndVal.getValue();
                        }
                    }
                }
                continue;
            }
            if ("accountno".equals(key)) {
                entityId = (String)keyToTypeMap.get(key);
                Map<Long, Tuple2<String, String>> baseDataIdFnumberMap = this.getIdFnumberMap(entityId, ids);
                Integer accountNameidx = fieldMap.get("accountname");
                for (Object[] obj : rowList) {
                    Long id = (Long)obj[idx];
                    Tuple2<String, String> tuple2 = baseDataIdFnumberMap.get(id);
                    if (tuple2 == null) continue;
                    obj[idx.intValue()] = tuple2.t1;
                    obj[accountNameidx.intValue()] = tuple2.t2;
                }
                continue;
            }
            entityId = (String)keyToTypeMap.get(key);
            Map<Long, Tuple<String, String>> baseDataIdNameMap = RptUtil.getIdNameMap(entityId, ids);
            for (Object[] obj : rowList) {
                Long id = (Long)obj[idx];
                Tuple<String, String> tuple = baseDataIdNameMap.get(id);
                if (tuple == null) continue;
                obj[idx.intValue()] = tuple.item1;
            }
        }
    }

    private String buildAssgrpKey(Map<String, Integer> fieldMap, Object[] data) {
        Integer orgIdx = fieldMap.get("org");
        Integer bookedDateIdx = fieldMap.get("bookeddate");
        Integer assgrpIdx = fieldMap.get("assgrp");
        return RptUtil.buildAssgrpKey((Long)data[orgIdx], (Date)data[bookedDateIdx], (Long)data[assgrpIdx]);
    }

    private Map<Long, Tuple2<String, String>> getIdFnumberMap(String entityId, Set<Long> ids) {
        HashMap<Long, Tuple2<String, String>> result = new HashMap<Long, Tuple2<String, String>>();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", ids)};
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)this.getFilterParameter());
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject org = filterInfo.getDynamicObject("org");
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)((Long)org.getPkValue()));
        String accSelectField = String.format(ACCOUNT_FIELDS, accountNameField);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(RptUtil.class.getName() + ".getIdNameMap"), (String)entityId, (String)accSelectField, (QFilter[])filter, null);){
            for (Row row : dataSet) {
                result.put(row.getLong("id"), (Tuple2<String, String>)new Tuple2((Object)row.getString("number"), (Object)row.getString("accountname")));
            }
        }
        return result;
    }

    private Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (Field col : qingMeta.getColumns()) {
            if (qingDataIndexMap.containsKey(col.getKey().toLowerCase())) continue;
            qingDataIndexMap.put(col.getKey().toLowerCase(), columnSeqNo++);
        }
        return qingDataIndexMap;
    }

    private IPageCache getPageCache(String pageId) {
        return new PageCache(pageId, false);
    }

    private List<ReportColumn> getAllReportColumns(List<AbstractReportColumn> columns, String parentName) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                if (parentName != null) {
                    column.setCaption(new LocaleString(parentName + "-" + column.getCaption().getLocaleValue()));
                }
                list.add((ReportColumn)column);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup group = (ReportColumnGroup)column;
            list.addAll(this.getAllReportColumns(group.getChildren(), group.getCaption().getLocaleValue()));
        }
        return list;
    }

    private QingMeta createQingMeta(List<ReportColumn> columns, List<String> needHideFields) {
        QingMeta qingMeta = new QingMeta();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            if (reportColumn.isHide()) continue;
            String fieldKey = reportColumn.getFieldKey();
            LocaleString caption = reportColumn.getCaption();
            String fieldType = reportColumn.getFieldType();
            int qingType = this.getQingType(fieldType);
            String entity = null;
            if (qingType == QingFieldType.BaseData.toNumber()) {
                entity = ((ReportColumn)abstractReportColumn).getEntityId();
            }
            qingMeta.addColumn(this.createFieldObj(fieldKey, caption, qingType, needHideFields.contains(fieldKey), entity));
        }
        return qingMeta;
    }

    private int getQingType(String fieldType) {
        switch (fieldType) {
            case "basedata": {
                return QingFieldType.Int.toNumber();
            }
            case "price": 
            case "qty": 
            case "amount": {
                return QingFieldType.Number.toNumber();
            }
            case "text": {
                return QingFieldType.String.toNumber();
            }
            case "integer": {
                return QingFieldType.Int.toNumber();
            }
            case "date": {
                return QingFieldType.Date.toNumber();
            }
        }
        return 0;
    }

    private Field createFieldObj(String key, LocaleString name, int fieldType, boolean hide, String entity) {
        Field field = new Field();
        field.setKey(key);
        field.setName(name);
        field.setFieldType(fieldType);
        field.setHide(hide);
        field.setEntity(entity);
        return field;
    }

    private List<AbstractReportColumn> getAssgrpColList(DataSet ds) {
        ArrayList<AbstractReportColumn> result = new ArrayList<AbstractReportColumn>(16);
        HashSet<Long> assgrpIds = new HashSet<Long>();
        for (Row d : ds) {
            if (d.getLong("assgrp") == null) continue;
            assgrpIds.add(d.getLong("assgrp"));
        }
        List<Map<String, String>> assgrpNames = RptUtil.getAllAssgrpName(assgrpIds);
        for (Map<String, String> assgrpName : assgrpNames) {
            result.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(assgrpName.get("name")), assgrpName.get("number"), "text"));
        }
        return result;
    }

    private ReportQueryParam getReportQueryParam(IPageCache pageCache) {
        String queryParamStr = pageCache.get(CACHE_RECIPROCAL_QUERY_PARAM);
        return (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)queryParamStr);
    }

    private Map<String, Set<Long>> initBaseDataMap(Map<String, Integer> fieldMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        String baseDataStr = "currencyfield,org,assgrp,accountno,vouchertype";
        for (String str : baseDataStr.split(",")) {
            Integer idx = fieldMap.get(str);
            if (idx == null) continue;
            result.put(str, new HashSet());
        }
        return result;
    }
}

