/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.reci;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.service.InteTimeZone;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.simulate.WriteOff;
import kd.fi.gl.reciprocal.simulate.balance.vo.AssistVO;
import kd.fi.gl.report.AgingScheduleRightPlugin;

public class ReciprocalAgingDetailQueryRpt
extends AgingScheduleRightPlugin {
    private static final String REGION = "region";
    private static final String AGESORT = "agesort";
    private static final String CURRENCYFIELD = "currencyfor";
    private static final String CURRENCYLOCAL = "currencylocal";
    private static final String AMOUNTBALFOR = "amountbalfor";
    private static final String COLKEY_ORG = "orgname";
    private static final String AMOUNTBAL = "amountbal";
    private static final String COLKEY_BIZDATE = "bizDate";
    private static final String COLKEY_DIFFDAY = "diffday";
    private static final String COLKEY_AMOUNTBAL = "amountbal";
    private static final String COLKEY_AMOUNTBALFOR = "amountbalfor";
    private static String[] SELECTARRAY = new String[]{"bizdate", "voucherid", "description", "assgrp", "currencyfor", "currencylocal", "deadlinedate", "amountbalfor", "amountbal", "age", "biznum", "accountid", "orgname", "agesort", "region", "rowtype", "id", "vouchernumber", "period", "bookeddate1"};

    @Override
    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        DynamicObjectCollection accts = filterInfo.getDynamicObjectCollection("account");
        FilterItemInfo info = filterInfo.getFilterItem("agingrange");
        Map agingRangeMap = (Map)info.getValue();
        this.init(param, accts, "gl_rpt_agingschedule");
        DataSet dsRcpBal = this.queryReciprocalBal(filterInfo);
        dsRcpBal = this.queryRecord(dsRcpBal, agingRangeMap);
        DataSet record = dsRcpBal.addNullField(new String[]{"vouchernumber", "id", "period", "bookeddate1"});
        DataSet subTotalSet = this.subTotalDataset(record.copy());
        record = record.union(subTotalSet).orderBy(new String[]{CURRENCYFIELD, AGESORT, "age desc"});
        DataSet totalSet = this.totalDataset(record.copy());
        record = record.union(totalSet);
        return record;
    }

    @Override
    protected DataSet queryReciprocalBal(FilterInfo filterInfo) {
        List<ReciprocalScheme> schemes = this.buildReciprocalScheme(filterInfo);
        DataSet ds = WriteOff.getWriteOffInstance().schemeSimulateWriteOffDetail(schemes);
        Set<String> dsFields = Arrays.stream(ds.getRowMeta().getFieldNames()).collect(Collectors.toSet());
        StringBuilder filter = this.fileterDataSet(dsFields);
        if (filter.length() > 0) {
            ds = ds.filter(filter.toString());
        }
        return this.caculateDueDays(filterInfo, ds);
    }

    private DataSet caculateDueDays(FilterInfo filterInfo, DataSet ds) {
        String amountField;
        Boolean bShowByExpireDate = filterInfo.getBoolean("showbyexpiredate");
        Date expireDate = filterInfo.getDate("expiredate");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(expireDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        expireDate = calendar.getTime();
        String caulField = bShowByExpireDate != false ? "expiredate" : COLKEY_BIZDATE;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        InteTimeZone inteTimeZone = InteTimeZone.getSysTimeZone();
        sdf.setTimeZone(inteTimeZone.getTimeZone());
        String strDate = sdf.format(expireDate);
        String colVal = String.format("datedif(to_date(to_char(%s,'yyyy-MM-dd'),'yyyy-MM-dd','%s'),to_date('%s','yyyy-MM-dd','%s'),'D')", caulField, inteTimeZone.getTimeArea(), strDate, inteTimeZone.getTimeArea());
        DataSet dsRst = ds.addField(colVal, COLKEY_DIFFDAY);
        String string = amountField = this.qParam.isSynCurrency() ? "amountbal" : "amountbalfor";
        if (this.qParam.isSynCurrency()) {
            dsRst = dsRst.addField(String.format("case when %s<=0 then %s else 0 end", COLKEY_DIFFDAY, amountField), "unduetotal");
            dsRst = dsRst.addField(String.format("case when %s>0 then %s else 0 end", COLKEY_DIFFDAY, amountField), "overduetotal");
            dsRst = this.addOverDueColumns(dsRst, amountField, "");
            dsRst = this.addUnDueColumns(dsRst, amountField, "");
            dsRst = dsRst.addField(String.format("%s+%s", "unduetotal", "overduetotal"), "baltotal");
            return dsRst.filter(String.format("%s!=0 or %s!=0", "unduetotal", "overduetotal"));
        }
        dsRst = dsRst.addField(String.format("case when %s<=0 then %s else 0 end", COLKEY_DIFFDAY, "amountbalfor"), "unduetotal");
        dsRst = dsRst.addField(String.format("case when %s>0 then %s else 0 end", COLKEY_DIFFDAY, "amountbalfor"), "overduetotal");
        dsRst = dsRst.addField(String.format("case when %s<=0 then %s else 0 end", COLKEY_DIFFDAY, "amountbal"), "unduetotallocal");
        dsRst = dsRst.addField(String.format("case when %s>0 then %s else 0 end", COLKEY_DIFFDAY, "amountbal"), "overduetotallocal");
        String colKey = "local";
        dsRst = this.addOverDueColumns(dsRst, amountField, "");
        dsRst = this.addOverDueColumns(dsRst, "amountbal", colKey);
        dsRst = this.addUnDueColumns(dsRst, amountField, "");
        dsRst = this.addUnDueColumns(dsRst, "amountbal", colKey);
        dsRst = dsRst.addField(String.format("%s+%s", "unduetotal", "overduetotal"), "baltotal");
        dsRst = dsRst.addField(String.format("%s+%s", "unduetotallocal", "overduetotallocal"), "localbaltotal");
        return dsRst.filter(String.format("%s!=0 or %s!=0 or %s!=0 or %s!=0", "unduetotal", "overduetotal", "unduetotallocal", "overduetotallocal"));
    }

    private DataSet addUnDueColumns(DataSet dsRst, String amountField, String colKey) {
        for (Map.Entry entry : this.unDueRangeMap.entrySet()) {
            String colName = (String)entry.getKey();
            Tuple range = (Tuple)entry.getValue();
            if (range == null) continue;
            if ((Integer)range.item2 == 0) {
                dsRst = dsRst.addField(String.format("case when diffday<=%s then %s else 0 end", range.item1, amountField), colName + colKey);
                continue;
            }
            dsRst = dsRst.addField(String.format("case when diffday<=%s and diffday>=%s then %s else 0 end", range.item1, range.item2, amountField), colName + colKey);
        }
        return dsRst;
    }

    private DataSet addOverDueColumns(DataSet dsRst, String amountField, String colKey) {
        for (Map.Entry entry : this.overDueRangeMap.entrySet()) {
            String colName = (String)entry.getKey();
            Tuple range = (Tuple)entry.getValue();
            if (range == null) continue;
            if ((Integer)range.item2 == 0) {
                dsRst = dsRst.addField(String.format("case when diffday>=%s then %s else 0 end", range.item1, amountField), colName + colKey);
                continue;
            }
            dsRst = dsRst.addField(String.format("case when diffday>=%s and diffday<=%s then %s else 0 end", range.item1, range.item2, amountField), colName + colKey);
        }
        return dsRst;
    }

    @Override
    protected StringBuilder fileterDataSet(Set<String> dsFields) {
        StringBuilder filter = new StringBuilder();
        Set assVal = this.assistVOMap.values().stream().flatMap(x -> x.getAssValue().stream()).collect(Collectors.toSet());
        boolean isSubtotal = assVal.size() == 0;
        for (Map.Entry entry : this.assistVOMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!dsFields.contains(key)) continue;
            if (isSubtotal) {
                if (filter.length() > 0) {
                    filter.append(" or ");
                }
                filter.append(key).append(" is not null ");
                continue;
            }
            if (filter.length() > 0) {
                filter.append(" and ");
            }
            Set assValue = ((AssistVO)this.assistVOMap.get(key)).getAssValue();
            if (dsFields.contains(key) && assValue.size() > 0) {
                filter.append(key).append(" in (").append(String.join((CharSequence)",", assValue.stream().map(String::valueOf).collect(Collectors.toSet()))).append(")");
                continue;
            }
            filter.append(key).append(" is null ");
        }
        return filter;
    }

    private DataSet queryRecord(DataSet dt, Map<String, JSONArray> agingRangeMap) {
        dt = dt.select("bizdate,voucherid,description,assgrp,currencyfor,currencylocal,expiredate deadlinedate,amountbalfor,amountbal, diffday age,biznum,accountid,orgname");
        StringBuilder agesortCaseWhen = new StringBuilder("bizdate,voucherid,description,assgrp,currencyfor,currencylocal,deadlinedate,amountbalfor,amountbal,age,biznum,accountid,orgname, case");
        StringBuilder regionCaseWhen = new StringBuilder(", case");
        JSONArray list = agingRangeMap.get("true");
        StringBuilder filterStr = new StringBuilder();
        this.buildCaseWhen(list, agesortCaseWhen, false, true);
        this.buildCaseWhen(list, regionCaseWhen, true, true);
        this.buildFilter(list, filterStr, true);
        list = agingRangeMap.get("false");
        this.buildCaseWhen(list, agesortCaseWhen, false, false);
        this.buildCaseWhen(list, regionCaseWhen, true, false);
        this.buildFilter(list, filterStr, false);
        agesortCaseWhen.append(" end as agesort ");
        regionCaseWhen.append(" end as region ");
        if (filterStr.length() > 3) {
            dt = dt.filter(filterStr.substring(3));
        }
        String sb = agesortCaseWhen.append((CharSequence)regionCaseWhen).toString();
        dt = dt.select(sb);
        dt = dt.addField("4", "rowtype");
        return dt;
    }

    private void buildCaseWhen(JSONArray list, StringBuilder caseWhen, boolean isRegion, boolean isOverDue) {
        if (list != null && list.size() > 0) {
            for (Object tuple : list) {
                JSONObject obj = (JSONObject)tuple;
                Integer item1 = obj.getInteger("item1");
                Integer item2 = obj.getInteger("item2");
                String region = item2 != 0 ? item2 + "" : "";
                region = "'" + item1 + "-" + region + "'";
                String string = region = isRegion ? region : item1.toString();
                if (isOverDue) {
                    caseWhen.append(" when age >= ").append(item1);
                    if (item2 != 0) {
                        caseWhen.append(" and age <= ").append(item2);
                    }
                    caseWhen.append(" then ").append(region);
                    continue;
                }
                caseWhen.append(" when age <= ").append(item1);
                if (item2 != 0) {
                    caseWhen.append(" and age >= ").append(item2);
                }
                caseWhen.append(" then ").append(region);
            }
        } else if (isOverDue) {
            caseWhen.append(" when age >= ").append(" 1 ");
            if (isRegion) {
                caseWhen.append(" then ").append("'0-'");
            } else {
                caseWhen.append(" then ").append("1");
            }
        } else {
            caseWhen.append(" when age <= ").append(" 0 ");
            if (isRegion) {
                caseWhen.append(" then ").append("'-0'");
            } else {
                caseWhen.append(" then ").append(" 0 ");
            }
        }
    }

    private void buildFilter(JSONArray list, StringBuilder filterStr, boolean isOverDue) {
        if (list != null) {
            for (Object tuple : list) {
                JSONObject obj = (JSONObject)tuple;
                Integer item1 = obj.getInteger("item1");
                Integer item2 = obj.getInteger("item2");
                if (isOverDue) {
                    filterStr.append(" or ( age >= ").append(item1);
                    if (item2 != 0) {
                        filterStr.append(" and age <= ").append(item2);
                    }
                    filterStr.append(" ) ");
                    continue;
                }
                filterStr.append(" or ( age <= ").append(item1);
                if (item2 != 0) {
                    filterStr.append(" and age >= ").append(item2);
                }
                filterStr.append(" ) ");
            }
        }
    }

    private DataSet subTotalDataset(DataSet dataset) {
        DataSet sum = dataset.select(new String[]{"amountbalfor", "amountbal", CURRENCYFIELD, CURRENCYLOCAL, AGESORT, REGION}).groupBy(new String[]{CURRENCYFIELD, CURRENCYLOCAL, AGESORT, REGION}).sum("amountbalfor").sum("amountbal").finish();
        DataSet total = sum.addNullField(new String[]{"period", "bizdate", "bookeddate1", "voucherid", "assgrp", "deadlinedate", "vouchernumber", "id", "age", "biznum", "accountid", COLKEY_ORG}).addField("5", "rowtype").addField(String.format(ResManager.loadKDString((String)"%1$s\u5c0f\u8ba1%2$s", (String)"ReciprocalAgingDetailQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), "region+'", "'"), "description");
        return total.select(SELECTARRAY);
    }

    private DataSet totalDataset(DataSet dataset) {
        DataSet sum;
        if (this.qParam.isSynCurrency()) {
            sum = dataset.filter("voucherid !=null").select(new String[]{"amountbal", CURRENCYLOCAL}).groupBy(new String[]{CURRENCYLOCAL}).sum("amountbal").finish();
            sum = sum.addNullField(new String[]{CURRENCYFIELD, "amountbalfor"});
        } else {
            sum = dataset.filter("voucherid !=null").select(new String[]{"amountbalfor", "amountbal", CURRENCYFIELD, CURRENCYLOCAL}).groupBy(new String[]{CURRENCYFIELD, CURRENCYLOCAL}).sum("amountbalfor").sum("amountbal").finish();
        }
        DataSet total = sum.addNullField(new String[]{"period", "bizdate", "bookeddate1", "voucherid", "assgrp", "deadlinedate", "biznum", "vouchernumber", "id", "age", AGESORT, REGION, "biznum", "accountid", COLKEY_ORG}).addField("6", "rowtype").addField(String.format(ResManager.loadKDString((String)"%1$s\u5408\u8ba1%2$s", (String)"ReciprocalAgingDetailQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]), "'", "'"), "description");
        return total.select(SELECTARRAY);
    }

    @Override
    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        boolean isShowOrg = this.getQueryParam().getFilter().getBoolean("showorg");
        for (AbstractReportColumn col : columns) {
            ReportColumn rptColumn = (ReportColumn)col;
            if (!COLKEY_ORG.equals(rptColumn.getFieldKey())) continue;
            if (isShowOrg) break;
            rptColumn.setHide(true);
            break;
        }
        if (this.qParam.isSynCurrency()) {
            columns.forEach(c -> {
                ReportColumn column = (ReportColumn)c;
                if ("amountbalfor".equals(((ReportColumn)c).getFieldKey()) || CURRENCYFIELD.equals(((ReportColumn)c).getFieldKey())) {
                    column.setHide(true);
                }
                if (CURRENCYLOCAL.equals(((ReportColumn)c).getFieldKey())) {
                    column.setHide(false);
                }
            });
        }
        return columns;
    }
}

