/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.enums.report.RptSearchType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.GLUtil;

public class SLTreeBalanceZeroService {
    static Set<Long> getBalanceZeroAccounts(MulOrgQPRpt queryParam, Set<Long> mids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.appendIn("select A.fid from t_bd_account A where A.fid", mids.toArray());
        sqlBuilder.append(" and exists ( ", new Object[0]);
        sqlBuilder.append("SELECT 1 FROM t_bd_accountbooks bk where ", new Object[0]);
        sqlBuilder.appendIn(" bk.fbookstypeid", new Object[]{queryParam.getBookType()});
        sqlBuilder.appendIn(" and bk.forgid", queryParam.getAllEntityOrgs().toArray());
        sqlBuilder.append(" and exists ( ", new Object[0]);
        sqlBuilder.append("SELECT 1 FROM t_gl_balance B where ", new Object[0]);
        sqlBuilder.append(" B.forgid = bk.forgid", new Object[0]);
        sqlBuilder.appendIn(" and B.forgid", queryParam.getAllEntityOrgs().toArray());
        sqlBuilder.appendIn(" and B.faccounttableid", new Object[]{queryParam.getAccountTable()});
        sqlBuilder.append(" and B.fbooktypeid = bk.fbookstypeid ", new Object[0]);
        List comAssistFilters = queryParam.getComAssistFiltersForBal();
        for (QFilter comAssistF : comAssistFilters) {
            sqlBuilder.appendIn(" and B.f" + comAssistF.getProperty() + "id", GLUtil.getValuesFromQFilterValue((Object)comAssistF.getValue()).toArray());
        }
        if (queryParam.getCurrency() != 0L) {
            sqlBuilder.appendIn(" and B.fcurrencyid", new Object[]{queryParam.getCurrency()});
        }
        sqlBuilder.appendIn(" and B.fendperiodid", PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)queryParam.getEndPeriod(), (Long[])queryParam.getAllEntityOrgs().toArray(new Long[0])).toArray());
        sqlBuilder.append(" and B.fperiodid <= " + queryParam.getEndPeriod(), new Object[0]);
        sqlBuilder.append(String.format(" and (%s) and A.fid = B.faccountid))", SLTreeBalanceZeroService.getZeroFilter(queryParam)), new Object[0]);
        return (Set)DB.query((DBRoute)new DBRoute("fi"), (SqlBuilder)sqlBuilder, resultSet -> {
            HashSet<Long> acctMids = new HashSet<Long>(32);
            while (resultSet.next()) {
                acctMids.add(resultSet.getLong("fid"));
            }
            return acctMids;
        });
    }

    static String getZeroFilter(MulOrgQPRpt queryParam) {
        LocalCurrencyConfigVO config;
        String endLocalKey = "fendlocal";
        String localeCurType = queryParam.getLocaleCurType();
        if (localeCurType != null && !"LocalCurrency".equals(localeCurType) && (config = LocalCurrencyConfigService.getCurrencyConfig((String)localeCurType)) != null) {
            endLocalKey = config.getSqlBalanceFields(new MCT[]{MCT.END});
        }
        StringBuilder zeroFilter = new StringBuilder(" B.");
        zeroFilter.append(endLocalKey);
        zeroFilter.append(" != 0 ");
        if (queryParam.isQueryCurrency()) {
            zeroFilter.append(" or B.fendfor != 0 ");
        }
        if (queryParam.isShowSumQty()) {
            zeroFilter.append(" or B.fendqty != 0 ");
        }
        return zeroFilter.toString();
    }

    public static Set<Long> filter(MulOrgQPRpt queryParam, Set<Long> oriMids) {
        FilterInfo filterInfo = queryParam.getFilterInfo();
        if (!queryParam.isNoZeroBalance() || queryParam.isSubstractPL() || RptSearchType.of((FilterInfo)filterInfo) == RptSearchType.byDate || filterInfo.getCommFilter("gl_voucher") != null) {
            return oriMids;
        }
        oriMids = new HashSet<Long>(oriMids);
        Set selectedMids = ReportUtils.getSelectedLeafChildMids((FilterInfo)filterInfo, (List)queryParam.getAllEntityOrgs(), (long)queryParam.getAccountTable(), (Date)PeriodService.getEndDate((long)queryParam.getEndPeriod()));
        Set<Long> mids = SLTreeBalanceZeroService.getBalanceZeroAccounts(queryParam, selectedMids);
        if (queryParam.isNoZeroAmount()) {
            oriMids.addAll(mids);
        } else {
            oriMids.retainAll(mids);
        }
        return oriMids;
    }
}

