/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.math.BigDecimal;
import kd.bos.algo.Row;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subledger.SubLedgerBalSelector;
import kd.fi.gl.report.subledger.SubLedgerCollector;
import kd.fi.gl.report.subledger.SubLedgerOutPutIndex;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.util.GLUtil;

public class SubLedgerBalFunction
implements OutPutFunction {
    protected ISelector selector;
    protected SubLedgerOutPutIndex opIndex;
    private SubLedgerReportQuery reportQuery;
    private int fieldCount;
    private long startPeriod;
    private int comAssistSize;

    SubLedgerBalFunction() {
    }

    public SubLedgerBalFunction(ISelector selector) {
        this.selector = selector;
        this.reportQuery = (SubLedgerReportQuery)selector.getReportQuery();
        this.opIndex = this.reportQuery.getOutPutIndex();
        this.fieldCount = this.reportQuery.getRowMeta().getFieldCount();
        QueryParamRpt qpRpt = this.reportQuery.getQueryParam();
        this.startPeriod = qpRpt.getStartPeriod();
        this.comAssistSize = ((SubLedgerBalSelector)selector).qpRpt.getCommonAssists().size();
    }

    @Override
    public void output(Row row, ICollector collector) {
        Object[] result = this.getData(row);
        ((SubLedgerCollector)collector).collectBeginData(result);
    }

    protected Object[] getData(Row row) {
        int i;
        SubLedgerBalSelector balSelector = (SubLedgerBalSelector)this.selector;
        Object[] result = new Object[this.fieldCount];
        Long orgID = row.getLong(balSelector.getOrgIndex());
        result[this.opIndex.getOrgIndex()] = orgID;
        for (int i2 = 0; i2 < this.comAssistSize; ++i2) {
            result[this.opIndex.getComAssistIndex((int)i2)] = row.get(balSelector.getComAssistIndex(i2));
        }
        Long acctMid = row.getLong(balSelector.getAccountIndex());
        result[this.opIndex.getAccountIndex()] = this.reportQuery.getAccountLevelTransfer().transfer(orgID, acctMid);
        if (this.opIndex.getCurrencyIndex() != -1) {
            result[this.opIndex.getCurrencyIndex()] = row.get(balSelector.getCurrencyIndex());
        }
        if (this.opIndex.getMeasureunitIndex() != -1) {
            result[this.opIndex.getMeasureunitIndex()] = row.get(balSelector.getMeasureunitIndex());
        }
        long ipStartPeriod = row.getLong(balSelector.getStartPeriodIndex());
        long ipEndPeriod = row.getLong(balSelector.getEndPeriodIndex());
        int[] opEndIndexes = this.opIndex.getEndIndexesArr();
        int length = opEndIndexes.length;
        int[] beginIndexes = balSelector.getBeginIndexes();
        int[] endIndexes = balSelector.getEndIndexes();
        if (ipStartPeriod == this.startPeriod) {
            for (i = 0; i < opEndIndexes.length; ++i) {
                result[opEndIndexes[i]] = row.get(beginIndexes[i]);
            }
        } else if (ipStartPeriod < this.startPeriod && ipEndPeriod > this.startPeriod) {
            for (i = 0; i < opEndIndexes.length; ++i) {
                result[opEndIndexes[i]] = row.get(endIndexes[i]);
            }
        }
        BigDecimal[] tempDebitValues = this.createArray(length);
        BigDecimal[] tempCreditValues = this.createArray(length);
        int[] debitIndexes = balSelector.getDebitIndexes();
        int[] creditIndexes = balSelector.getCreditIndexes();
        if (ipStartPeriod == this.startPeriod) {
            for (int i3 = 0; i3 < length; ++i3) {
                tempDebitValues[i3] = row.get(debitIndexes[i3]);
                tempCreditValues[i3] = row.get(creditIndexes[i3]);
            }
        }
        BigDecimal[] tempYearDebitValues = this.createArray(length);
        BigDecimal[] tempYearCreditValues = this.createArray(length);
        int[] yearDebitIndexes = balSelector.getYearDebitIndexes();
        int[] yearCreditIndexes = balSelector.getYearCreditIndexes();
        long yearFlag = this.startPeriod / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L;
        if (ipEndPeriod > this.startPeriod && ipStartPeriod <= this.startPeriod && ipStartPeriod > yearFlag) {
            for (int i4 = 0; i4 < length; ++i4) {
                tempYearDebitValues[i4] = row.get(yearDebitIndexes[i4]);
                tempYearCreditValues[i4] = row.get(yearCreditIndexes[i4]);
            }
        }
        int[] opDebitIndexes = this.opIndex.getDebitIndexes();
        int[] opCreditIndexes = this.opIndex.getCreditIndexes();
        for (int i5 = 0; i5 < length; ++i5) {
            result[opDebitIndexes[i5]] = RptUtil.subtract(tempYearDebitValues[i5], tempDebitValues[i5]);
            result[opCreditIndexes[i5]] = RptUtil.subtract(tempYearCreditValues[i5], tempCreditValues[i5]);
        }
        result[this.opIndex.getRowTypeIndex()] = "1";
        result[this.opIndex.getRowIndex()] = "1";
        result[this.opIndex.getPeriodIndex()] = 0L;
        result[this.opIndex.getBookDateStrIndex()] = "";
        return result;
    }

    protected BigDecimal[] createArray(int length) {
        BigDecimal[] result = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            result[i] = BigDecimal.ZERO;
        }
        return result;
    }
}

