/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.subledger.SubLedgerBalFunction;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class SubLedgerBalSelector
implements ISelector {
    protected QueryParamRpt qpRpt;
    protected String selField;
    protected List<String> queryField;
    protected SubLedgerReportQuery reportQuery;
    protected OutPutFunction outPutFunction;
    protected QFilter[] qFilters;
    protected int orgIndex;
    protected List<Integer> comAssistIndexer;
    protected int accountIndex;
    protected int currencyIndex;
    protected int assgrpIndex;
    protected int measureunitIndex;
    protected int startPeriodIndex;
    protected int endPeriodIndex;
    protected int[] beginIndexes;
    protected int[] endIndexes;
    protected int[] debitIndexes;
    protected int[] creditIndexes;
    protected int[] yearDebitIndexes;
    protected int[] yearCreditIndexes;

    SubLedgerBalSelector() {
    }

    public SubLedgerBalSelector(SubLedgerReportQuery reportQuery) {
        this.reportQuery = reportQuery;
        this.qpRpt = reportQuery.getQueryParam();
        this.outPutFunction = new SubLedgerBalFunction(this);
        this.init();
    }

    private void init() {
        this.qFilters = this.initQFilters();
        this.selField = this.initSel();
        this.initIndexes();
    }

    protected void initIndexes() {
        if (this.qpRpt.isShowRpt() || this.qpRpt.isShowOrg()) {
            this.orgIndex = this.queryField.indexOf("org");
        }
        this.comAssistIndexer = this.qpRpt.getCommonAssists().stream().map(comAssist -> this.queryField.indexOf(comAssist.key)).collect(Collectors.toList());
        this.accountIndex = this.queryField.indexOf("account");
        this.currencyIndex = this.queryField.indexOf("currency");
        if (this.qpRpt.isShowAssist()) {
            this.assgrpIndex = this.queryField.indexOf("assgrp");
        }
        this.measureunitIndex = this.queryField.indexOf("measureunit");
        this.startPeriodIndex = this.queryField.indexOf("period");
        this.endPeriodIndex = this.queryField.indexOf("endperiod");
        this.beginIndexes = this.setIndexes("begin");
        this.endIndexes = this.setIndexes("end");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.yearDebitIndexes = this.setIndexes("yeardebit");
        this.yearCreditIndexes = this.setIndexes("yearcredit");
    }

    protected int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(16);
        for (String field : this.merge(flag)) {
            list.add(this.queryField.indexOf(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    protected List<String> merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        String types = this.reportQuery.getOutPutIndex().getTypes();
        for (String pre : prefix.split(",")) {
            for (String suf : types.split(",")) {
                if (suf.equals("price")) {
                    list.add(pre + "qty");
                    continue;
                }
                list.add(pre + suf);
            }
        }
        return list;
    }

    @Override
    public List<String> getQueryFields() {
        return this.queryField;
    }

    @Override
    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    @Override
    public SubLedgerReportQuery getReportQuery() {
        return this.reportQuery;
    }

    @Override
    public DataSet getDataSet(QFilter[] filter) {
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".balance"), (String)"gl_balance", (String)this.selField, (QFilter[])(filter == null ? this.qFilters : filter), null);
    }

    @Override
    public OutPutFunction getOutPutFunction() {
        return this.outPutFunction;
    }

    public int getOrgIndex() {
        return this.orgIndex;
    }

    public int getComAssistIndex(int num) {
        return this.comAssistIndexer.get(num);
    }

    public int getAccountIndex() {
        return this.accountIndex;
    }

    public int getCurrencyIndex() {
        return this.currencyIndex;
    }

    public int getMeasureunitIndex() {
        return this.measureunitIndex;
    }

    public int[] getBeginIndexes() {
        return this.beginIndexes;
    }

    public int[] getEndIndexes() {
        return this.endIndexes;
    }

    public int getStartPeriodIndex() {
        return this.startPeriodIndex;
    }

    public int getEndPeriodIndex() {
        return this.endPeriodIndex;
    }

    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int[] getYearDebitIndexes() {
        return this.yearDebitIndexes;
    }

    public int[] getYearCreditIndexes() {
        return this.yearCreditIndexes;
    }

    public int getAssgrpIndex() {
        return this.assgrpIndex;
    }

    public void setOutPutFunction(SubLedgerBalFunction outPutFunction) {
        this.outPutFunction = outPutFunction;
    }

    protected String initSel() {
        ArrayList<String> sel = new ArrayList<String>(16);
        sel.add("account");
        if (this.qpRpt.isShowRpt() || this.qpRpt.isShowOrg()) {
            sel.add("org");
        }
        this.qpRpt.getCommonAssists().forEach(commonAssist -> sel.add(commonAssist.key));
        if (this.qpRpt.isQueryCurrency()) {
            sel.add("currency");
        }
        if (this.qpRpt.isShowAssist()) {
            sel.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sel.add("measureunit");
        }
        MulCurReportUtil.addBalanceAmountFields(sel, (String)this.qpRpt.getLocaleCurType());
        if (this.qpRpt.isQueryCurrency()) {
            sel.add("beginfor");
            sel.add("endfor");
            sel.add("debitfor");
            sel.add("creditfor");
            sel.add("yeardebitfor");
            sel.add("yearcreditfor");
        }
        if (this.qpRpt.isShowQty()) {
            sel.add("beginqty");
            sel.add("endqty");
            sel.add("debitqty");
            sel.add("creditqty");
            sel.add("yeardebitqty");
            sel.add("yearcreditqty");
        }
        sel.add("period");
        sel.add("endperiod");
        this.queryField = sel.stream().map(x -> x.contains(" ") ? x.split(" ")[1] : x).collect(Collectors.toList());
        return ((Object)sel).toString().replace("[", "").replace("]", "");
    }

    protected QFilter[] initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getAllEntityOrgs()));
        list.addAll(this.qpRpt.getComAssistFiltersForBal());
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        list.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)this.qpRpt.getStartPeriod(), (Long[])this.qpRpt.getAllEntityOrgs().toArray(new Long[0]))));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getEndPeriod()));
        list.add(new QFilter("period", ">=", (Object)(this.qpRpt.getEndPeriod() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        list.add(new QFilter("account", "in", this.reportQuery.getAllQueryMids()));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        return list.toArray(new QFilter[0]);
    }
}

