/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.math.BigDecimal;
import kd.bos.algo.Row;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subledger.SubLedgerBalFunction;
import kd.fi.gl.report.subledger.SubLedgerCollector;
import kd.fi.gl.report.subledger.SubLedgerInitBalSelector;
import kd.fi.gl.report.subledger.SubLedgerOutPutIndex;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;

public class SubLedgerInitBalFunction
extends SubLedgerBalFunction {
    protected SubLedgerInitBalSelector selector;
    private int fieldCount;

    public SubLedgerInitBalFunction(SubLedgerInitBalSelector selector) {
        this.selector = selector;
        SubLedgerReportQuery reportQuery = selector.getReportQuery();
        this.opIndex = (SubLedgerOutPutIndex)reportQuery.getOutPutIndex();
        this.fieldCount = reportQuery.getRowMeta().getFieldCount();
    }

    @Override
    public void output(Row row, ICollector collector) {
        Object[] result = this.getData(row);
        ((SubLedgerCollector)collector).collectBeginData(result);
    }

    @Override
    protected Object[] getData(Row row) {
        SubLedgerInitBalSelector balSelector = this.selector;
        Object[] result = new Object[this.fieldCount];
        Long orgID = row.getLong(balSelector.getOrgIndex());
        result[this.opIndex.getOrgIndex()] = orgID;
        for (int i = 0; i < balSelector.qpRpt.getCommonAssists().size(); ++i) {
            result[this.opIndex.getComAssistIndex((int)i)] = row.get(balSelector.getComAssistIndex(i));
        }
        result[this.opIndex.getAccountIndex()] = this.selector.getReportQuery().getAcctMidOnLevel(orgID, row.getLong(balSelector.getAccountIndex()));
        if (this.opIndex.getCurrencyIndex() != -1) {
            result[this.opIndex.getCurrencyIndex()] = row.get(balSelector.getCurrencyIndex());
        }
        if (this.opIndex.getMeasureunitIndex() != -1) {
            result[this.opIndex.getMeasureunitIndex()] = row.get(balSelector.getMeasureunitIndex());
        }
        int[] yearProfitDebitIndexes = this.selector.getYearProfitDebitIndexes();
        int[] yearProfitCreditIndexes = this.selector.getYearProfitCreditIndexes();
        int[] yearDebitIndexes = this.selector.getYearDebitIndexes();
        int[] yearCreditIndexes = this.selector.getYearCreditIndexes();
        int[] opEndIndexes = this.opIndex.getEndIndexesArr();
        int[] opDebitIndexes = this.opIndex.getDebitIndexes();
        int[] opCreditIndexes = this.opIndex.getCreditIndexes();
        for (int i = 0; i < yearProfitDebitIndexes.length; ++i) {
            BigDecimal debitVal = row.getBigDecimal(yearProfitDebitIndexes[i]).subtract(row.getBigDecimal(yearDebitIndexes[i]));
            BigDecimal creditVal = row.getBigDecimal(yearProfitCreditIndexes[i]).subtract(row.getBigDecimal(yearCreditIndexes[i]));
            result[opEndIndexes[i]] = RptUtil.subtract(debitVal, creditVal);
            result[opDebitIndexes[i]] = debitVal;
            result[opCreditIndexes[i]] = creditVal;
        }
        result[this.opIndex.getRowTypeIndex()] = "1";
        result[this.opIndex.getRowIndex()] = "1";
        result[this.opIndex.getPeriodIndex()] = 0L;
        result[this.opIndex.getBookDateStrIndex()] = "";
        return result;
    }
}

