/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.subledger.SubLedgerBalSelector;
import kd.fi.gl.report.subledger.SubLedgerInitBalFunction;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class SubLedgerInitBalSelector
extends SubLedgerBalSelector {
    private int[] yearProfitDebitIndexes;
    private int[] yearProfitCreditIndexes;
    private Set<Long> closedInitOrgs;

    public SubLedgerInitBalSelector(SubLedgerReportQuery reportQuery) {
        this.reportQuery = reportQuery;
        this.qpRpt = reportQuery.getQueryParam();
        this.initOrg();
        this.initSelet();
        this.qFilters = this.initQFilters();
        this.outPutFunction = new SubLedgerInitBalFunction(this);
        this.initIndexes();
    }

    @Override
    public DataSet getDataSet(QFilter[] filters) {
        filters = filters == null ? this.qFilters : filters;
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_initbalance", (String)this.selField, (QFilter[])filters, null);
    }

    private void initOrg() {
        QFilter btFilter = new QFilter("bookstype", "=", (Object)this.qpRpt.getBookType());
        long periodYear = this.qpRpt.getStartPeriod() / GLUtil.YEAR_PERIOD_L % 10000L;
        QFilter periodFilter = new QFilter("startperiod.periodyear", "=", (Object)periodYear);
        QFilter endFilter = new QFilter("isendinit", "=", (Object)true);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{btFilter, periodFilter, endFilter});
        this.closedInitOrgs = books.stream().mapToLong(x -> x.getLong("org")).boxed().collect(Collectors.toSet());
    }

    private void initSelet() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("currency");
        }
        sels.add("org");
        this.qpRpt.getCommonAssists().forEach(commonAssist -> sels.add(commonAssist.key));
        if (this.qpRpt.isShowAssist()) {
            sels.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("measureunit");
        }
        sels.addAll(this.merge("yearprofitdebit"));
        sels.addAll(this.merge("yearprofitcredit"));
        sels.addAll(this.merge("yeardebit"));
        sels.addAll(this.merge("yearcredit"));
        sels.remove("yearcreditlocal");
        sels.remove("yearprofitcreditlocal");
        sels.remove("yeardebitlocal");
        sels.remove("yearprofitdebitlocal");
        sels.addAll(MulCurReportUtil.getInitBalanceLocalAmountFields2((String)this.qpRpt.getLocaleCurType()));
        this.selField = ((Object)sels).toString().replace("[", "").replace("]", "");
        this.queryField = new ArrayList();
        for (String sel : sels) {
            String[] split = sel.split(" ");
            if (split.length == 1) {
                this.queryField.add(split[0]);
                continue;
            }
            this.queryField.add(split[1]);
        }
    }

    @Override
    protected List<String> merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        String types = this.reportQuery.getOutPutIndex().getTypes();
        for (String pre : prefix.split(",")) {
            for (String suf : types.split(",")) {
                if (suf.equals("price")) continue;
                list.add(pre + suf);
            }
        }
        return list;
    }

    @Override
    protected final void initIndexes() {
        if (this.qpRpt.isShowRpt() || this.qpRpt.isShowOrg()) {
            this.orgIndex = this.queryField.indexOf("org");
        }
        this.comAssistIndexer = this.qpRpt.getCommonAssists().stream().map(comAssist -> this.queryField.indexOf(comAssist.key)).collect(Collectors.toList());
        this.accountIndex = this.queryField.indexOf("account");
        this.currencyIndex = this.queryField.indexOf("currency");
        if (this.qpRpt.isShowAssist()) {
            this.assgrpIndex = this.queryField.indexOf("assgrp");
        }
        this.measureunitIndex = this.queryField.indexOf("measureunit");
        this.startPeriodIndex = this.queryField.indexOf("period");
        this.endPeriodIndex = this.queryField.indexOf("endperiod");
        this.beginIndexes = this.setIndexes("begin");
        this.endIndexes = this.setIndexes("end");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.yearDebitIndexes = this.setIndexes("yeardebit");
        this.yearCreditIndexes = this.setIndexes("yearcredit");
        this.yearProfitDebitIndexes = this.setIndexes("yearprofitdebit");
        this.yearProfitCreditIndexes = this.setIndexes("yearprofitcredit");
    }

    @Override
    protected final QFilter[] initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>(4);
        list.add(new QFilter("org", "in", this.closedInitOrgs));
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getAllEntityOrgs()));
        list.addAll(this.qpRpt.getComAssistFiltersForBill(key -> key));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        if (this.qpRpt.getMasterIdSet() != null) {
            list.add(new QFilter("account", "in", this.reportQuery.getAllQueryIds()));
        }
        list.add(new QFilter("account.pltype", "!=", (Object)"0"));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        return list.toArray(new QFilter[0]);
    }

    public int[] getYearProfitDebitIndexes() {
        return this.yearProfitDebitIndexes;
    }

    public int[] getYearProfitCreditIndexes() {
        return this.yearProfitCreditIndexes;
    }
}

