/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportDsExtProcessHelper;
import kd.fi.gl.report.subledger.SubLedgerDetailQuery;
import kd.fi.gl.report.subledger.SubLedgerTotalQuery;
import kd.fi.gl.report.subsidiary.DetailQuery;
import kd.fi.gl.report.subsidiary.TotalCalculateReportPlugin;
import kd.fi.gl.util.ReportFieldSettingUtil;

public class SubLedgerReportListDataPlugin
extends TotalCalculateReportPlugin<Object> {
    public SubLedgerReportListDataPlugin() {
        super(new SubLedgerDetailQuery(), new SubLedgerTotalQuery());
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        DataSet dataSet = super.query(queryParam, selectedObj);
        dataSet = ReportDsExtProcessHelper.doExtProcess(queryParam, dataSet, "gl_rpt_subledger");
        return dataSet;
    }

    @Override
    protected String serializeSelectObj(Object selectedObj) {
        StringBuilder builder = new StringBuilder();
        if (selectedObj instanceof DynamicObject) {
            builder.append(((DynamicObject)selectedObj).getLong("id"));
        }
        if (selectedObj instanceof DynamicObjectCollection) {
            ((DynamicObjectCollection)selectedObj).forEach(dyo -> builder.append(dyo.getLong("id")).append("|"));
        }
        return builder.toString();
    }

    @Override
    protected Object deSerializeSelectObj(String str) {
        if (str.contains("|")) {
            Object[] ids = Arrays.stream(str.substring(0, str.length() - 1).split("\\|")).mapToLong(Long::parseLong).boxed().toArray();
            Map entityMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bd_accountview");
            DynamicObjectCollection dyos = null;
            for (Object id : ids) {
                DynamicObject entity = (DynamicObject)entityMap.get(id);
                assert (entity != null);
                if (dyos == null) {
                    dyos = new DynamicObjectCollection(entity.getDynamicObjectType(), null);
                }
                dyos.add((Object)entity);
            }
            return dyos;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(str), (String)"bd_accountview");
    }

    @Override
    protected boolean needCalculateTotalWithDetailAfterDetailQuery(DetailQuery<Object> detailQuery) {
        return !Boolean.parseBoolean(this.getContext().query("totalRowRemoved").toString());
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        FilterInfo filter = this.getQueryParam().getFilter();
        if (filter.getFilterItems().isEmpty()) {
            return columns;
        }
        QueryParamRpt qpRpt = new QueryParamRpt(filter);
        List<ReportColumn> list = this.getAllReportColumns(columns);
        for (ReportColumn column : list) {
            String fieldKey;
            switch (fieldKey = column.getFieldKey()) {
                case "endprice": 
                case "endqty": {
                    column.setHide(!qpRpt.isShowSumQty());
                    break;
                }
                case "opacctname": 
                case "opassgrp": {
                    column.setHide(!qpRpt.isShowOpAccount());
                    break;
                }
                case "debitrpt": 
                case "creditrpt": 
                case "endrpt": {
                    column.setHide(!qpRpt.isShowRpt());
                    break;
                }
                case "measureunit": {
                    column.setHide(!qpRpt.isShowQty());
                    break;
                }
            }
        }
        columns.add((AbstractReportColumn)this.createVentryColumn());
        columns.addAll(ReportFieldSettingUtil.createCustomColumns((String)"gl_rpt_subledger"));
        ComAssistTableService.modifyReportColumn((ComAssistTable)ComAssistTable.get((Long)qpRpt.getAccountTable()), list);
        ReportColumn orgIdColumn = new ReportColumn();
        orgIdColumn.setHide(true);
        orgIdColumn.setFieldKey("flexorgid");
        orgIdColumn.setEntityId("bos_org");
        orgIdColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AssistBalHelper_4", (String)"fi-gl-report", (Object[])new Object[0])));
        orgIdColumn.setFieldType("basedata");
        columns.add((AbstractReportColumn)orgIdColumn);
        return columns;
    }

    private ReportColumn createVentryColumn() {
        ReportColumn ventryColumn = new ReportColumn();
        ventryColumn.setHide(true);
        ventryColumn.setFieldKey("fentryid");
        ventryColumn.setFieldType("text");
        return ventryColumn;
    }

    private List<ReportColumn> getAllReportColumns(List<AbstractReportColumn> columns) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                list.add((ReportColumn)column);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup group = (ReportColumnGroup)column;
            list.addAll(this.getAllReportColumns(group.getChildren()));
        }
        return list;
    }
}

