/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subledger.SubLedgerOutPutIndex;
import kd.fi.gl.report.subledger.SubLedgerQueryRpt;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.report.subledger.SubLedgerVouSelector;
import kd.fi.gl.report.subsidiary.TotalQuery;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.MulCurReportUtil;

public class SubLedgerTotalQuery
implements TotalQuery<Object> {
    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj, Context context) {
        int i;
        DataSet beginAndYearDS = Algo.getCacheDataSet((String)((String)context.query("beginAndYearCacheID"))).toDataSet(Algo.create((String)(this.getClass().getSimpleName() + "#rebuild")), false);
        RowMeta rowMeta = beginAndYearDS.getRowMeta();
        Row beginRow = beginAndYearDS.next();
        SettableArrayRow yearRow = new SettableArrayRow(rowMeta, ((AbstractRow)beginAndYearDS.next()).values(), false);
        SettableArrayRow periodRow = null;
        SubLedgerQueryRpt subLedgerQueryRpt = new SubLedgerQueryRpt(queryParam, selectedObj);
        subLedgerQueryRpt.initReportQuery();
        SubLedgerReportQuery reportQuery = subLedgerQueryRpt.getReportQuery();
        SubLedgerVouSelector selector = new SubLedgerVouSelector(reportQuery, queryParam.getFilter().getCommFilter("gl_voucher"));
        Row vchSum = this.getVchSumRow(selector, (Row)yearRow);
        DataSetHelper.logRow((String)"vchSum", (AbstractRow)((AbstractRow)vchSum));
        SubLedgerOutPutIndex outPutIndex = new SubLedgerOutPutIndex(reportQuery);
        periodRow = new SettableArrayRow(rowMeta);
        System.arraycopy(yearRow.values(), 0, periodRow.values(), 0, rowMeta.getFieldCount());
        periodRow.setValue(outPutIndex.getRowTypeIndex(), (Object)"4");
        int[] creditIndexes = outPutIndex.getCreditIndexes();
        int[] debitIndexes = outPutIndex.getDebitIndexes();
        int[] endIndexes = outPutIndex.getEndIndexesArr();
        this.copyFields(vchSum, creditIndexes, periodRow, creditIndexes);
        this.copyFields(vchSum, debitIndexes, periodRow, debitIndexes);
        for (i = 0; i < endIndexes.length; ++i) {
            BigDecimal vchSumEnd = (BigDecimal)RptUtil.subtract(periodRow.get(debitIndexes[i]), periodRow.get(creditIndexes[i]));
            periodRow.setValue(endIndexes[i], RptUtil.sum(beginRow.getBigDecimal(endIndexes[i]), vchSumEnd));
        }
        for (i = 0; i < debitIndexes.length; ++i) {
            yearRow.setValue(debitIndexes[i], RptUtil.sum(yearRow.getBigDecimal(debitIndexes[i]), periodRow.getBigDecimal(debitIndexes[i])));
            yearRow.setValue(creditIndexes[i], RptUtil.sum(yearRow.getBigDecimal(creditIndexes[i]), periodRow.getBigDecimal(creditIndexes[i])));
        }
        this.copyFields((Row)periodRow, outPutIndex.getEndIndexesArr(), yearRow, outPutIndex.getEndIndexesArr());
        DataSetBuilder resultBuilder = Algo.create((String)(this.getClass().getSimpleName() + "#resultBuild")).createDataSetBuilder(rowMeta);
        resultBuilder.append((Row)periodRow);
        resultBuilder.append((Row)yearRow);
        return resultBuilder.build();
    }

    private Row getVchSumRow(SubLedgerVouSelector selector, Row yearRow) {
        SubLedgerOutPutIndex outPutIndex = selector.getReportQuery().getOutPutIndex();
        VoucherSchema schema = VoucherSchema.instance;
        List<QFilter> originFilters = Arrays.stream(selector.getFilters()).collect(Collectors.toList());
        HashMap<String, QFilter> dimKey2FilterMap = new HashMap<String, QFilter>(originFilters.size());
        dimKey2FilterMap.put(schema.org.toFullName(), new QFilter(schema.org.toFullName(), "=", (Object)yearRow.getLong(outPutIndex.getOrgIndex())));
        if (selector.getReportQuery().getQueryParam().isShowComAssistSum().booleanValue()) {
            originFilters.removeIf(filter -> filter.getProperty().contains("comassist"));
            List commonAssists = selector.qpRpt.getCommonAssistsForGroup();
            for (int i = 0; i < commonAssists.size(); ++i) {
                String key = "entries." + (String)commonAssists.get(0);
                dimKey2FilterMap.put(key, new QFilter(key, "=", (Object)yearRow.getLong(outPutIndex.getComAssistIndex(i))));
            }
        }
        if (outPutIndex.getCurrencyIndex() != -1) {
            dimKey2FilterMap.put(schema.currency.toFullName(), new QFilter(schema.currency.toFullName(), "=", (Object)yearRow.getLong(outPutIndex.getCurrencyIndex())));
        }
        if (outPutIndex.getMeasureunitIndex() != -1 && selector.getReportQuery().getQueryParam().isShowSumQty()) {
            dimKey2FilterMap.put(schema.unit.toFullName(), new QFilter(schema.unit.toFullName(), "=", (Object)yearRow.getLong(outPutIndex.getMeasureunitIndex())));
        }
        dimKey2FilterMap.put(schema.period.toFullName(), new QFilter(schema.period.toFullName(), "=", (Object)yearRow.getLong(outPutIndex.getPeriodIndex())));
        originFilters.removeIf(filter -> dimKey2FilterMap.containsKey(filter.getProperty()));
        originFilters.addAll(dimKey2FilterMap.values());
        String localeAmtFields = MulCurReportUtil.getVoucherLocalAmountFields4((String)selector.getReportQuery().getQueryParam().getLocaleCurType());
        DataSet vouchers = VoucherQueryUtils.queryDataSet((String)(localeAmtFields + ", " + Prop.toSelectFieldStr((Prop[])new Prop[]{schema.creditOri, schema.debitOri, schema.qty, schema.dc})), (QFilter[])originFilters.toArray(new QFilter[0]), null, (int)-1);
        DataSet vchSum = vouchers.addField("case when entries.entrydc='-1' then entries.quantity else 0 end", "creditQty").addField("case when entries.entrydc='1' then entries.quantity else 0 end", "debitQty").select(new String[]{schema.debitLocal.toFullName(), schema.creditLocal.toFullName(), schema.creditOri.toFullName(), schema.debitOri.toFullName(), "creditQty", "debitQty"}).groupBy().sum(schema.debitLocal.toFullName()).sum(schema.creditLocal.toFullName()).sum(schema.creditOri.toFullName()).sum(schema.debitOri.toFullName()).sum("creditQty").sum("debitQty").finish();
        assert (vchSum.hasNext());
        Row vchSumRow = vchSum.next();
        RowMeta rowMeta = outPutIndex.getRowMeta();
        SettableArrayRow row = new SettableArrayRow(rowMeta);
        this.setIfExist(row, rowMeta, "creditlocal", vchSumRow.getBigDecimal(schema.creditLocal.toFullName()));
        this.setIfExist(row, rowMeta, "creditfor", vchSumRow.getBigDecimal(schema.creditOri.toFullName()));
        this.setIfExist(row, rowMeta, "creditqty", vchSumRow.getBigDecimal("creditQty"));
        this.setIfExist(row, rowMeta, "debitlocal", vchSumRow.getBigDecimal(schema.debitLocal.toFullName()));
        this.setIfExist(row, rowMeta, "debitfor", vchSumRow.getBigDecimal(schema.debitOri.toFullName()));
        this.setIfExist(row, rowMeta, "debitqty", vchSumRow.getBigDecimal("debitQty"));
        return row;
    }

    private void setIfExist(SettableArrayRow row, RowMeta rowMeta, String field, BigDecimal value) {
        int fieldIndex = rowMeta.getFieldIndex(field, false);
        if (fieldIndex != -1) {
            row.setValue(fieldIndex, (Object)value);
        }
    }

    private void copyFields(Row src, int[] srcIndexes, SettableArrayRow dst, int[] dstIndexes) {
        for (int i = 0; i < dstIndexes.length; ++i) {
            dst.setValue(dstIndexes[i], src.get(srcIndexes[i]));
        }
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj, DataSet detailDS, Context context) {
        return Algo.create((String)(this.getClass().getName() + "#emptyDs ")).createDataSet(Collections.emptyIterator(), detailDS.getRowMeta());
    }
}

