/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.HashJoinDataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.SqlHint;
import kd.bos.algo.dataset.AbstractRow;

public class BatchDataSet
implements DataSet {
    private final Iterator<DataSet> innerDsItr;
    private RowMeta rowMeta;
    private DataSet current;
    private final List<Function<DataSet, DataSet>> simpleActionBeforeItr = new ArrayList<Function<DataSet, DataSet>>();
    private boolean iterated = false;
    private Map<String, String> addFieldMap;

    public BatchDataSet(Iterator<DataSet> innerDsItr) {
        Preconditions.checkArgument((boolean)innerDsItr.hasNext());
        this.innerDsItr = innerDsItr;
    }

    public RowMeta getRowMeta() {
        if (this.rowMeta == null) {
            this.current = this.getNextDS();
            this.rowMeta = this.current.getRowMeta();
        }
        return this.rowMeta;
    }

    public Iterator<Row> iterator() {
        final BatchDataSet inner = this;
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return inner.hasNext();
            }

            @Override
            public Row next() {
                return inner.next();
            }
        };
    }

    public boolean hasNext() {
        if (this.current == null || !this.current.hasNext()) {
            while (this.hasNextDS()) {
                this.current = this.getNextDS();
                this.rowMeta = this.current.getRowMeta();
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean hasNextDS() {
        return this.innerDsItr.hasNext();
    }

    private DataSet getNextDS() {
        this.iterated = true;
        DataSet next = this.innerDsItr.next();
        for (Function<DataSet, DataSet> action : this.simpleActionBeforeItr) {
            next = action.apply(next);
        }
        if (this.rowMeta != null) {
            final Iterator iterator = next.iterator();
            return Algo.create((String)"SplitDataSet#getNextDS").createDataSet((Iterator)new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    return ((AbstractRow)iterator.next()).values();
                }
            }, this.rowMeta);
        }
        return next;
    }

    private void checkIteratedBeforeAction() {
        if (this.iterated) {
            throw new IllegalStateException("split data set has been iterated.");
        }
    }

    public Row next() {
        if (this.hasNext()) {
            return this.current.next();
        }
        throw new IllegalStateException("no next row.");
    }

    public void close() {
        this.current.close();
        this.innerDsItr.forEachRemaining(DataSet::close);
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public DataSet select(String ... strings) {
        throw new UnsupportedOperationException();
    }

    public DataSet select(boolean b, String ... strings) {
        throw new UnsupportedOperationException();
    }

    public DataSet select(String s) {
        throw new UnsupportedOperationException();
    }

    public DataSet addField(String s, String s1) {
        return this.addFields(new String[]{s}, new String[]{s1});
    }

    public DataSet addFields(String[] exps, String[] fields) {
        this.checkIteratedBeforeAction();
        if (this.addFieldMap == null) {
            this.addFieldMap = new HashMap<String, String>(4);
            this.simpleActionBeforeItr.add(ds -> {
                if (!this.addFieldMap.isEmpty()) {
                    int size = this.addFieldMap.size();
                    String[] exps2 = new String[size];
                    String[] fields2 = new String[size];
                    Iterator<Map.Entry<String, String>> exp2FieldItr = this.addFieldMap.entrySet().iterator();
                    IntStream.range(0, size).forEach(i -> {
                        Map.Entry field2Exp = (Map.Entry)exp2FieldItr.next();
                        exps2[i] = (String)field2Exp.getValue();
                        fields2[i] = (String)field2Exp.getKey();
                    });
                    ds = ds.addFields(exps2, fields2);
                }
                return ds;
            });
        }
        for (int i = 0; i < fields.length; ++i) {
            if (this.addFieldMap.containsKey(fields[i])) {
                throw new IllegalStateException(this.getClass().getSimpleName());
            }
            this.addFieldMap.put(fields[i], exps[i]);
        }
        return this;
    }

    public DataSet updateFields(String[] strings, String[] strings1) {
        throw new UnsupportedOperationException();
    }

    public DataSet addNullField(String s) {
        throw new UnsupportedOperationException();
    }

    public DataSet addNullField(String ... strings) {
        throw new UnsupportedOperationException();
    }

    public DataSet addBalanceField(String s, String s1) {
        throw new UnsupportedOperationException();
    }

    public DataSet removeFields(String ... strings) {
        throw new UnsupportedOperationException();
    }

    public DataSet filter(String s) {
        throw new UnsupportedOperationException();
    }

    public DataSet filter(String s, Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public DataSet filter(FilterFunction filterFunction) {
        throw new UnsupportedOperationException();
    }

    public DataSet orderBy(String[] strings) {
        throw new UnsupportedOperationException();
    }

    public GroupbyDataSet groupBy() {
        throw new UnsupportedOperationException();
    }

    public GroupbyDataSet groupBy(String[] strings) {
        throw new UnsupportedOperationException();
    }

    public GroupbyDataSet groupBy(String[] strings, boolean[] booleans) {
        throw new UnsupportedOperationException();
    }

    public DataSet[] splitByGroup(String[] strings) {
        throw new UnsupportedOperationException();
    }

    public DataSet[] splitByFilter(String[] strings, boolean b) {
        throw new UnsupportedOperationException();
    }

    public HashTable toHashTable(String s) {
        throw new UnsupportedOperationException();
    }

    public HashJoinDataSet hashJoin(HashTable hashTable, String s, String[] strings) {
        throw new UnsupportedOperationException();
    }

    public HashJoinDataSet hashJoin(HashTable hashTable, String s, String[] strings, boolean b) {
        throw new UnsupportedOperationException();
    }

    public JoinDataSet join(DataSet dataSet) {
        throw new UnsupportedOperationException();
    }

    public JoinDataSet join(DataSet dataSet, JoinHint joinHint) {
        throw new UnsupportedOperationException();
    }

    public JoinDataSet join(DataSet dataSet, JoinType joinType) {
        throw new UnsupportedOperationException();
    }

    public JoinDataSet join(DataSet dataSet, JoinType joinType, JoinHint joinHint) {
        throw new UnsupportedOperationException();
    }

    public DataSet union(DataSet dataSet) {
        throw new UnsupportedOperationException();
    }

    public DataSet union(DataSet ... dataSets) {
        throw new UnsupportedOperationException();
    }

    public DataSet top(int i) {
        throw new UnsupportedOperationException();
    }

    public DataSet range(int i, int i1) {
        throw new UnsupportedOperationException();
    }

    public DataSet copy() {
        throw new UnsupportedOperationException();
    }

    public int count(String s, boolean b) {
        throw new UnsupportedOperationException();
    }

    public DataSet executeSql(String s) {
        throw new UnsupportedOperationException();
    }

    public DataSet executeSql(String s, SqlHint sqlHint) {
        throw new UnsupportedOperationException();
    }

    public CachedDataSet cache(CacheHint cacheHint) {
        throw new UnsupportedOperationException();
    }

    public CachedDataSet.Builder cacheBuilder(CacheHint cacheHint) {
        throw new UnsupportedOperationException();
    }

    public void print(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setId(String s) {
        throw new UnsupportedOperationException();
    }

    public void addListener(DataSet.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public DataSet map(MapFunction mapFunction) {
        throw new UnsupportedOperationException();
    }

    public DataSet reduceGroup(ReduceGroupFunction reduceGroupFunction) {
        throw new UnsupportedOperationException();
    }

    public DataSet reduceGroup(ReduceGroupFunctionWithCollector reduceGroupFunctionWithCollector) {
        throw new UnsupportedOperationException();
    }

    public DataSet distinct() {
        throw new UnsupportedOperationException();
    }

    public DataSet topBy(int i, String[] strings) {
        throw new UnsupportedOperationException();
    }
}

