/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.report.ReportList;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.ReportFormUtil;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.export.RecyclableRowStorage;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.export.processor.BatchProcessorChain;
import kd.fi.gl.report.export.processor.IBatchTransformer;
import kd.fi.gl.report.export.processor.ReportExcelTransformer;
import kd.fi.gl.report.subledger.export.OrderedDataSetMerger;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.source.BalanceSourceBuilder;
import kd.fi.gl.report.subledger.export.source.BeginVoucherBuilder;
import kd.fi.gl.report.subledger.export.source.VoucherSourceBuilder;
import kd.fi.gl.report.subledger.export.worker.AbstractWorker;

public class SubLedgerExporter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Context export(ReportList reportList, ExportOption exportOption, FilterInfo filterInfo, Long[] orgs) {
        long acctTableId = filterInfo.getDynamicObject("accounttable").getLong("id");
        long btId = filterInfo.getDynamicObject("booktype").getLong("id");
        long endPeriod = filterInfo.getLong("endperiod");
        orgs = (Long[])AccSysUtil.getBookFromAccSys(new HashSet<Long>(Arrays.asList(orgs)), (long)btId).stream().filter(b -> {
            HashSet<Long> tables = new HashSet<Long>(ReportFormUtil.getVerAcctTable((List)Lists.newArrayList((Object[])new Long[]{b.getOrgId()}), (long)btId, (long)endPeriod));
            tables.add(b.getAccountTableId());
            return tables.contains(acctTableId);
        }).mapToLong(AccountBookInfo::getOrgId).boxed().toArray(Long[]::new);
        try (SubLedgerQueryContext context = SubLedgerQueryContext.open(filterInfo, orgs);){
            context.timer.time("done context-open");
            boolean splitByOrg = context.getFilterInfo().containProp("enablesplitbyorg");
            Context context2 = splitByOrg ? SubLedgerExporter.doExportSplitByOrg(context, orgs, exportOption, reportList) : SubLedgerExporter.doExport(context, orgs, exportOption, reportList);
            return context2;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("export", "export error"), new Object[0]);
        }
    }

    private static Context doExport(SubLedgerQueryContext currentContext, Long[] orgIDs, ExportOption exportOption, ReportList reportList) {
        TimerFactory.Timer timer = SubLedgerQueryContext.getCurrent().timer;
        Map<Long, String> orgNameIndex = currentContext.getOrgNameCache();
        BatchProcessorChain<SubLedgerRow, Void> chain = SubLedgerExporter.openExportChain(currentContext, exportOption, reportList, false);
        timer.time("done chain-building");
        for (int i = 0; i < orgIDs.length; ++i) {
            if (i == orgIDs.length - 1) {
                chain.setFinalDataSetFlag(true);
            }
            exportOption.getExportProgress().feedbackCustData((Map)JsonObjectAdapter.getEmpty().registerContext("orgName", (Object)orgNameIndex.get(orgIDs[i])).getSource());
            Iterator<Row> source = SubLedgerExporter.openSourceData(new Long[]{orgIDs[i]});
            timer.time("done source-open" + i);
            chain.feed(source);
        }
        return chain.getContext();
    }

    private static Context doExportSplitByOrg(SubLedgerQueryContext currentContext, Long[] orgIDs, ExportOption exportOption, ReportList reportList) {
        TimerFactory.Timer timer = SubLedgerQueryContext.getCurrent().timer;
        Map<Long, String> orgNameIndex = currentContext.getOrgNameCache();
        BatchProcessorChain<SubLedgerRow, Void> chain = null;
        timer.time("done chain-building");
        ArrayList urls = new ArrayList();
        for (int i = 0; i < orgIDs.length; ++i) {
            exportOption.setOrgName(currentContext.getOrgNameCache().get(orgIDs[i]));
            chain = SubLedgerExporter.openExportChain(currentContext, exportOption, reportList, true);
            chain.setFinalDataSetFlag(true);
            exportOption.getExportProgress().feedbackCustData((Map)JsonObjectAdapter.getEmpty().registerContext("orgName", (Object)orgNameIndex.get(orgIDs[i])).getSource());
            Iterator<Row> source = SubLedgerExporter.openSourceData(new Long[]{orgIDs[i]});
            timer.time("done source-open" + i);
            chain.feed(source);
            urls.addAll((List)chain.getContext().query("downloadUrl"));
        }
        if (chain != null) {
            chain.getContext().registerContext("downloadUrl", urls);
            return chain.getContext();
        }
        return new Context();
    }

    static BatchProcessorChain<SubLedgerRow, Void> openExportChain(SubLedgerQueryContext currentContext, ExportOption exportOption, ReportList reportList, boolean splitByOrg) {
        HashMap<String, Object> progressCusData = new HashMap<String, Object>(8);
        progressCusData.put("complete", 0);
        progressCusData.put("total", 100);
        progressCusData.put("orgName", exportOption.getOrgName());
        exportOption.getExportProgress().feedbackCustData(progressCusData);
        exportOption.getExportProgress().feedbackProgress(100, 0);
        Map<Long, String> orgNameIndex = currentContext.getOrgNameCache();
        exportOption.setConditionOrgName(splitByOrg ? exportOption.getOrgName() : String.join((CharSequence)", ", orgNameIndex.values()));
        RecyclableRowStorage rowStorage = currentContext.getRowStorage();
        Iterator<AbstractWorker<SubLedgerRow, SubLedgerRow>> bizWorkerItr = currentContext.getBizWorkers().iterator();
        IDatasetRowTypeConverter converter = (ignore, row) -> {
            SubLedgerRow subLedgerRow = new SubLedgerRow(row.getString("rowtype"));
            currentContext.getCms().forEach(reportColumnManager -> reportColumnManager.fillRow(row, subLedgerRow));
            rowStorage.recycleOne((AbstractRow)row);
            return subLedgerRow;
        };
        BatchProcessorChain.Builder chainBuilder = new BatchProcessorChain.Builder(exportOption, converter, (IBatchTransformer)bizWorkerItr.next());
        bizWorkerItr.forEachRemaining(arg_0 -> ((BatchProcessorChain.Builder)chainBuilder).append(arg_0));
        ReportExcelTransformer excelTransformer = new ReportExcelTransformer(reportList, currentContext.getBatchSize().intValue());
        BatchProcessorChain chain = chainBuilder.appendLast((IBatchTransformer)excelTransformer).build();
        chain.getContext().registerContext("rowMeta", (Object)currentContext.getRowMeta());
        chain.registerContext("timer", (Object)currentContext.timer);
        chain.registerContext("rowStorage", (Object)rowStorage);
        RowMeta rowMeta = currentContext.getRowMeta();
        Map<String, Integer> index = Arrays.stream(rowMeta.getFields()).collect(Collectors.toMap(Field::getName, field -> rowMeta.getFieldIndex(field.getName())));
        chain.registerContext("colIndexMap", index);
        chain.getProcessors().forEach(IBatchTransformer::reset);
        return chain;
    }

    static Iterator<Row> openSourceData(Long[] orgs) {
        SubLedgerQueryContext currentContext = SubLedgerQueryContext.getCurrent();
        List sourceSupplier = Arrays.asList(org -> new BalanceSourceBuilder((Long[])org).beginBalance(), org -> new BeginVoucherBuilder((Long[])org).build(), org -> new VoucherSourceBuilder((Long[])org).build(), org -> new BalanceSourceBuilder((Long[])org).yearBalance());
        String debugSource = currentContext.getFilterInfo().getString("debugsource");
        if (StringUtils.isNotBlank((CharSequence)debugSource)) {
            sourceSupplier = Arrays.stream(debugSource.split(",")).mapToInt(Integer::parseInt).mapToObj(sourceSupplier::get).collect(Collectors.toList());
        }
        List<DataSet> sources = sourceSupplier.stream().map(supplier -> (DataSet)supplier.apply(orgs)).collect(Collectors.toList());
        Comparator<Object> longComparator = Comparator.comparingLong(Long.class::cast);
        Comparator<Object> stringComparator = currentContext.getStringComparator();
        return new OrderedDataSetMerger(sources, (r1, r2) -> {
            Object obj2;
            String orderField;
            Object obj1;
            Comparator comparator;
            List<String> orderDimensions = currentContext.getOrderDimensions();
            orderDimensions.add("rowtype");
            int res = 0;
            Iterator<String> iterator = orderDimensions.iterator();
            while (iterator.hasNext() && (res = (comparator = (obj1 = r1.get(orderField = iterator.next())) instanceof Long ? longComparator : stringComparator).compare(obj1, obj2 = r2.get(orderField))) == 0) {
            }
            return res;
        }, currentContext.getRowStorage()).getIterator();
    }
}

