/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.report.export.RecyclableRowStorage;
import kd.fi.gl.report.subledger.AccountLevelTransfer;
import kd.fi.gl.report.subledger.export.IColumnManager;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.cms.BaseColumnManager;
import kd.fi.gl.report.subledger.export.cms.ComAssistColumnManager;
import kd.fi.gl.report.subledger.export.cms.CusVoucherSettingColumn;
import kd.fi.gl.report.subledger.export.cms.ForeignCurrencyColumn;
import kd.fi.gl.report.subledger.export.cms.MeasureUnitColumnManager;
import kd.fi.gl.report.subledger.export.cms.OpColumnManager;
import kd.fi.gl.report.subledger.export.cms.ReportCurrencyColumn;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.worker.AbstractWorker;
import kd.fi.gl.report.subledger.export.worker.BalanceAccumulator;
import kd.fi.gl.report.subledger.export.worker.BeginBalanceWorker;
import kd.fi.gl.report.subledger.export.worker.DailySummaryWorker;
import kd.fi.gl.report.subledger.export.worker.NoZeroAmountWorker;
import kd.fi.gl.report.subledger.export.worker.NoZeroSumAmountWorker;
import kd.fi.gl.report.subledger.export.worker.PeriodSummaryWorker;
import kd.fi.gl.report.subledger.export.worker.SimpleModifyWorker;
import kd.fi.gl.report.subledger.export.worker.YearBalanceSummaryWorker;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class SubLedgerQueryContext
implements AutoCloseable {
    private static final ThreadLocal<SubLedgerQueryContext> current = new ThreadLocal();
    private final FilterInfo filterInfo;
    private final QueryStateChart stateChart;
    private List<SubLedgerColumnManager> cms;
    private List<ReportFieldSettingVo> cusFieldSettingVos;
    private final Long[] orgIDs;
    public final TimerFactory.Timer timer = TimerFactory.getTimer(this.getClass());
    private RowMeta meta = null;
    private Date startDate;
    private Date endDate;
    private Long startPeriod = 0L;
    private Long endPeriod = 0L;
    private Map<Long, String> orgNameCache;
    private final LoadingCache<Long, DynamicObject> currencyCache = SubLedgerQueryContext.getDyoLoadingCache("bd_currency", "amtprecision", 3L);
    private final LoadingCache<Long, DynamicObject> unitCache = SubLedgerQueryContext.getDyoLoadingCache("bd_measureunits", "precision, precisionaccount", 3L);
    private final LoadingCache<Long, DynamicObject> vchTypeCache = SubLedgerQueryContext.getDyoLoadingCache("gl_vouchertype", "name", 3L);
    private final LoadingCache<Long, DynamicObject> periodCache = SubLedgerQueryContext.getDyoLoadingCache("bd_period", "begindate, enddate, periodnumber", 20L);
    private Map<Long, Map<Long, ThreeTuple<String, String, String>>> id2NumNameDcCache;
    private Table<Long, Long, Long> accountId2MidTable;
    private Table<Long, Long, Long> org2Mid2LevelId;
    public final LoadingCache<Long, ExchangeRate> rateCache = CacheBuilder.newBuilder().maximumSize(16L).build(CacheLoader.from(localCurrency -> {
        Long orgID = this.getOrgIDs()[0];
        Long bookType = this.getBookType();
        Long exRateTableId = this.getMcConfig().map(configVO -> configVO.getExRateTableId(orgID.longValue(), bookType.longValue())).orElseGet(() -> AccSysUtil.getBookFromAccSys((long)orgID, (long)bookType).getExrateTableId());
        ExchangeRate rate = RateServiceHelper.getExchangeRate((Long)localCurrency, (Long)this.getFilterInfo().getLong("currencyrpt"), (Long)exRateTableId, (Date)this.getPeriodFromCache(this.getEndPeriod()).getDate("enddate"));
        if (rate == null) {
            rate = RateServiceHelper.getDefaultOne();
        }
        return rate;
    }));
    private Map<Long, Long> org2InitPeriodMap;
    private final RecyclableRowStorage rowStorage = new RecyclableRowStorage();

    public Long[] getOrgIDs() {
        return this.orgIDs;
    }

    private SubLedgerQueryContext(FilterInfo filterInfo, Long[] orgIDs) {
        this.filterInfo = filterInfo;
        this.stateChart = new QueryStateChart();
        this.orgIDs = orgIDs;
    }

    public static SubLedgerQueryContext open(FilterInfo filter, Long[] orgIDs) {
        current.set(new SubLedgerQueryContext(filter, orgIDs));
        return current.get();
    }

    public static void reset() {
        Optional.ofNullable(SubLedgerQueryContext.current).ifPresent(current -> current.set(null));
    }

    public static SubLedgerQueryContext getCurrent() {
        SubLedgerQueryContext context = current.get();
        assert (context != null);
        return context;
    }

    public static SubLedgerQueryContext setCurrent(SubLedgerQueryContext context) {
        current.set(context);
        return SubLedgerQueryContext.getCurrent();
    }

    public RowMeta getRowMeta() {
        this.meta = Optional.ofNullable(this.meta).orElseGet(() -> {
            List fields = this.getCms().stream().map(IColumnManager::getFields).reduce(new LinkedList(), (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            });
            fields.add(new Field("rowtype", (DataType)DataType.StringType));
            return new RowMeta(fields.toArray(new Field[0]));
        });
        this.getRowStorage().openStorage(this.meta, this.getBatchSize().intValue());
        return this.meta;
    }

    public List<ReportFieldSettingVo> getCusFieldSettingVos() {
        this.cusFieldSettingVos = Optional.ofNullable(this.cusFieldSettingVos).orElseGet(() -> ReportFieldSettingUtil.getDisplayFieldConfigList((String)"gl_rpt_subledger"));
        return this.cusFieldSettingVos;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public List<AbstractWorker<SubLedgerRow, SubLedgerRow>> getBizWorkers() {
        List workers = Arrays.asList(new AbstractWorker[]{new BeginBalanceWorker(), new PeriodSummaryWorker(), new OpColumnManager.OpVoucherWorker(), new YearBalanceSummaryWorker(), new DailySummaryWorker(), new BalanceAccumulator(), new NoZeroSumAmountWorker(), new NoZeroAmountWorker(), new ReportCurrencyColumn.ReportAmountWorker(), new SimpleModifyWorker()});
        String debugWorker = this.filterInfo.getString("debugworker");
        if (StringUtils.isNotBlank((CharSequence)debugWorker)) {
            workers = Arrays.stream(debugWorker.split(",")).mapToInt(Integer::parseInt).mapToObj(workers::get).collect(Collectors.toList());
        }
        return workers.stream().filter(AbstractWorker::isEnable).collect(Collectors.toList());
    }

    public List<SubLedgerColumnManager> getCms() {
        if (this.cms == null) {
            this.cms = Stream.of(new BaseColumnManager(), new ComAssistColumnManager(), new OpColumnManager(), new ForeignCurrencyColumn(), new CusVoucherSettingColumn(), new MeasureUnitColumnManager(), new ReportCurrencyColumn()).filter(cm -> cm.enable(this.filterInfo)).collect(Collectors.toList());
        }
        return this.cms;
    }

    private void setQueryPeriod() {
        FilterInfo filterInfo = SubLedgerQueryContext.getCurrent().getFilterInfo();
        if (filterInfo.containProp("searchtype") && "2".equals(filterInfo.getString("searchtype"))) {
            this.startDate = filterInfo.getDate("datebegin");
            this.endDate = DateUtil.makeDateOnDayEnd((Date)filterInfo.getDate("dateend"));
            List periods = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("begindate", "<=", (Object)this.startDate), new QFilter("enddate", ">=", (Object)this.startDate), new QFilter("periodtype", "=", (Object)filterInfo.getLong("periodtype"))}, (String)"id asc", (int)1);
            this.startPeriod = periods.size() > 0 ? (Long)periods.get(0) : -1L;
            periods = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("begindate", "<=", (Object)this.endDate), new QFilter("enddate", ">=", (Object)this.endDate), new QFilter("periodtype", "=", (Object)filterInfo.getLong("periodtype"))}, (String)"id desc", (int)1);
            this.endPeriod = periods.size() > 0 ? (Long)periods.get(0) : -1L;
            if (this.startPeriod == -1L || this.endPeriod == -1L) {
                LogFactory.getLog(this.getClass()).warn("got illegal query periods with selected date.");
            }
        } else {
            this.startPeriod = filterInfo.getLong("startperiod");
            this.endPeriod = filterInfo.getLong("endperiod");
            this.startDate = this.getPeriodFromCache(this.startPeriod).getDate("begindate");
            this.endDate = this.getPeriodFromCache(this.endPeriod).getDate("enddate");
        }
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            this.setQueryPeriod();
        }
        return this.startDate;
    }

    public Date getEndDate() {
        if (this.endDate == null) {
            this.setQueryPeriod();
        }
        return this.endDate;
    }

    public Long getStartPeriod(Long currentOrg) {
        if (this.startPeriod == 0L) {
            this.setQueryPeriod();
        }
        Long initPeriod = this.getInitPeriod(currentOrg);
        return this.startPeriod < initPeriod ? initPeriod : this.startPeriod;
    }

    public Long getEndPeriod() {
        if (this.endPeriod == 0L) {
            this.setQueryPeriod();
        }
        return this.endPeriod;
    }

    public Integer getBatchSize() {
        return 1000;
    }

    public Long getBookType() {
        return this.filterInfo.getLong("booktype");
    }

    public Long getAcctTable() {
        return this.filterInfo.getLong("accounttable");
    }

    public ComAssistTable getComAssistTable() {
        return ComAssistTable.get((Long)this.getAcctTable());
    }

    public List<String> getOrderDimensions() {
        LinkedList<String> dimensions = new LinkedList<String>();
        for (SubLedgerColumnManager cm : this.getCms()) {
            cm.addDimensionFields(dimensions);
        }
        dimensions.add("period");
        return dimensions;
    }

    public QueryStateChart getStateChart() {
        return this.stateChart;
    }

    @Override
    public void close() {
        RecyclableRowStorage rowStorage = this.getRowStorage();
        if (rowStorage != null) {
            rowStorage.close();
        }
    }

    public Map<Long, String> getOrgNameCache() {
        if (this.orgNameCache == null) {
            this.orgNameCache = new HashMap<Long, String>(8);
            QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])new QFilter("id", "in", (Object)this.orgIDs).toArray()).forEach(dyo -> this.orgNameCache.put(dyo.getLong("id"), dyo.getString("name")));
        }
        return this.orgNameCache;
    }

    public DynamicObject getCurrencyFromCache(Long pk) {
        return pk <= 0L ? null : (DynamicObject)this.currencyCache.getUnchecked((Object)pk);
    }

    public DynamicObject getUnitFromCache(Long pk) {
        return pk <= 0L ? null : (DynamicObject)this.unitCache.getUnchecked((Object)pk);
    }

    public DynamicObject getVchTypeFromCache(Long pk) {
        return pk <= 0L ? null : (DynamicObject)this.vchTypeCache.getUnchecked((Object)pk);
    }

    public DynamicObject getPeriodFromCache(Long pk) {
        return pk <= 0L ? null : (DynamicObject)this.periodCache.getUnchecked((Object)pk);
    }

    public String getAccountNameFromCache(Long orgID, Long acctMasterID) {
        if (this.id2NumNameDcCache == null) {
            this.initAccountCache();
        }
        Long acctIdOnLevel = (Long)this.getAcctIdAndMidOnLevel((Long)orgID, (Long)acctMasterID).item1;
        return (String)Optional.ofNullable(this.id2NumNameDcCache.get((Object)orgID).get((Object)acctIdOnLevel).item2).orElse("");
    }

    public String getAccountNumberFromCache(Long orgID, Long acctMasterID) {
        if (this.id2NumNameDcCache == null) {
            this.initAccountCache();
        }
        Long acctIdOnLevel = (Long)this.getAcctIdAndMidOnLevel((Long)orgID, (Long)acctMasterID).item1;
        return (String)Optional.ofNullable(this.id2NumNameDcCache.get((Object)orgID).get((Object)acctIdOnLevel).item1).orElse("");
    }

    public String getAccountDcFromCache(Long orgID, Long acctMasterID) {
        if (this.id2NumNameDcCache == null) {
            this.initAccountCache();
        }
        Long acctIdOnLevel = (Long)this.getAcctIdAndMidOnLevel((Long)orgID, (Long)acctMasterID).item1;
        return (String)Optional.ofNullable(this.id2NumNameDcCache.get((Object)orgID).get((Object)acctIdOnLevel).item3).orElse("1");
    }

    public Tuple<Long, Long> getAcctIdAndMidOnLevel(Long orgID, Long acctMasterID) {
        if (this.org2Mid2LevelId == null) {
            FilterInfo filterInfo = this.getFilterInfo();
            int level = filterInfo.getBoolean("showleafaccount") ? Integer.MAX_VALUE : filterInfo.getInt("accountlevel");
            this.org2Mid2LevelId = new AccountLevelTransfer(this.getOrgIDs(), this.getAcctTable(), this.getEndPeriod(), level, new QFilter[0]).getTransferTable();
        }
        Long id = (Long)this.org2Mid2LevelId.get((Object)orgID, (Object)acctMasterID);
        return new Tuple((Object)id, this.accountId2MidTable.get((Object)orgID, (Object)id));
    }

    public Optional<LocalCurrencyConfigVO> getMcConfig() {
        String mulCur = this.getFilterInfo().getString("mulcur");
        if (mulCur != null && !"LocalCurrency".equals(mulCur)) {
            return Optional.of(LocalCurrencyConfigService.getCurrencyConfig((String)mulCur));
        }
        return Optional.empty();
    }

    private void initAccountCache() {
        this.id2NumNameDcCache = new HashMap<Long, Map<Long, ThreeTuple<String, String, String>>>(128);
        this.accountId2MidTable = HashBasedTable.create();
        Arrays.stream(this.orgIDs).forEach(org -> {
            Map id2NumNameMap = this.id2NumNameDcCache.computeIfAbsent((Long)org, k -> new HashMap());
            DynamicObject periodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getEndPeriod(), (String)"bd_period", (String)"begindate, enddate");
            if (periodDyo == null) {
                return;
            }
            QFilter useRangeF = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)org);
            QFilter startPeriodF = new QFilter("startdate", "<=", (Object)periodDyo.getDate("enddate"));
            QFilter endPeriodF = new QFilter("enddate", ">=", (Object)periodDyo.getDate("enddate"));
            QFilter acctTableF = new QFilter("accounttable", "=", ((DynamicObject)this.getFilterInfo().getValue("accounttable")).getPkValue());
            String nameField = GLUtil.getAcctNameBySysParam((Long)org);
            QueryServiceHelper.query((String)(this.getClass() + "#accountCache"), (String)"bd_accountview", (String)"id, masterid, number, name, fullname, dc", (QFilter[])new QFilter[]{useRangeF, startPeriodF, endPeriodF, acctTableF}, null, (int)-1).forEach(accountDyo -> {
                long mid = accountDyo.getLong("masterid");
                long id = accountDyo.getLong("id");
                String number = accountDyo.getString("number");
                id2NumNameMap.put(id, new ThreeTuple((Object)number, (Object)accountDyo.getString(nameField), (Object)accountDyo.getString("dc")));
                this.accountId2MidTable.put(org, (Object)id, (Object)mid);
            });
            this.id2NumNameDcCache.put((Long)org, id2NumNameMap);
        });
    }

    private Long getInitPeriod(Long org) {
        if (this.org2InitPeriodMap == null) {
            this.org2InitPeriodMap = new HashMap<Long, Long>();
            this.org2InitPeriodMap = AccSysUtil.getBookFromAccSys(new HashSet<Long>(Arrays.asList(this.getOrgIDs())), (long)this.getBookType()).stream().collect(Collectors.toMap(AccountBookInfo::getOrgId, AccountBookInfo::getStartPeriodId));
        }
        return this.org2InitPeriodMap.getOrDefault(org, 0L);
    }

    private static LoadingCache<Long, DynamicObject> getDyoLoadingCache(String entityName, String selectFields, long maximumSize) {
        return CacheBuilder.newBuilder().maximumSize(maximumSize).build(SubLedgerQueryContext.getCacheLoader(entityName, selectFields));
    }

    private static CacheLoader<Long, DynamicObject> getCacheLoader(String entityName, String selectFields) {
        return CacheLoader.from(pk -> BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entityName, (String)selectFields));
    }

    public RecyclableRowStorage getRowStorage() {
        return this.rowStorage;
    }

    public Comparator<Object> getStringComparator() {
        return (o1, o2) -> {
            if (o1 == null) {
                return o2 != null ? -1 : 0;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        };
    }

    public String getProperty(String filterKey, String def, String propertyKey) {
        String res = this.filterInfo.getString(filterKey);
        return res != null ? res : BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)propertyKey, (String)def);
    }

    public class QueryStateChart {
        public boolean showQtySummary() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("showsumqty");
        }

        public boolean showQty() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("showqty") || this.showQtySummary();
        }

        public boolean queryForeignCurrency() {
            return !"basecurrency".equals(SubLedgerQueryContext.this.filterInfo.getString("currency"));
        }

        public boolean showReportCurrency() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("showrpt");
        }

        public boolean showOpAccount() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("showopaccount");
        }

        public boolean showDailySummary() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("showdailysum");
        }

        public boolean noZeroSumAmount() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("nodisplayforzeroamount");
        }

        public boolean noZeroAmount() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("nodisplayforzero");
        }

        public boolean showComAssistSummary() {
            return SubLedgerQueryContext.this.filterInfo.getBoolean("showsumcomassist");
        }
    }
}

