/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;

public class SubLedgerRow
extends SettableArrayRow {
    public SubLedgerRow(String rowType) {
        super(SubLedgerQueryContext.getCurrent().getRowMeta(), null, false);
        RowMeta rowMeta = this.getRowMeta();
        super.setValues(SubLedgerQueryContext.getCurrent().getRowStorage().useOne(rowMeta));
        Arrays.stream(rowMeta.getFields()).forEach(field -> {
            DataType dataType = field.getDataType();
            Object defaultValue = null;
            if (dataType == DataType.LongType) {
                defaultValue = 0L;
            } else if (dataType == DataType.BigDecimalType) {
                defaultValue = BigDecimal.ZERO;
            } else if (dataType == DataType.StringType) {
                defaultValue = "";
            } else if (dataType == DataType.IntegerType) {
                defaultValue = 0;
            }
            super.setValue(rowMeta.getFieldIndex(field.getAlias()), defaultValue);
        });
        super.setValue(rowMeta.getFieldIndex("rowtype"), (Object)rowType);
    }

    public SubLedgerRow copy() {
        SubLedgerRow copy = new SubLedgerRow("");
        System.arraycopy(this.values(), 0, copy.values(), 0, this.values().length);
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Field field : this.getRowMeta().getFields()) {
            Object value = this.get(field.getName(), false);
            sb.append(field).append(":").append(value == null ? "null" : value.toString()).append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public boolean isBegin() {
        return this.rowType() == RowType.begin;
    }

    public boolean isLeaf() {
        return this.rowType() == RowType.leaf;
    }

    public boolean isDaily() {
        return this.rowType() == RowType.dailySum;
    }

    public boolean isPeriod() {
        return this.rowType() == RowType.periodSum;
    }

    public boolean isYear() {
        return this.rowType() == RowType.yearSum;
    }

    public RowType rowType() {
        switch (this.getString("rowtype")) {
            case "1": {
                return RowType.begin;
            }
            case "2": {
                return RowType.leaf;
            }
            case "3": {
                return RowType.dailySum;
            }
            case "4": {
                return RowType.periodSum;
            }
            case "5": {
                return RowType.yearSum;
            }
        }
        throw new IllegalStateException(((Object)((Object)this)).getClass().getName());
    }

    public static enum RowType {
        begin,
        leaf,
        dailySum,
        periodSum,
        yearSum;

    }
}

