/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.cms;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.MulCurReportUtil;

public class BaseColumnManager
extends SubLedgerColumnManager {
    private final Map<Long, Long> org2BaseCurrency = new HashMap<Long, Long>(8);
    private final String mulCurType = this.context.getFilterInfo().getString("mulcur");

    private Long getBaseCurrency(Row sourceRow) {
        return this.org2BaseCurrency.computeIfAbsent(sourceRow.getLong("org"), org -> {
            SubLedgerQueryContext context = SubLedgerQueryContext.getCurrent();
            Long bookTypeId = context.getBookType();
            return context.getMcConfig().map(configVO -> configVO.getCurrencyId(org.longValue(), bookTypeId.longValue())).orElseGet(() -> AccSysUtil.getBookFromAccSys((long)org, (long)bookTypeId).getBaseCurrencyId());
        });
    }

    @Override
    public List<Field> getFields() {
        LinkedList<Field> res = new LinkedList<Field>();
        res.add(new Field("org", (DataType)DataType.LongType));
        res.add(new Field("orgname", (DataType)DataType.StringType));
        res.add(new Field("account1", (DataType)DataType.LongType));
        res.add(new Field("accountmasterid", (DataType)DataType.LongType));
        res.add(new Field("accountnumber", (DataType)DataType.StringType));
        res.add(new Field("accountname", (DataType)DataType.StringType));
        res.add(new Field("voucherid", (DataType)DataType.LongType));
        res.add(new Field("voucherno", (DataType)DataType.StringType));
        res.add(new Field("period", (DataType)DataType.LongType));
        res.add(new Field("bizdate", (DataType)DataType.DateType));
        res.add(new Field("bookeddate", (DataType)DataType.DateType));
        res.add(new Field("fentryid", (DataType)DataType.LongType));
        res.add(new Field("desc", (DataType)DataType.StringType));
        res.add(new Field("debitlocal", (DataType)DataType.BigDecimalType));
        res.add(new Field("creditlocal", (DataType)DataType.BigDecimalType));
        res.add(new Field("assgrp", (DataType)DataType.LongType));
        res.add(new Field("dc", (DataType)DataType.StringType));
        res.add(new Field("endlocal", (DataType)DataType.BigDecimalType));
        res.add(new Field("basecurrency", (DataType)DataType.LongType));
        res.add(new Field("detailcount", (DataType)DataType.IntegerType));
        return res;
    }

    @Override
    public void addDimensionFields(List<String> theirs) {
        theirs.add("org");
        theirs.add("accountnumber");
    }

    @Override
    public boolean enable(FilterInfo filterInfo) {
        return true;
    }

    @Override
    public Set<String> getVoucherSelectors() {
        HashSet<String> sel = new HashSet<String>();
        sel.add(String.join((CharSequence)"", "id", " ", "voucherid"));
        sel.add(String.join((CharSequence)"", "org", " ", "org"));
        sel.add(String.join((CharSequence)"", "period", " ", "period"));
        sel.add(String.join((CharSequence)"", "bookeddate", " ", "bookeddate"));
        sel.add(String.join((CharSequence)"", "bizdate", " ", "bizdate"));
        sel.add(String.join((CharSequence)"", "vouchertype", " ", "vouchertype"));
        sel.add(String.join((CharSequence)"", "billno", " ", "billno"));
        sel.add(String.join((CharSequence)"", "entries", ".", "id", " ", "fentryid"));
        sel.add(String.join((CharSequence)"", "entries", ".", "account", " ", "account"));
        sel.add(String.join((CharSequence)"", "entries", ".", "account.number", " ", "accountnumber"));
        sel.add(String.join((CharSequence)"", "entries", ".", "account.masterid", " ", "accountmasterid"));
        sel.add(String.join((CharSequence)"", "entries", ".", "entrydc", " ", "dc"));
        sel.add(String.join((CharSequence)"", "entries", ".", "edescription", " ", "desc"));
        sel.add(String.join((CharSequence)"", "entries", ".", "assgrp", " ", "assgrp"));
        sel.add(MulCurReportUtil.getVoucherLocalAmountFields2((String)this.mulCurType));
        return sel;
    }

    @Override
    protected void fillVoucherRow(Row sourceRow, SubLedgerRow newRowToFill) {
        RowMeta rowMeta = newRowToFill.getRowMeta();
        Long org = sourceRow.getLong("org");
        newRowToFill.setValue(rowMeta.getFieldIndex("org"), org);
        newRowToFill.setValue(rowMeta.getFieldIndex("orgname"), this.context.getOrgNameCache().get(org));
        Long acctMID = sourceRow.getLong("accountmasterid");
        newRowToFill.setValue(rowMeta.getFieldIndex("accountmasterid"), acctMID);
        newRowToFill.setValue(rowMeta.getFieldIndex("accountnumber"), this.context.getAccountNumberFromCache(org, acctMID));
        newRowToFill.setValue(rowMeta.getFieldIndex("accountname"), this.context.getAccountNameFromCache(org, acctMID));
        newRowToFill.setValue(rowMeta.getFieldIndex("account1"), sourceRow.getLong("account"));
        newRowToFill.setValue(rowMeta.getFieldIndex("voucherid"), sourceRow.getLong("voucherid"));
        newRowToFill.setValue(rowMeta.getFieldIndex("voucherno"), this.context.getVchTypeFromCache(sourceRow.getLong("vouchertype")).getString("name") + sourceRow.getString("billno"));
        newRowToFill.setValue(rowMeta.getFieldIndex("period"), sourceRow.getLong("period"));
        newRowToFill.setValue(rowMeta.getFieldIndex("bookeddate"), sourceRow.getDate("bookeddate"));
        newRowToFill.setValue(rowMeta.getFieldIndex("bizdate"), sourceRow.getDate("bizdate"));
        newRowToFill.setValue(rowMeta.getFieldIndex("fentryid"), sourceRow.getLong("fentryid"));
        newRowToFill.setValue(rowMeta.getFieldIndex("desc"), sourceRow.getString("desc"));
        newRowToFill.setValue(rowMeta.getFieldIndex("dc"), sourceRow.getString("dc"));
        newRowToFill.setValue(rowMeta.getFieldIndex("assgrp"), sourceRow.getLong("assgrp"));
        newRowToFill.setValue(rowMeta.getFieldIndex("basecurrency"), this.getBaseCurrency(sourceRow));
        newRowToFill.setValue(rowMeta.getFieldIndex("debitlocal"), sourceRow.getBigDecimal("debitlocal"));
        newRowToFill.setValue(rowMeta.getFieldIndex("creditlocal"), sourceRow.getBigDecimal("creditlocal"));
        newRowToFill.setValue(rowMeta.getFieldIndex("endlocal"), BigDecimal.ZERO);
    }

    @Override
    public Set<String> getBeginBalSelectors() {
        HashSet<String> sel = new HashSet<String>();
        sel.add(String.join((CharSequence)"", "org", " ", "org"));
        sel.add(String.join((CharSequence)"", "account.masterid", " ", "accountmasterid"));
        sel.add(MulCurReportUtil.getSingleBalanceLocalField((String)this.mulCurType, (MCT)MCT.BEGIN, (String)"beginlocal", (String)"beginlocal"));
        return sel;
    }

    @Override
    protected void fillBeginBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        RowMeta rowMeta = newRowToFill.getRowMeta();
        Long org = sourceRow.getLong("org");
        newRowToFill.setValue(rowMeta.getFieldIndex("org"), org);
        newRowToFill.setValue(rowMeta.getFieldIndex("orgname"), this.context.getOrgNameCache().get(org));
        Long acctMID = sourceRow.getLong("accountmasterid");
        newRowToFill.setValue(rowMeta.getFieldIndex("accountmasterid"), acctMID);
        newRowToFill.setValue(rowMeta.getFieldIndex("accountnumber"), this.context.getAccountNumberFromCache(org, acctMID));
        newRowToFill.setValue(rowMeta.getFieldIndex("accountname"), this.context.getAccountNameFromCache(org, acctMID));
        newRowToFill.setValue(rowMeta.getFieldIndex("dc"), this.context.getAccountDcFromCache(org, acctMID));
        Long periodID = sourceRow.getLong("period");
        newRowToFill.setValue(rowMeta.getFieldIndex("period"), periodID);
        newRowToFill.setValue(rowMeta.getFieldIndex("desc"), ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"AbstractSummaryWorker_0", (String)GLApp.instance.reportModule(), (Object[])new Object[0]));
        newRowToFill.setValue(rowMeta.getFieldIndex("basecurrency"), this.getBaseCurrency(sourceRow));
        newRowToFill.setValue(rowMeta.getFieldIndex("debitlocal"), BigDecimal.ZERO);
        newRowToFill.setValue(rowMeta.getFieldIndex("creditlocal"), BigDecimal.ZERO);
        BigDecimal endLocal = ((AbstractRow)sourceRow).getRowMeta().getFieldIndex("voucherid", false) != -1 ? sourceRow.getBigDecimal("debitlocal").subtract(sourceRow.getBigDecimal("creditlocal")) : sourceRow.getBigDecimal("beginlocal");
        newRowToFill.setValue(rowMeta.getFieldIndex("endlocal"), endLocal);
    }

    @Override
    public Set<String> getYearBalSelectors() {
        HashSet<String> sel = new HashSet<String>();
        sel.add(String.join((CharSequence)"", "org", " ", "org"));
        sel.add(String.join((CharSequence)"", "account.masterid", " ", "accountmasterid"));
        sel.add(MulCurReportUtil.getSingleBalanceLocalField((String)this.mulCurType, (MCT)MCT.YEAR_CREDIT, (String)"yearcreditlocal", (String)"yearcreditlocal"));
        sel.add(MulCurReportUtil.getSingleBalanceLocalField((String)this.mulCurType, (MCT)MCT.YEAR_DEBIT, (String)"yeardebitlocal", (String)"yeardebitlocal"));
        sel.add(MulCurReportUtil.getSingleBalanceLocalField((String)this.mulCurType, (MCT)MCT.CREDIT, (String)"creditlocal", (String)"creditlocal"));
        sel.add(MulCurReportUtil.getSingleBalanceLocalField((String)this.mulCurType, (MCT)MCT.DEBIT, (String)"debitlocal", (String)"debitlocal"));
        return sel;
    }

    @Override
    protected void fillYearBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        RowMeta rowMeta = newRowToFill.getRowMeta();
        Long org = sourceRow.getLong("org");
        newRowToFill.setValue(rowMeta.getFieldIndex("org"), org);
        newRowToFill.setValue(rowMeta.getFieldIndex("orgname"), this.context.getOrgNameCache().get(org));
        Long acctMID = sourceRow.getLong("accountmasterid");
        newRowToFill.setValue(rowMeta.getFieldIndex("accountmasterid"), acctMID);
        newRowToFill.setValue(rowMeta.getFieldIndex("accountnumber"), this.context.getAccountNumberFromCache(org, acctMID));
        newRowToFill.setValue(rowMeta.getFieldIndex("accountname"), this.context.getAccountNameFromCache(org, acctMID));
        newRowToFill.setValue(rowMeta.getFieldIndex("dc"), this.context.getAccountDcFromCache(org, acctMID));
        newRowToFill.setValue(rowMeta.getFieldIndex("basecurrency"), this.getBaseCurrency(sourceRow));
        newRowToFill.setValue(rowMeta.getFieldIndex("period"), sourceRow.getLong("period"));
        newRowToFill.setValue(rowMeta.getFieldIndex("debitlocal"), sourceRow.getBigDecimal("yeardebitlocal").subtract(sourceRow.getBigDecimal("debitlocal")));
        newRowToFill.setValue(rowMeta.getFieldIndex("creditlocal"), sourceRow.getBigDecimal("yearcreditlocal").subtract(sourceRow.getBigDecimal("creditlocal")));
    }
}

