/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.source.BaseBuilder;
import kd.fi.gl.util.GLUtil;

public class BalanceSourceBuilder
extends BaseBuilder {
    public BalanceSourceBuilder(Long[] orgs) {
        super(orgs);
    }

    public DataSet beginBalance() {
        SubLedgerQueryContext.getCurrent().timer.time("begin balance begin.");
        Long startPeriod = this.context.getStartPeriod(this.orgs[0]);
        Long endPeriod = this.context.getEndPeriod();
        if (startPeriod > endPeriod) {
            return GLUtil.getEmptyDS(this.getClass());
        }
        DataSet balance = this.getBalance(this.getSelectField(SubLedgerColumnManager::getBeginBalSelectors), startPeriod, endPeriod);
        balance = this.wrapperAccountNumberCompare(balance);
        SubLedgerQueryContext.getCurrent().timer.time("begin balance done.");
        return balance.addField("1", "rowtype").orderBy(this.context.getOrderDimensions().toArray(new String[0]));
    }

    public DataSet yearBalance() {
        SubLedgerQueryContext.getCurrent().timer.time("year balance begin.");
        Long startPeriod = this.context.getStartPeriod(this.orgs[0]);
        Long endPeriod = Math.min(this.context.getEndPeriod(), GLUtil.getCurYearMaxPeriod((long)startPeriod));
        if (startPeriod > endPeriod) {
            return GLUtil.getEmptyDS(this.getClass());
        }
        DataSet balance = this.getBalance(this.getSelectField(SubLedgerColumnManager::getYearBalSelectors), startPeriod, endPeriod);
        balance = this.wrapperAccountNumberCompare(balance);
        SubLedgerQueryContext.getCurrent().timer.time("begin balance done.");
        return balance.addField("5", "rowtype").orderBy(this.context.getOrderDimensions().toArray(new String[0]));
    }

    private DataSet getBalance(String balanceSel, Long startPeriod, Long endPeriod) {
        AccountBookInfo defaultBook;
        long bookTypeId = this.context.getBookType();
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)this.orgs[0])) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        DataSet balance = BalanceQueryExecutor.getInstance().getBalance(balanceSel, this.orgs, bookTypeId, this.context.getAcctTable().longValue(), startPeriod.longValue(), endPeriod.longValue(), this.getBalanceQueryParam(this.filterInfo));
        return balance.addField(this.context.getStartPeriod(this.orgs[0]) + "L", "period");
    }

    private QueryParam getBalanceQueryParam(FilterInfo filterInfo) {
        String currencyVal;
        QueryParam param = new QueryParam();
        param.setSubstractPL(filterInfo.getBoolean("issubstractpl"));
        param.setAccountVersionPeriodId(filterInfo.getLong("endperiod"));
        param.getCustomFilter().addAll(ComAssistTableService.getComAssistFilters((ComAssistTable)this.context.getComAssistTable(), Arrays.asList(this.context.getOrgIDs()), (FilterInfo)filterInfo, key -> key, (String)"masterid"));
        DynamicObjectCollection selectAccts = filterInfo.getDynamicObjectCollection("account");
        if (selectAccts != null && !selectAccts.isEmpty()) {
            Set selectIds = selectAccts.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
            param.setAccountFilter(new QFilter("id", "in", selectIds));
        }
        param.setOnlyLeafAcctBal(true);
        if (filterInfo.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filterInfo.getDynamicObjectCollection("measureunits");
            ArrayList<Long> uList = new ArrayList<Long>(unitsDynColl.size());
            for (DynamicObject dyn : unitsDynColl) {
                uList.add(dyn.getLong("id"));
            }
            param.setMeasureUnitIds(uList.toArray(new Long[0]));
        }
        if (!"basecurrency".equals(currencyVal = filterInfo.getString("currency")) && !"allcurrency".equals(currencyVal)) {
            param.setCurrencyIds(new Long[]{Long.parseLong(filterInfo.getString("currency"))});
        } else if ("basecurrency".equals(currencyVal)) {
            param.setAddAmountFilter(false);
        }
        return param;
    }
}

