/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.source;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.report.subledger.export.BatchDataSet;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.source.BaseBuilder;
import kd.fi.gl.voucher.dimquery.SLDimVchQuery;
import kd.fi.gl.voucher.dimquery.vdf.VchDimFilterService;

public class ExportDimVchQuery
extends SLDimVchQuery<DataSet> {
    private static final String accountNumFK = "accountLevelNum";
    private static final String ACCOUNT_NUM_FK = "entries.account.number";

    public ExportDimVchQuery(FilterInfo filterInfo) {
        super(ExportDimVchQuery.getVDFContext(filterInfo));
    }

    protected static VchDimFilterService.VDFContext getVDFContext(FilterInfo filterInfo) {
        ArrayList<Object> queryDim = new ArrayList<Object>(8);
        queryDim.add(ExportDimVchQuery.VOUCHER.org);
        queryDim.add(ExportDimVchQuery.VOUCHER.account.toInnerProp(ExportDimVchQuery.ACCOUNT.masterID));
        if ("allcurrency".equals(filterInfo.getString("currency"))) {
            queryDim.add(ExportDimVchQuery.VOUCHER.currency);
        }
        if (filterInfo.getBoolean("showsumqty")) {
            queryDim.add(ExportDimVchQuery.VOUCHER.unit);
        }
        queryDim.add(ExportDimVchQuery.VOUCHER.period);
        List dims = queryDim.stream().map(Prop::toFullName).collect(Collectors.toList());
        return VchDimFilterService.VDFContext.createByVch((Long)filterInfo.getLong("accounttable"), dims);
    }

    protected DataSet doVchQueryWithBalDimSummary(DataSet balDimCountDs, final List<QFilter> vchExtFilters, QFilter[] oriFilters, final String selectFields, String allOrderBy, int top) {
        Tuple<DataSet, Integer> tuple = this.reOrderAndGrpByAccountNum(balDimCountDs);
        Integer totalCount = (Integer)tuple.item2;
        if (totalCount < Integer.parseInt(SubLedgerQueryContext.getCurrent().getProperty("bq_threshhold", "100000", "kd.fi.gl.report.subleger.exportAll.batchquery.threshhold"))) {
            return this.doNoBatchQuery(oriFilters, selectFields, allOrderBy);
        }
        List orderBy = Arrays.stream(allOrderBy.split(",")).map(String::trim).collect(Collectors.toList());
        int periodAt = orderBy.indexOf("period");
        final String detailOrderBy = String.join((CharSequence)",", orderBy.subList(periodAt + 1, orderBy.size()));
        final Iterator grpBalItr = ((DataSet)tuple.item1).iterator();
        return new BatchDataSet(new Iterator<DataSet>(){

            @Override
            public boolean hasNext() {
                return grpBalItr.hasNext();
            }

            @Override
            public DataSet next() {
                Row dimCountRow = (Row)grpBalItr.next();
                HashMap<String, Set<Long>> singleDim2Values = new HashMap<String, Set<Long>>();
                ExportDimVchQuery.this.getBalQueryDims().forEach(key -> {
                    HashSet<Long> values = new HashSet<Long>();
                    Object value = dimCountRow.get(key);
                    if (value instanceof String) {
                        JSONArray.parseArray((String)value.toString()).forEach(acctMid -> values.add(Long.parseLong(acctMid.toString())));
                    } else {
                        values.add(Long.parseLong(value.toString()));
                    }
                    singleDim2Values.put((String)key, (Set<Long>)values);
                });
                DataSet vchDs = ExportDimVchQuery.this.doExtVoucherQuery(selectFields + ", entries.account.masterid accountmid", vchExtFilters.toArray(new QFilter[0]), detailOrderBy, -1, singleDim2Values);
                vchDs = vchDs.map((MapFunction)new AccountNumOnLevelMapper(vchDs.getRowMeta(), "accountmid", ExportDimVchQuery.ACCOUNT_NUM_FK)).updateField("accountnumber", ExportDimVchQuery.ACCOUNT_NUM_FK);
                return vchDs;
            }
        });
    }

    private Tuple<DataSet, Integer> reOrderAndGrpByAccountNum(DataSet balDimCountDs) {
        if (!balDimCountDs.hasNext()) {
            return new Tuple((Object)balDimCountDs, (Object)0);
        }
        final DataSet accountNumMapDs = balDimCountDs.map((MapFunction)new AccountNumOnLevelMapper(balDimCountDs.getRowMeta(), "account", accountNumFK));
        String[] grpKeys = (String[])Arrays.stream(accountNumMapDs.getRowMeta().getFields()).map(Field::getName).filter(key -> !key.equalsIgnoreCase("count") && !key.equalsIgnoreCase("account")).toArray(String[]::new);
        int allTotalCount = accountNumMapDs.copy().groupBy().sum("count").finish().next().getInteger("count");
        DataSet result = accountNumMapDs.groupBy(grpKeys).reduceGroup(new ReduceGroupFunction(){
            final RowMeta sourceRowMeta;
            final int accountMidIndex;
            final int countIndex;
            {
                this.sourceRowMeta = accountNumMapDs.getRowMeta();
                this.accountMidIndex = this.sourceRowMeta.getFieldIndex("account");
                this.countIndex = this.sourceRowMeta.getFieldIndex("count");
            }

            public Iterator<Object[]> reduce(Iterator<Row> iterator) {
                if (iterator.hasNext()) {
                    JSONArray mIds = new JSONArray();
                    int totalCount = 0;
                    Object[] resultRow = null;
                    while (iterator.hasNext()) {
                        AbstractRow row = (AbstractRow)iterator.next();
                        Object[] sourceRow = row.values();
                        if (resultRow == null) {
                            resultRow = Arrays.copyOf(sourceRow, sourceRow.length);
                        }
                        mIds.add(sourceRow[this.accountMidIndex]);
                        totalCount += row.getInteger(this.countIndex).intValue();
                    }
                    if (resultRow != null) {
                        resultRow[this.accountMidIndex] = mIds.toJSONString();
                        resultRow[this.countIndex] = totalCount;
                    }
                    return Collections.singletonList(resultRow).iterator();
                }
                return null;
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta((Field[])Arrays.stream(this.sourceRowMeta.getFields()).map(field -> {
                    if (field.getName().equalsIgnoreCase("account")) {
                        return new Field("account", (DataType)DataType.StringType);
                    }
                    return field;
                }).toArray(Field[]::new));
            }
        }).orderBy(grpKeys);
        return new Tuple((Object)result, (Object)allTotalCount);
    }

    protected DataSet doCustomFilterQuery(QFilter[] oriFilters, String selectFields, String orderBy, int top) {
        return this.doNoBatchQuery(oriFilters, selectFields, orderBy);
    }

    private DataSet doNoBatchQuery(QFilter[] oriFilters, String oriSelectFields, String orderBy) {
        HashSet<String> selectFields = new HashSet<String>(Arrays.asList(oriSelectFields.split(",")));
        String[] newOrderBy = (String[])Arrays.stream(orderBy.split(",")).map(String::trim).peek(key -> {
            String[] split;
            if (!ACCOUNT_NUM_FK.equals(key) && (split = key.split(" ")).length > 0) {
                String propKey = split[0];
                selectFields.add(propKey + " " + this.getOrderMask(propKey));
            }
        }).map(item -> {
            if (ACCOUNT_NUM_FK.equals(item)) {
                return item;
            }
            String[] split = item.split(" ");
            if (split.length == 1) {
                return this.getOrderMask(split[0]);
            }
            return this.getOrderMask(split[0]) + " " + split[1];
        }).toArray(String[]::new);
        selectFields.add("entries.account.masterid accountmid");
        DataSet vchDs = VoucherQueryUtils.queryDataSet((String)String.join((CharSequence)",", selectFields), (QFilter[])oriFilters, null, (int)-1);
        return vchDs.map((MapFunction)new AccountNumOnLevelMapper(vchDs.getRowMeta(), "accountmid", ACCOUNT_NUM_FK)).updateField("accountnumber", ACCOUNT_NUM_FK).orderBy(newOrderBy);
    }

    private String getOrderMask(String oriOrderKey) {
        return oriOrderKey + "_o";
    }

    protected DataSet doExtVoucherQuery(String selectFields, QFilter[] extVchFilters, String orderBy, int top, Map<String, Set<Long>> balDimValues) {
        Tuple<String, String[]> tuple = ExportDimVchQuery.mergeSelFieldsAndOrderBy(selectFields, orderBy);
        DataSet set = super.doExtVoucherQuery((String)tuple.item1, extVchFilters, null, top, balDimValues);
        return set.orderBy((String[])tuple.item2);
    }

    protected static Tuple<String, String[]> mergeSelFieldsAndOrderBy(String selFields, String orderBys) {
        HashMap<String, String> field2Alia = new HashMap<String, String>(16);
        for (String selField : selFields.split(",")) {
            String[] aliaSplits = selField.trim().split(" ");
            String field = aliaSplits[0];
            String alia = aliaSplits.length > 1 ? aliaSplits[1] : aliaSplits[0];
            field2Alia.put(field.trim(), alia.trim());
        }
        StringBuilder selFieldBuilder = new StringBuilder(selFields);
        String[] orderBySplits = orderBys.split(",");
        String[] orderByRes = new String[orderBySplits.length];
        for (int i = 0; i < orderBySplits.length; ++i) {
            String orderBy = orderBySplits[i].trim();
            if (field2Alia.containsKey(orderBy)) {
                orderBy = (String)field2Alia.get(orderBy);
            } else {
                selFieldBuilder.append(",").append(orderBy);
            }
            orderByRes[i] = orderBy;
        }
        return new Tuple((Object)selFieldBuilder.toString(), (Object)orderByRes);
    }

    static class AccountNumOnLevelMapper
    extends MapFunction {
        final RowMeta oldRowMeta;
        final RowMeta newRowMeta;
        final SubLedgerQueryContext context = SubLedgerQueryContext.getCurrent();
        final int accountNumIndex;
        final int accountMidIndex;
        final int orgIdIndex;
        final Comparator<Object> acctNumComparator;

        AccountNumOnLevelMapper(RowMeta oldRowMeta, String accountMidFK, String accountNumFK) {
            this.oldRowMeta = oldRowMeta;
            Field[] oriFields = oldRowMeta.getFields();
            Field[] newFields = new Field[oriFields.length + 1];
            int midIndex = oldRowMeta.getFieldIndex(accountMidFK);
            for (int i = 0; i < oriFields.length; ++i) {
                if (i < midIndex) {
                    newFields[i] = oriFields[i];
                    continue;
                }
                if (i == midIndex) {
                    newFields[i] = oriFields[i];
                    newFields[i + 1] = new Field(accountNumFK, (DataType)DataType.StringType);
                    continue;
                }
                newFields[i + 1] = oriFields[i];
            }
            this.newRowMeta = new RowMeta(newFields);
            this.accountNumIndex = this.newRowMeta.getFieldIndex(accountNumFK);
            this.accountMidIndex = oldRowMeta.getFieldIndex(accountMidFK);
            this.orgIdIndex = oldRowMeta.getFieldIndex("org");
            this.acctNumComparator = this.context.getStringComparator();
        }

        public Object[] map(Row row) {
            Object[] values = ((AbstractRow)row).values();
            Object[] result = new Object[values.length + 1];
            for (int i = 0; i < result.length; ++i) {
                if (i < this.accountNumIndex) {
                    result[i] = values[i];
                    continue;
                }
                if (i == this.accountNumIndex) {
                    String levelNum = this.context.getAccountNumberFromCache(row.getLong(this.orgIdIndex), row.getLong(this.accountMidIndex));
                    result[i] = new BaseBuilder.CustomCompareString(Optional.ofNullable(levelNum).orElse(""), this.acctNumComparator);
                    continue;
                }
                result[i] = values[i - 1];
            }
            return result;
        }

        public RowMeta getResultRowMeta() {
            return this.newRowMeta;
        }
    }
}

