/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.QFBuilder;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.source.BaseBuilder;
import kd.fi.gl.report.subledger.export.source.ExportDimVchQuery;

public class VoucherSourceBuilder
extends BaseBuilder {
    protected static final Map<String, String> orderFieldsMap = new HashMap<String, String>(4);
    protected static final Map<String, String> voucherOrderFieldsMap;

    public VoucherSourceBuilder(Long[] orgs) {
        super(orgs);
    }

    public DataSet build() {
        SubLedgerQueryContext.getCurrent().timer.time("voucher begin.");
        String selectField = this.getSelectField(SubLedgerColumnManager::getVoucherSelectors);
        String voucherOrder = this.getVoucherOrder(this.filterInfo);
        QFilter[] vchFilters = this.buildVoucherFilter(this.filterInfo, this.orgs);
        DataSet set = (DataSet)new ExportDimVchQuery(this.context.getFilterInfo()).query(vchFilters, selectField, voucherOrder, -1);
        SubLedgerQueryContext.getCurrent().timer.time("voucher done.");
        return set.addField("2", "rowtype");
    }

    private String getVoucherOrder(FilterInfo filter) {
        StringBuilder orderBy = new StringBuilder();
        String baseDimensionOrderBy = SubLedgerQueryContext.getCurrent().getOrderDimensions().stream().map(key -> orderFieldsMap.getOrDefault(key, "entries." + key)).collect(Collectors.joining(", "));
        orderBy.append(baseDimensionOrderBy);
        List<Tuple> customOrders = ((List)filter.getOtherEntryFilter().get("customsortentry")).stream().map(DynamicObject.class::cast).map(sortRow -> new Tuple((Object)sortRow.getString("fieldcombo"), (Object)sortRow.getString("sortcombo"))).collect(Collectors.toList());
        if (customOrders.isEmpty()) {
            orderBy.append(", bookeddate, vouchertype, billno, entries.seq");
        } else {
            customOrders.forEach(customOrder -> {
                if (voucherOrderFieldsMap.get(customOrder.item1) != null && orderBy.indexOf(voucherOrderFieldsMap.get(customOrder.item1)) == -1) {
                    orderBy.append(", ").append(voucherOrderFieldsMap.get(customOrder.item1)).append(" ");
                    if ("dc".equals(customOrder.item1)) {
                        orderBy.append("desc");
                    } else {
                        orderBy.append((String)customOrder.item2);
                    }
                } else if (orderBy.indexOf((String)customOrder.item1) == -1) {
                    orderBy.append(", ").append((String)customOrder.item1).append(" ");
                    if ("entries.entrydc".equals(customOrder.item1)) {
                        orderBy.append("desc");
                    } else {
                        orderBy.append((String)customOrder.item2);
                    }
                }
            });
        }
        return orderBy.toString();
    }

    protected QFilter[] buildVoucherFilter(FilterInfo filter, Long[] orgs) {
        QFilter acctF;
        QueryParamRpt qpRpt = new QueryParamRpt(filter);
        qpRpt.setShowAssist(true);
        ArrayList<QFilter> list = new ArrayList<QFilter>(8);
        list.add(new QFilter("org", "in", (Object)orgs));
        list.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        list.addAll(ComAssistTableService.getComAssistFilters((ComAssistTable)this.context.getComAssistTable(), Arrays.asList(SubLedgerQueryContext.getCurrent().getOrgIDs()), (FilterInfo)this.filterInfo, key -> "entries." + key, (String)"id"));
        int searchType = qpRpt.getSearchType();
        Date endDate = this.context.getEndDate();
        if (searchType == 2) {
            Date startDate = this.context.getStartDate();
            QFBuilder periodFilterBuilder = new QFBuilder("periodtype", "=", (Object)qpRpt.getPeriodType());
            periodFilterBuilder.add("begindate", "<=", (Object)endDate);
            periodFilterBuilder.add("enddate", ">=", (Object)startDate);
            List periodPkValueList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])periodFilterBuilder.toArray(), null, (int)-1).stream().map(x -> (Long)x).collect(Collectors.toList());
            if (!periodPkValueList.isEmpty()) {
                list.add(new QFilter("period", "in", periodPkValueList));
                qpRpt.setStartPeriod(((Long)Collections.min(periodPkValueList)).longValue());
                qpRpt.setEndPeriod(((Long)Collections.max(periodPkValueList)).longValue());
            }
            list.add(new QFilter("bookeddate", "<=", (Object)endDate));
            list.add(new QFilter("bookeddate", ">=", (Object)startDate));
        } else {
            list.add(new QFilter("period", ">=", (Object)qpRpt.getStartPeriod()));
            list.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        }
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        if (qpRpt.isSubstractPL()) {
            list.add(new QFilter("sourcetype", "!=", (Object)"1"));
        }
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            list.add(new QFilter("entries.currency", "=", (Object)qpRpt.getCurrency()));
        }
        if ((acctF = this.getAcctF(filter, qpRpt, PeriodService.getEndDate((long)qpRpt.getEndPeriod()))) != null) {
            list.add(acctF);
        }
        Optional.ofNullable(filter.getCommFilter("gl_voucher")).ifPresent(list::add);
        return list.toArray(new QFilter[0]);
    }

    QFilter getAcctF(FilterInfo filter, QueryParamRpt qpRpt, Date endDate) {
        Set selectedChildMids = ReportUtils.getSelectedLeafChildMids((FilterInfo)filter, Arrays.asList(this.orgs), (long)qpRpt.getAccountTable(), (Date)endDate);
        List acctIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter("masterid", "in", (Object)selectedChildMids).toArray(), null, (int)-1);
        return new QFilter("entries.account", "in", (Object)acctIds);
    }

    static {
        orderFieldsMap.put("org", "org");
        orderFieldsMap.put("accountnumber", "entries.account.number");
        orderFieldsMap.put("currency", "entries.currency");
        orderFieldsMap.put("measureunit", "entries.measureunit");
        orderFieldsMap.put("period", "period");
        voucherOrderFieldsMap = new HashMap<String, String>(8);
        voucherOrderFieldsMap.put("bookdate", "bookeddate");
        voucherOrderFieldsMap.put("bizdate", "bizdate");
        voucherOrderFieldsMap.put("typenumber", "vouchertype");
        voucherOrderFieldsMap.put("billno", "billno");
        voucherOrderFieldsMap.put("dc", "entries.entrydc");
    }
}

