/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.worker;

import java.util.Collections;
import java.util.List;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.logging.LogFactory;
import kd.fi.gl.report.export.processor.IBatchTransformer;
import kd.fi.gl.report.subledger.export.ISummaryWorker;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.worker.AbstractWorker;

public abstract class AbstractSummaryWorker<T1 extends T2, T2>
extends AbstractWorker<T1, T2>
implements ISummaryWorker<T1, T2> {
    private T1 current;
    private final int maxOutSize = Integer.parseInt(System.getProperty("fi.gl.export.subledger.summarywoker.maxsize", "200000"));

    @Override
    protected List<T2> process(List<T2> batchEntries) {
        List<T2> res = super.process(batchEntries);
        batchEntries.forEach(nextGoods -> {
            if (this.current == null) {
                this.setCurrent(this.createNextProduct(this.current, nextGoods));
            }
            while (this.needOutputCurrent(this.current, nextGoods)) {
                if (res.size() > this.maxOutSize) {
                    LogFactory.getLog(this.getClass()).warn("break on max size.");
                    break;
                }
                this.beforeOutputCurrentProduct(this.current);
                res.add(this.current);
                this.setCurrent(this.createNextProduct(this.current, nextGoods));
            }
            if (this.needConsumeNext(this.current, nextGoods)) {
                this.consumeGoods(this.current, nextGoods);
            }
            if (!this.needThrowNextGoods(nextGoods)) {
                res.add(nextGoods);
            } else {
                SubLedgerQueryContext.getCurrent().getRowStorage().recycleOne((AbstractRow)nextGoods);
            }
        });
        return res;
    }

    @Override
    public boolean needOutputCurrent(T1 currentProduct, T2 nextGoods) {
        return currentProduct != null;
    }

    @Override
    public boolean needConsumeNext(T1 currentProduct, T2 nextGoods) {
        return currentProduct != null;
    }

    @Override
    public boolean needThrowNextGoods(T2 goods) {
        return false;
    }

    protected List<T2> outputWhenFinished() {
        if (this.current != null) {
            this.beforeOutputCurrentProduct(this.current);
            return Collections.singletonList(this.current);
        }
        return Collections.emptyList();
    }

    protected void beforeOutputCurrentProduct(T1 current) {
    }

    private void setCurrent(T1 current) {
        this.current = current;
        if (current != null) {
            this.logger.info(String.format("%s move to next current [%s].", this.getClass().getSimpleName(), current));
        }
    }

    public T1 getCurrent() {
        return this.current;
    }

    protected void beforeNextProcessorFireFinished() {
        super.beforeNextProcessorFireFinished();
        IBatchTransformer nextProcessor = this.getNextProcessor();
        List<T2> products = this.outputWhenFinished();
        nextProcessor.work(products);
    }
}

