/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.worker;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.worker.SubLedgerSummaryWorker;

public class BalanceAccumulator
extends SubLedgerSummaryWorker {
    private int accountDC;
    private boolean notShowByAccountDC;
    private long preOrg = 0L;
    private BigDecimal endLocal = BigDecimal.ZERO;
    private BigDecimal endFor = BigDecimal.ZERO;
    private BigDecimal endQty = BigDecimal.ZERO;
    private BigDecimal endPrice = BigDecimal.ZERO;

    @Override
    public SubLedgerRow createNextProduct(SubLedgerRow preSumProduct, SubLedgerRow nextGoods) {
        return null;
    }

    @Override
    public void consumeGoods(SubLedgerRow ignored, SubLedgerRow goods) {
        String rowType;
        switch (rowType = goods.getString("rowtype")) {
            case "1": {
                this.endLocal = BigDecimal.ZERO;
                this.endFor = BigDecimal.ZERO;
                this.endQty = BigDecimal.ZERO;
                this.endPrice = BigDecimal.ZERO;
                long curOrg = goods.getLong("org");
                long acctMID = goods.getLong("accountmasterid");
                if (curOrg != this.preOrg) {
                    this.preOrg = curOrg;
                    this.notShowByAccountDC = BalanceAccumulator.getShowByActDCSysParam(curOrg) == false;
                }
                this.accountDC = Integer.parseInt(this.context.getAccountDcFromCache(curOrg, acctMID));
                this.endLocal = goods.getBigDecimal("endlocal").multiply(new BigDecimal(this.accountDC));
                if (this.debitForIndex != -1 && this.creditForIndex != -1) {
                    this.endFor = goods.getBigDecimal("endfor").multiply(new BigDecimal(this.accountDC));
                }
                if (this.isShowQty) {
                    this.endQty = Optional.ofNullable(goods.getBigDecimal("endqty")).orElse(BigDecimal.ZERO);
                }
                this.updateBalanceExtFields(goods);
                break;
            }
            case "2": {
                String entryDC = goods.getString("dc");
                if (this.debitForIndex != -1 && this.creditForIndex != -1) {
                    BigDecimal amountFor = goods.getBigDecimal("1".equals(entryDC) ? "debitfor" : "creditfor");
                    this.endFor = this.endFor.add(amountFor.multiply(BigDecimal.valueOf((long)this.accountDC * (long)Integer.parseInt(entryDC))));
                }
                BigDecimal amountLocal = goods.getBigDecimal("1".equals(entryDC) ? "debitlocal" : "creditlocal");
                this.endLocal = this.endLocal.add(amountLocal.multiply(BigDecimal.valueOf((long)this.accountDC * (long)Integer.parseInt(entryDC))));
                if (this.isShowQty) {
                    BigDecimal qty = goods.getBigDecimal("1".equals(entryDC) ? "debitqty" : "creditqty");
                    this.endQty = this.endQty.add(qty.multiply(BigDecimal.valueOf((long)this.accountDC * (long)Integer.parseInt(entryDC))));
                }
                this.updateBalanceExtFields(goods);
                break;
            }
            case "3": 
            case "4": 
            case "5": {
                break;
            }
        }
        this.setCurrentBalance(goods);
    }

    private void updateBalanceExtFields(SubLedgerRow goods) {
        DynamicObject unit;
        if (this.isShowQty && (unit = this.context.getUnitFromCache(goods.getLong("measureunit"))) != null) {
            int precision = unit.getInt("precision");
            int precisionAccount = Integer.parseInt(unit.getString("precisionaccount"));
            this.endPrice = this.debitForIndex != -1 && this.creditForIndex != -1 ? (this.endQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.endFor.divide(this.endQty, precision, precisionAccount)) : (this.endQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.endLocal.divide(this.endQty, precision, precisionAccount));
        }
    }

    private void setCurrentBalance(SubLedgerRow goods) {
        int balanceDC = BigDecimal.ZERO.compareTo(this.endLocal) == 0 ? 0 : this.accountDC;
        BigDecimal endLocal = this.endLocal;
        BigDecimal endFor = this.endFor;
        BigDecimal endQty = this.endQty;
        if (this.notShowByAccountDC) {
            balanceDC = this.accountDC * endLocal.compareTo(BigDecimal.ZERO);
            endLocal = endLocal.abs();
            endFor = endFor.abs();
            endQty = endQty.abs();
        }
        goods.setValue(this.dcIndex, balanceDC);
        goods.setValue(this.endLocalIndex, endLocal);
        if (this.debitForIndex != -1 && this.creditForIndex != -1) {
            goods.setValue(this.endForIndex, endFor);
        }
        if (this.isShowQtySum) {
            goods.setValue(this.endQtyIndex, endQty);
            goods.setValue(this.endPriceIndex, this.endPrice);
        }
    }

    private static Boolean getShowByActDCSysParam(Long curOrgId) {
        AppParam param = new AppParam("83bfebc8000017ac", "10", curOrgId, Long.valueOf(0L));
        Boolean bIsShowByAccountDC = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"showbyaccountdc");
        bIsShowByAccountDC = bIsShowByAccountDC == null ? Boolean.FALSE : bIsShowByAccountDC;
        return bIsShowByAccountDC;
    }

    @Override
    public boolean needConsumeNext(SubLedgerRow currentProduct, SubLedgerRow nextGoods) {
        return true;
    }
}

