/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.batch;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.batchquery.IBatchService;
import kd.fi.gl.report.subsidiary.v2.SelectObjectUtil;
import kd.fi.gl.report.subsidiary.v2.batch.BatchUtil;
import kd.fi.gl.report.subsidiary.v2.batch.SubsiBatchRow;
import kd.fi.gl.report.subsidiary.v2.batch.SubsiDiaryBatchServiceFactory;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.SubsiDiaryHelper;

public class DefaultBatchFactory
extends SubsiDiaryBatchServiceFactory {
    static final String KEY_ACCOUNT_MID = "account";
    static final String KEY_COUNT = "count";
    public static final String KEY_IS_TOTAL = "isTotal";

    @Override
    public IBatchService<SubsiBatchRow> getBatchService(ReportQueryParam queryParam) {
        boolean needBatch;
        boolean exportAll = SubsiDiaryHelper.isExportAll((FilterInfo)queryParam.getFilter());
        List assistValues = SelectObjectUtil.getAssistValues((ReportQueryParam)queryParam);
        if (assistValues == null) {
            return param -> Collections.emptyList();
        }
        int totalCount = BatchUtil.queryTotalCount(assistValues, queryParam, exportAll);
        boolean existVchCustomFilter = queryParam.getFilter().getCommFilter("gl_voucher") != null;
        boolean hideZeroBalance = queryParam.getFilter().getBoolean("balancezero");
        boolean bl = needBatch = !existVchCustomFilter && !hideZeroBalance && totalCount > ReportConfiguration.SUBSIDIARY_BATCH_THRESHOLD.getInt();
        if (needBatch) {
            return exportAll ? new MultiBatchByAccountAndAssist() : new MultiBatchByAccount();
        }
        return new SingleBatchService();
    }

    static final class CountLimitFunction
    extends FilterFunction {
        private static final long serialVersionUID = -465716302293101205L;
        private final int limit;
        private int sum = 0;

        CountLimitFunction(int limit) {
            this.limit = limit;
        }

        public boolean test(Row row) {
            if (this.sum < this.limit) {
                this.sum += row.getInteger(DefaultBatchFactory.KEY_COUNT).intValue();
                return true;
            }
            return false;
        }
    }

    public static class MultiBatchByAccountAndAssist
    implements IBatchService<SubsiBatchRow> {
        @Override
        public List<SubsiBatchRow> queryBatches(ReportQueryParam queryParam) {
            List assistFilters = SelectObjectUtil.getAssistValues((ReportQueryParam)queryParam);
            DataSet batchDs = BatchUtil.queryBatchAndCount(FlexUtils.buildAssistFilterInfo((ReportQueryParam)queryParam), queryParam, true);
            batchDs = BatchUtil.order(queryParam, batchDs);
            batchDs = BatchUtil.insertTotalRow(batchDs);
            batchDs = batchDs.filter((FilterFunction)new CountLimitFunction(ReportConfiguration.SUBSIDIARY_EXPORT_LIMIT.getInt()));
            ArrayList<SubsiBatchRow> res = new ArrayList<SubsiBatchRow>(32);
            for (Row batch : batchDs) {
                List<FlexUtils.AssistFilterEntry> curFilters = assistFilters.stream().map(assistFilter -> {
                    String flexField = assistFilter.getProperty();
                    Object val = batch.get(flexField);
                    if (val == null) {
                        val = assistFilter.isManualAssist() ? "" : Long.valueOf(0L);
                    }
                    return new FlexUtils.AssistFilterEntry(flexField, (Set)Sets.newHashSet((Object[])new Object[]{val}), assistFilter.getFlexProperty());
                }).collect(Collectors.toList());
                if (batch.getBoolean(DefaultBatchFactory.KEY_IS_TOTAL).booleanValue()) {
                    res.add(SubsiBatchRow.createTotalBatchRow(curFilters));
                    continue;
                }
                res.add(SubsiBatchRow.createCommonBatchRow(curFilters, batch.getLong(DefaultBatchFactory.KEY_ACCOUNT_MID), batch.getInteger(DefaultBatchFactory.KEY_COUNT)));
            }
            return res;
        }
    }

    public static class MultiBatchByAccount
    implements IBatchService<SubsiBatchRow> {
        @Override
        public List<SubsiBatchRow> queryBatches(ReportQueryParam queryParam) {
            List assistFilters = SelectObjectUtil.getAssistValues((ReportQueryParam)queryParam);
            DataSet batchDs = BatchUtil.queryBatchAndCount(assistFilters, queryParam, false);
            batchDs = BatchUtil.order(queryParam, batchDs);
            batchDs = batchDs.filter((FilterFunction)new CountLimitFunction(ReportConfiguration.SUBSIDIARY_DISPLAY_LIMIT.getInt()));
            ArrayList<SubsiBatchRow> res = new ArrayList<SubsiBatchRow>(32);
            for (Row batch : batchDs) {
                res.add(SubsiBatchRow.createCommonBatchRow(assistFilters, batch.getLong(DefaultBatchFactory.KEY_ACCOUNT_MID), batch.getInteger(DefaultBatchFactory.KEY_COUNT)));
            }
            res.add(SubsiBatchRow.createTotalBatchRow(assistFilters));
            return res;
        }
    }

    public static class SingleBatchService
    implements IBatchService<SubsiBatchRow> {
        @Override
        public List<SubsiBatchRow> queryBatches(ReportQueryParam queryParam) {
            return Collections.singletonList(SubsiBatchRow.createSingleBatchRow(SelectObjectUtil.getAssistValues((ReportQueryParam)queryParam)));
        }
    }
}

