/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core;

import java.math.BigDecimal;
import java.util.function.Function;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.gl.report.subsidiary.v2.core.model.IRptRow;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;

public class BalanceAccumulator {
    private int accountDC;
    private final boolean notShowByAccountDC;
    private BigDecimal endLocal = BigDecimal.ZERO;
    private BigDecimal endFor = BigDecimal.ZERO;
    private BigDecimal endQty = BigDecimal.ZERO;
    private final Function<IRptRow, Integer> dcExtractor;

    public BalanceAccumulator(long orgId, Function<IRptRow, Integer> dcExtractor) {
        this.dcExtractor = dcExtractor;
        this.notShowByAccountDC = BalanceAccumulator.getShowByActDCSysParam(orgId) == false;
    }

    public void sumAndSetBalanceFields(IRptRow row) {
        RowType rowType = row.getRowType();
        switch (rowType) {
            case BEGIN: {
                this.endLocal = BigDecimal.ZERO;
                this.endFor = BigDecimal.ZERO;
                this.endQty = BigDecimal.ZERO;
                this.accountDC = this.dcExtractor.apply(row);
                this.endLocal = row.getEndLocal().multiply(new BigDecimal(this.accountDC));
                if (row.isQueryCurrency()) {
                    this.endFor = row.getEndFor().multiply(new BigDecimal(this.accountDC));
                }
                if (!row.isQueryMeasureUnit()) break;
                this.endQty = row.getEndQty();
                break;
            }
            case LEAF: {
                String entryDC = row.getEndDC().toString();
                if (row.isQueryCurrency()) {
                    BigDecimal amountFor = "1".equals(entryDC) ? row.getDebitFor() : row.getCreditFor();
                    this.endFor = this.endFor.add(amountFor.multiply(BigDecimal.valueOf((long)this.accountDC * (long)Integer.parseInt(entryDC))));
                }
                BigDecimal amountLocal = "1".equals(entryDC) ? row.getDebitLocal() : row.getCreditLocal();
                this.endLocal = this.endLocal.add(amountLocal.multiply(BigDecimal.valueOf((long)this.accountDC * (long)Integer.parseInt(entryDC))));
                if (!row.isQueryMeasureUnit()) break;
                BigDecimal qty = "1".equals(entryDC) ? row.getDebitQty() : row.getCreditQty();
                this.endQty = this.endQty.add(qty.multiply(BigDecimal.valueOf((long)this.accountDC * (long)Integer.parseInt(entryDC))));
                break;
            }
            case PERIOD: 
            case YEAR: {
                break;
            }
            case TOTAL: {
                return;
            }
        }
        this.setCurrentBalance(row);
    }

    private void setCurrentBalance(IRptRow row) {
        boolean queryCurr = row.isQueryCurrency();
        int balanceDC = BigDecimal.ZERO.compareTo(this.endLocal) == 0 ? 0 : this.accountDC;
        BigDecimal endLocal = this.endLocal;
        BigDecimal endFor = this.endFor;
        BigDecimal endQty = this.endQty;
        if (this.notShowByAccountDC) {
            boolean needAdjust;
            boolean bl = needAdjust = (queryCurr ? endFor : endLocal).signum() < 0;
            if (needAdjust) {
                balanceDC = -balanceDC;
                endLocal = endLocal.negate();
                endFor = endFor.negate();
                endQty = endQty.negate();
            }
        }
        row.setEndDC(balanceDC);
        row.setEndLocal(endLocal);
        if (queryCurr) {
            row.setEndFor(endFor);
        }
        if (row.isQueryMeasureUnit()) {
            row.setEndQty(endQty);
        }
    }

    private static Boolean getShowByActDCSysParam(Long curOrgId) {
        AppParam param = new AppParam("83bfebc8000017ac", "10", curOrgId, Long.valueOf(0L));
        Boolean bIsShowByAccountDC = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"showbyaccountdc");
        bIsShowByAccountDC = bIsShowByAccountDC == null ? Boolean.FALSE : bIsShowByAccountDC;
        return bIsShowByAccountDC;
    }
}

