/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.collector.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryRowFactory;
import kd.fi.gl.report.subsidiary.v2.core.collector.AbstractReportCollector;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;

public class SubsidiaryBeginCollector
extends AbstractReportCollector<SubsidiaryRow> {
    private final Map<SubsidiaryGroup, SubsidiaryRow> grp2Begin = new HashMap<SubsidiaryGroup, SubsidiaryRow>(8);

    @Override
    public List<RowType> getSourceTypes() {
        return Collections.singletonList(RowType.BEGIN);
    }

    @Override
    public void collectSourceRow(SubsidiaryRow row) {
        if (row.getRowType() == RowType.BEGIN) {
            if (this.grp2Begin.containsKey(row.getGroup())) {
                SubsidiaryRow beginSumRow = this.grp2Begin.get(row.getGroup());
                beginSumRow.setEndLocal(beginSumRow.getEndLocal().add(row.getEndLocal()));
                beginSumRow.setEndFor(beginSumRow.getEndFor().add(row.getEndFor()));
                beginSumRow.setEndQty(beginSumRow.getEndQty().add(row.getEndQty()));
            } else {
                this.grp2Begin.put(row.getGroup(), row);
            }
        }
    }

    @Override
    public void collectSummaryRow(SubsidiaryRow row) {
        if (row.getRowType() == RowType.PERIOD) {
            this.grp2Begin.computeIfAbsent(row.getGroup(), grp -> SubsidiaryRowFactory.createBeginRowWithZeroAmount(row));
        }
    }

    @Override
    public List<SubsidiaryRow> getSummaryRows() {
        return new ArrayList<SubsidiaryRow>(this.grp2Begin.values());
    }
}

