/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.collector.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.gl.report.subsidiary.v2.batch.SubsiBatchRow;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryContext;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryRowFactory;
import kd.fi.gl.report.subsidiary.v2.core.collector.AbstractReportCollector;
import kd.fi.gl.report.subsidiary.v2.core.model.AssistValueGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;

public class SubsidiaryPeriodTotalCollector
extends AbstractReportCollector<SubsidiaryRow> {
    private final SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
    private final SubsiBatchRow batchRow = this.context.getBatchRow();
    private final Map<AssistValueGroup, SubsidiaryRow> totalRowMap;

    public SubsidiaryPeriodTotalCollector() {
        String totalRowMapStr = this.context.get(this.getTotalRowCacheKey());
        this.totalRowMap = totalRowMapStr != null ? (Map<Object, Object>)SerializationUtils.deSerializeFromBase64((String)totalRowMapStr) : new HashMap<AssistValueGroup, SubsidiaryRow>(128);
    }

    @Override
    public List<RowType> getSourceTypes() {
        return Arrays.asList(RowType.BEGIN, RowType.TOTAL);
    }

    @Override
    public void collectSourceRow(SubsidiaryRow row) {
        SubsidiaryRow totalRow = this.getOrCreateTotalRow(row);
        if (row.getRowType() == RowType.BEGIN) {
            totalRow.setEndLocal(totalRow.getEndLocal().add(row.getEndLocal()));
        } else if (row.getRowType() == RowType.TOTAL) {
            totalRow.setCount(totalRow.getCount() + 1);
            totalRow.setDebitLocal(totalRow.getDebitLocal().add(row.getDebitLocal()));
            totalRow.setCreditLocal(totalRow.getCreditLocal().add(row.getCreditLocal()));
        }
    }

    @Override
    public void collectSummaryRow(SubsidiaryRow periodRow) {
        SubsidiaryRow totalRow = this.getOrCreateTotalRow(periodRow);
        if (this.batchRow.isSingleBatchRow() && periodRow.getRowType() == RowType.PERIOD) {
            totalRow.setCount(totalRow.getCount() + periodRow.getCount());
            totalRow.setDebitLocal(totalRow.getDebitLocal().add(periodRow.getDebitLocal()));
            totalRow.setCreditLocal(totalRow.getCreditLocal().add(periodRow.getCreditLocal()));
        }
    }

    SubsidiaryRow getOrCreateTotalRow(SubsidiaryRow sourceRow) {
        AssistValueGroup assistValueGroup = sourceRow.getGroup().getAssistValueGroup();
        return this.totalRowMap.computeIfAbsent(assistValueGroup, k -> SubsidiaryRowFactory.createTotalRow(assistValueGroup, BigDecimal.ZERO, BigDecimal.ZERO));
    }

    @Override
    public List<SubsidiaryRow> getSummaryRows() {
        List<SubsidiaryRow> result = Collections.emptyList();
        if (this.batchRow.isSingleBatchRow() || this.batchRow.isTotalBatch()) {
            result = this.totalRowMap.values().stream().peek(totalRow -> {
                BigDecimal endLocal = totalRow.getDebitLocal().subtract(totalRow.getCreditLocal()).add(totalRow.getEndLocal());
                totalRow.setEndDC(endLocal.compareTo(BigDecimal.ZERO));
                totalRow.setEndLocal(endLocal.abs());
            }).collect(Collectors.toList());
            this.totalRowMap.clear();
        }
        this.context.cache(this.getTotalRowCacheKey(), SerializationUtils.serializeToBase64(this.totalRowMap));
        return result;
    }

    public final String getTotalRowCacheKey() {
        return "totalRowMapStr";
    }
}

