/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.collector.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryRowFactory;
import kd.fi.gl.report.subsidiary.v2.core.collector.AbstractReportCollector;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;

public class SubsidiaryYearCollector
extends AbstractReportCollector<SubsidiaryRow> {
    private final Map<SubsidiaryGroup, List<SubsidiaryRow>> sumRowTreeMap = new HashMap<SubsidiaryGroup, List<SubsidiaryRow>>();

    @Override
    public List<RowType> getSourceTypes() {
        return Collections.singletonList(RowType.YEAR);
    }

    @Override
    public void collectSourceRow(SubsidiaryRow totalRow) {
        List singleGrpRows = this.sumRowTreeMap.computeIfAbsent(totalRow.getGroup(), group -> new ArrayList(8));
        singleGrpRows.add(totalRow);
    }

    @Override
    public void collectSummaryRow(SubsidiaryRow periodRow) {
        List singleGrpRows = this.sumRowTreeMap.computeIfAbsent(periodRow.getGroup(), group -> new ArrayList(8));
        SubsidiaryRow sumRow = SubsidiaryRowFactory.createYearRowWithZeroAmount(periodRow);
        baseDCSumConsumer.accept(periodRow, sumRow);
        sumRow.setCount(sumRow.getCount() + periodRow.getCount());
        singleGrpRows.add(sumRow);
    }

    @Override
    public List<SubsidiaryRow> getSummaryRows() {
        ArrayList<SubsidiaryRow> res = new ArrayList<SubsidiaryRow>(this.sumRowTreeMap.size());
        for (List<SubsidiaryRow> singleGrpRows : this.sumRowTreeMap.values()) {
            if (singleGrpRows.size() > 1) {
                singleGrpRows.sort(Comparator.comparingLong(SubsidiaryRow::getPeriodId));
                for (int cur = 1; cur < singleGrpRows.size(); ++cur) {
                    SubsidiaryRow preRow = singleGrpRows.get(cur - 1);
                    SubsidiaryRow curRow = singleGrpRows.get(cur);
                    long preRowYear = PeriodUtil.getYear((long)preRow.getPeriodId());
                    long curRowYear = PeriodUtil.getYear((long)curRow.getPeriodId());
                    if (preRowYear != 0L && preRowYear != curRowYear) continue;
                    baseDCSumConsumer.accept(preRow, curRow);
                }
            }
            singleGrpRows.removeIf(r -> r.getPeriodId() == 0L);
            res.addAll(singleGrpRows);
        }
        return res;
    }
}

