/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.ds.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryContext;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryRowFactory;
import kd.fi.gl.report.subsidiary.v2.core.ds.impl.SubsidiaryVoucherDS;
import kd.fi.gl.report.subsidiary.v2.core.model.AssistValueGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

public class SubsidiaryPeriodTotalDS
extends SubsidiaryVoucherDS {
    private static final String CREDIT_SUM = "creditLocal";
    private static final String DEBIT_SUM = "debitLocal";

    @Override
    public Iterable<SubsidiaryRow> getData() {
        SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
        List<QFilter> filters = this.getBaseFilters(context);
        List<FlexUtils.AssistFilterEntry> assistEntries = context.getAssistEntries();
        Triple triple = FlexUtils.buildDynamicORMAssistOnVoucherWithZero(assistEntries, (boolean)true);
        filters.addAll((Collection)triple.getMiddle());
        String[] assistFields = (String[])((List)triple.getRight()).stream().map(x -> x.split(" ")[0]).toArray(String[]::new);
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)triple.getLeft());
        VoucherSchema voucherSchema = VoucherSchema.instance;
        String creditSum = String.format("sum(%s) %s", voucherSchema.creditLocal.toFullName(), CREDIT_SUM);
        String debitSum = String.format("sum(%s) %s", voucherSchema.debitLocal.toFullName(), DEBIT_SUM);
        DataSet ds = orm.aggregate("SubsidiaryPeriodTotalDS#getData", "gl_voucher", new String[]{creditSum, debitSum}, filters.toArray(new QFilter[0]), assistFields);
        List assistAlias = (List)triple.getRight();
        assistAlias.add(CREDIT_SUM);
        assistAlias.add(DEBIT_SUM);
        ds = ds.select(assistAlias.toArray(new String[0]));
        ArrayList<SubsidiaryRow> sourceRows = new ArrayList<SubsidiaryRow>();
        ds.forEach(row -> {
            BigDecimal creditLocalTotal = row.getBigDecimal(CREDIT_SUM);
            BigDecimal debitLocalTotal = row.getBigDecimal(DEBIT_SUM);
            AssistValueGroup assistValueGroup = AssistValueGroup.create(assistEntries, row, context.isExportAll());
            sourceRows.add(SubsidiaryRowFactory.createTotalRow(assistValueGroup, creditLocalTotal, debitLocalTotal));
        });
        return sourceRows;
    }
}

