/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.handler.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.subsidiary.v2.core.BalanceAccumulator;
import kd.fi.gl.report.subsidiary.v2.core.ResultField;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryContext;
import kd.fi.gl.report.subsidiary.v2.core.handler.IReportQueryHandler;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;

public class SubsidiaryQueryHandler
implements IReportQueryHandler<SubsidiaryRow> {
    private static final Log LOG = LogFactory.getLog(SubsidiaryQueryHandler.class);
    private final SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
    private final BalanceAccumulator balanceAccumulator = new BalanceAccumulator(this.context.getOrgId(), iRptRow -> {
        long acctMID = iRptRow.getAccountMasterId();
        return Integer.parseInt(this.context.getAccountDcFromCache(acctMID));
    });
    private static final String SUBTRACT_ROW_CACHE_KEY = "subtractRow";

    @Override
    public List<SubsidiaryRow> fireFinished(List<SubsidiaryRow> subsidiaryRows) {
        subsidiaryRows.forEach(this.balanceAccumulator::sumAndSetBalanceFields);
        boolean selNoZeroBalance = this.context.getQueryParam().isNoZeroBalance();
        boolean selNoZeroAmount = this.context.getQueryParam().isNoZeroAmount();
        if (selNoZeroBalance || selNoZeroAmount) {
            subsidiaryRows = this.filterZeroBalOrAmt(subsidiaryRows, selNoZeroBalance, selNoZeroAmount);
        }
        if (this.context.isNoZeroAmountHidePeriod()) {
            subsidiaryRows.removeIf(row -> (row.getRowType() == RowType.PERIOD || row.getRowType() == RowType.YEAR) && row.getCount() <= 0);
        }
        if (DebugTrace.enable()) {
            List sumRows = subsidiaryRows.stream().filter(r -> r.getRowType() != RowType.LEAF).collect(Collectors.toList());
            ListUtils.partition(sumRows, (int)5).forEach(rows -> LOG.info("sumRows:" + rows));
        }
        return subsidiaryRows;
    }

    List<SubsidiaryRow> filterZeroBalOrAmt(List<SubsidiaryRow> rows, boolean selNoZeroBalance, boolean selNoZeroAmount) {
        if (rows.size() == 1 && rows.get(0).getRowType() == RowType.TOTAL) {
            if (this.removeTotalRow(rows.get(0), selNoZeroBalance, selNoZeroAmount)) {
                rows.clear();
            }
        } else {
            Map<SubsidiaryGroup, Long> grp2MaxPeriod = rows.stream().collect(Collectors.toMap(SubsidiaryRow::getGroup, SubsidiaryRow::getPeriodId, Math::max));
            Set<SubsidiaryGroup> retainedGrp = this.getRetainedGroups(rows, selNoZeroBalance, selNoZeroAmount, grp2MaxPeriod);
            HashMap subtractRowMap = new HashMap(128);
            String serializeStr = this.context.get(SUBTRACT_ROW_CACHE_KEY);
            if (StringUtils.isNotEmpty((String)serializeStr)) {
                subtractRowMap.putAll((Map)SerializationUtils.deSerializeFromBase64((String)serializeStr));
            }
            rows = rows.stream().peek(r -> {
                boolean isLastSumRow;
                SubsidiaryGroup grp = r.getGroup();
                boolean bl = isLastSumRow = (r.getRowType() == RowType.PERIOD || r.getRowType() == RowType.BEGIN) && r.getPeriodId().equals(grp2MaxPeriod.get(grp));
                if (isLastSumRow && !retainedGrp.contains(grp)) {
                    SubsidiaryRow subtractRow = subtractRowMap.computeIfAbsent(grp.getAssistValueGroup(), avGrp -> new SubsidiaryRow());
                    subtractRow.setCount(subtractRow.getCount() + r.getCount());
                    subtractRow.setDebitLocal(subtractRow.getDebitLocal().add(r.getDebitLocal()));
                    subtractRow.setCreditLocal(subtractRow.getCreditLocal().add(r.getCreditLocal()));
                    subtractRow.setEndLocal(subtractRow.getEndLocal().add(r.getEndLocal().multiply(BigDecimal.valueOf(r.getEndDC().intValue()))));
                }
            }).filter(r -> retainedGrp.contains(r.getGroup())).collect(Collectors.toList());
            ArrayList<SubsidiaryRow> removeRows = new ArrayList<SubsidiaryRow>(32);
            for (int i = 0; i < rows.size(); ++i) {
                boolean needRemove;
                boolean bl = needRemove = rows.get(i).getRowType() == RowType.TOTAL && (i - 1 < 0 || rows.get(i - 1).getRowType() == RowType.TOTAL);
                if (!needRemove) continue;
                removeRows.add(rows.get(i));
            }
            rows.removeAll(removeRows);
            rows.stream().filter(r -> r.getRowType() == RowType.TOTAL).forEach(totalRow -> {
                SubsidiaryRow subtractRow = (SubsidiaryRow)subtractRowMap.remove(totalRow.getGroup().getAssistValueGroup());
                if (subtractRow != null) {
                    totalRow.setCount(totalRow.getCount() - subtractRow.getCount());
                    totalRow.setDebitLocal(totalRow.getDebitLocal().subtract(subtractRow.getDebitLocal()));
                    totalRow.setCreditLocal(totalRow.getCreditLocal().subtract(subtractRow.getCreditLocal()));
                    BigDecimal oriDebitLocal = totalRow.getEndLocal().multiply(BigDecimal.valueOf(totalRow.getEndDC().intValue()));
                    BigDecimal newEndLocal = oriDebitLocal.subtract(subtractRow.getEndLocal());
                    totalRow.setEndDC(newEndLocal.compareTo(BigDecimal.ZERO));
                    totalRow.setEndLocal(newEndLocal.abs());
                }
            });
            if (!subtractRowMap.isEmpty()) {
                this.context.cache(SUBTRACT_ROW_CACHE_KEY, SerializationUtils.serializeToBase64(subtractRowMap));
            }
        }
        return rows;
    }

    private Set<SubsidiaryGroup> getRetainedGroups(List<SubsidiaryRow> subsidiaryRows, boolean selNoZeroBalance, boolean selNoZeroAmount, Map<SubsidiaryGroup, Long> grp2MaxPeriod) {
        HashSet<SubsidiaryGroup> retainedGrp = new HashSet<SubsidiaryGroup>(64);
        subsidiaryRows.stream().filter(r -> r.getRowType() == RowType.TOTAL).map(SubsidiaryRow::getGroup).forEach(retainedGrp::add);
        if (selNoZeroAmount) {
            retainedGrp.addAll(this.getNotZeroAmtGrp(subsidiaryRows));
            if (selNoZeroBalance) {
                retainedGrp.addAll(this.getNotZeroBalGrp(subsidiaryRows, grp2MaxPeriod));
            }
        } else {
            retainedGrp.addAll(this.getNotZeroBalGrp(subsidiaryRows, grp2MaxPeriod));
        }
        return retainedGrp;
    }

    private boolean removeTotalRow(SubsidiaryRow totalRow, boolean selNoZeroBalance, boolean selNoZeroAmount) {
        boolean zeroAmt;
        boolean remove = false;
        boolean zeroBal = totalRow.getEndLocal().compareTo(BigDecimal.ZERO) == 0 && totalRow.getEndFor().compareTo(BigDecimal.ZERO) == 0 && totalRow.getEndQty().compareTo(BigDecimal.ZERO) == 0;
        boolean bl = zeroAmt = totalRow.getCount() <= 0;
        remove = selNoZeroAmount ? (selNoZeroBalance ? zeroAmt && zeroBal : zeroAmt) : zeroBal;
        return remove;
    }

    Set<SubsidiaryGroup> getNotZeroBalGrp(List<SubsidiaryRow> rows, Map<SubsidiaryGroup, Long> grp2MaxPeriod) {
        long endPeriod = this.context.getQueryParam().getEndPeriod();
        Predicate maxPeriodPred = r -> r.getPeriodId().equals(endPeriod);
        if (this.context.isNoZeroAmountHidePeriod()) {
            maxPeriodPred = r -> r.getPeriodId().equals(grp2MaxPeriod.get(r.getGroup()));
        }
        Predicate finalMaxPeriodPred = maxPeriodPred;
        return rows.stream().filter(r -> r.getRowType() == RowType.PERIOD && finalMaxPeriodPred.evaluate(r) || r.getRowType() == RowType.TOTAL).filter(r -> r.getEndLocal().compareTo(BigDecimal.ZERO) != 0 || r.getEndFor().compareTo(BigDecimal.ZERO) != 0 || r.getEndQty().compareTo(BigDecimal.ZERO) != 0).map(SubsidiaryRow::getGroup).collect(Collectors.toSet());
    }

    Set<SubsidiaryGroup> getNotZeroAmtGrp(List<SubsidiaryRow> rows) {
        return rows.stream().filter(r -> r.getRowType() == RowType.PERIOD && r.getCount() > 0).map(SubsidiaryRow::getGroup).collect(Collectors.toSet());
    }

    @Override
    public Comparator<SubsidiaryRow> getRowComparator() {
        List<String> voucherSortExtFields = this.context.getSortExtFieldAlias();
        List<String> sortTypes = this.context.getSortType();
        return (r1, r2) -> {
            int res = r1.getPeriodGroup().compareTo(r2.getPeriodGroup());
            if (res == 0) {
                res = r1.getRowType().compareTo((Enum)r2.getRowType());
            }
            if (res == 0) {
                if (voucherSortExtFields.isEmpty()) {
                    res = GLUtil.compareLongArr((long[])r1.getComAssistValues(), (long[])r2.getComAssistValues());
                    boolean bl = res != 0 || (res = r1.getBookedDate().compareTo(r2.getBookedDate())) != 0 || (res = r1.getVtNum().compareTo(r2.getVtNum())) != 0 || (res = r1.getVoucherNo().compareTo(r2.getVoucherNo())) != 0;
                } else {
                    Map<String, Object> s1 = r1.getExtSortVoucherFields();
                    Map<String, Object> s2 = r2.getExtSortVoucherFields();
                    for (int i = 0; i < voucherSortExtFields.size(); ++i) {
                        String field = (String)voucherSortExtFields.get(i);
                        String sortType = (String)sortTypes.get(i);
                        int c = GLUtil.compareObj((Object)s1.get(field), (Object)s2.get(field));
                        int n = res = "asc".equals(sortType) ? c : -c;
                        if (res != 0) break;
                    }
                }
                return res;
            }
            return res;
        };
    }

    @Override
    public List<ResultField<SubsidiaryRow>> getResultFields() {
        int i;
        LinkedList<ResultField<SubsidiaryRow>> fields = new LinkedList<ResultField<SubsidiaryRow>>();
        CurType curType = this.context.getQueryParam().getCurType();
        boolean isBaseCurrency = curType == CurType.BASE || curType == CurType.NATIVE;
        fields.add(new ResultField<SubsidiaryRow>("rowtype", (DataType)DataType.IntegerType, r -> r.getRowType().value));
        if (this.context.isExportAll()) {
            List<FlexUtils.AssistFilterEntry> assistEntries = this.context.getAssistEntries();
            for (i = 0; i < assistEntries.size(); ++i) {
                int finalIndex = i;
                FlexUtils.AssistFilterEntry assistFilterEntry = assistEntries.get(i);
                StringType dataType = AssistValueType.isManualTxt((String)assistFilterEntry.getFlexProperty().getValueType()) ? DataType.StringType : DataType.LongType;
                fields.add(new ResultField<SubsidiaryRow>(assistFilterEntry.getProperty(), (DataType)dataType, row -> row.getGroup().getAssistValueGroup().getSingleBdValue(finalIndex)));
            }
        }
        List comAssist = this.context.getQueryParam().getCommonAssistKeys();
        for (i = 0; i < comAssist.size(); ++i) {
            int finalI = i;
            fields.add(new ResultField<SubsidiaryRow>((String)comAssist.get(i) + "id", (DataType)DataType.LongType, r -> {
                long[] comAssistValues = r.getComAssistValues();
                return finalI < comAssistValues.length ? comAssistValues[finalI] : 0L;
            }));
        }
        fields.add(new ResultField<SubsidiaryRow>("accountid", (DataType)DataType.LongType, SubsidiaryRow::getAccountId));
        Long curLocal = this.context.getQueryParam().getCurLocal();
        fields.add(new ResultField<SubsidiaryRow>("basecurrency", (DataType)DataType.LongType, r -> curLocal));
        fields.add(new ResultField<SubsidiaryRow>("currencycolumn", (DataType)DataType.LongType, r -> isBaseCurrency ? curLocal : r.getCurrencyId()));
        fields.add(new ResultField<SubsidiaryRow>("pricecurrency", (DataType)DataType.LongType, r -> {
            if (isBaseCurrency) {
                if (r.getRowType() != RowType.LEAF) {
                    return curLocal;
                }
                return r.getForCurrency();
            }
            return r.getCurrencyId();
        }));
        fields.add(new ResultField<SubsidiaryRow>("measureunit", (DataType)DataType.LongType, SubsidiaryRow::getMeasureUnitId));
        fields.add(new ResultField<SubsidiaryRow>("period", (DataType)DataType.LongType, SubsidiaryRow::getPeriodId));
        fields.add(new ResultField<SubsidiaryRow>("datefield", (DataType)DataType.DateType, SubsidiaryRow::getBookedDate));
        fields.add(new ResultField<SubsidiaryRow>("creditlocal", (DataType)DataType.BigDecimalType, SubsidiaryRow::getCreditLocal));
        fields.add(new ResultField<SubsidiaryRow>("debitlocal", (DataType)DataType.BigDecimalType, SubsidiaryRow::getDebitLocal));
        fields.add(new ResultField<SubsidiaryRow>("endlocal", (DataType)DataType.BigDecimalType, SubsidiaryRow::getEndLocal));
        fields.add(new ResultField<SubsidiaryRow>("dc", (DataType)DataType.IntegerType, SubsidiaryRow::getEndDC));
        if (this.context.getQueryParam().isQueryCurrency()) {
            fields.add(new ResultField<SubsidiaryRow>("creditfor", (DataType)DataType.BigDecimalType, SubsidiaryRow::getCreditFor));
            fields.add(new ResultField<SubsidiaryRow>("debitfor", (DataType)DataType.BigDecimalType, SubsidiaryRow::getDebitFor));
            fields.add(new ResultField<SubsidiaryRow>("endfor", (DataType)DataType.BigDecimalType, SubsidiaryRow::getEndFor));
        }
        if (this.context.getQueryParam().isShowQty()) {
            fields.add(new ResultField<SubsidiaryRow>("creditqty", (DataType)DataType.BigDecimalType, SubsidiaryRow::getCreditQty));
            fields.add(new ResultField<SubsidiaryRow>("debitqty", (DataType)DataType.BigDecimalType, SubsidiaryRow::getDebitQty));
            fields.add(new ResultField<SubsidiaryRow>("endqty", (DataType)DataType.BigDecimalType, SubsidiaryRow::getEndQty));
        }
        fields.add(new ResultField<SubsidiaryRow>("voucherid", (DataType)DataType.LongType, SubsidiaryRow::getVoucherId));
        fields.add(new ResultField<SubsidiaryRow>("fentryid", (DataType)DataType.LongType, SubsidiaryRow::getVoucherEntryId));
        return fields;
    }
}

