/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.constant;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accountref.constant.AccountCache;
import kd.fi.gl.accountref.constant.AssistCache;
import kd.fi.gl.accountref.constant.BalTransferType;
import kd.fi.gl.util.GLUtil;

public class AccountRefContext {
    private Long orgId;
    private Long bookTypeId;
    private Date date;
    private Long periodId;
    private Long prePeriodId;
    private int periodYear;
    private boolean isCrossYear;
    private AccountTableRef acctTblRef;
    private AssistCache assistCache;
    private AccountCache accountCache;
    private static final String PERIOD_YEAR = "periodyear";

    public AccountRefContext(Long orgId, Long bookTypeId, Date date, Long periodId, AccountTableRef acctTblRef, BalTransferType type) {
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
        this.date = date;
        this.periodId = periodId;
        this.acctTblRef = acctTblRef;
        this.assistCache = new AssistCache();
        this.accountCache = new AccountCache(this, BalTransferType.ACCCURRENT == type);
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        if (curPeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u671f\u95f4%s\u627e\u4e0d\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u6821\u9a8c\u4f20\u5165\u7684\u671f\u95f4\u53c2\u6570\u6b63\u786e\u6027\u3002", (String)"AccountRefContext_0", (String)"fi-gl-common", (Object[])new Object[0]), periodId));
        }
        this.periodYear = curPeriod.getInt(PERIOD_YEAR);
        DynamicObject previousPeriod = GLUtil.getPreviousPeriod(periodId);
        if (previousPeriod == null) {
            this.prePeriodId = periodId;
            this.isCrossYear = false;
        } else {
            this.prePeriodId = previousPeriod.getLong("id");
            this.isCrossYear = previousPeriod.getInt(PERIOD_YEAR) != curPeriod.getInt(PERIOD_YEAR);
        }
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getBookTypeId() {
        return this.bookTypeId;
    }

    public Date getDate() {
        return this.date;
    }

    protected Long getPeriodId() {
        return this.periodId;
    }

    public AccountTableRef getAcctTblRef() {
        return this.acctTblRef;
    }

    protected AssistCache getAssistCache() {
        return this.assistCache;
    }

    protected AccountCache getAccountCache() {
        return this.accountCache;
    }

    protected Long getPrePeriodId() {
        return this.prePeriodId;
    }

    protected int getPeriodYear() {
        return this.periodYear;
    }

    protected boolean isCrossYear() {
        return this.isCrossYear;
    }
}

