/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.constant.AcccurrentData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;

public class AcccurrentDataHandler
extends AbstractBalDataHandler {
    private static final String ASSVAL = "assval";
    private static final String ENTRIES_ASSGRP = "entries.assgrp";
    private static final String ENTRIES_ID = "entries.id";
    private static final String WRITEOFF_STATUS_COMPLETE = "2";
    private static final String ASSTACTITEM_FLEXFIELD = "asstactitem.flexfield";
    protected static final String SELECT_FIELDS = "id, period, account, assgrp, assgrp.value assval, bizdate, expiredate, biznum,currency,amountfor, amountbalfor,localcurrency, amount, amountbal, description, voucherid, voucherentry, status, sourcetype, masterid, entrydc, creator, writeoffperson, bookeddate";

    @Override
    public void handle(SingleAccountRefContext context) {
        HashSet<Long> queryVoucherAccts = new HashSet<Long>(1024);
        Set<Long> oldActIds = this.checkValidateAcccAccount(context, queryVoucherAccts);
        if (oldActIds.isEmpty()) {
            context.setClosed(true);
            return;
        }
        context.setOldAccountIds(oldActIds);
        HashSet<Long> vchEntryIds = new HashSet<Long>(1024);
        HashSet<Long> vchIds = new HashSet<Long>(1024);
        HashSet<Long> masterIds = new HashSet<Long>(1024);
        ArrayList<AcccurrentData> acccurrentDatas = new ArrayList<AcccurrentData>(1024);
        DataSet dSet = this.queryOldAcccurrentData(context);
        Object object = null;
        try {
            for (Row row : dSet) {
                AcccurrentData acccurrentData = this.buildAcccurrentData(context, row, true);
                acccurrentDatas.add(acccurrentData);
                masterIds.add(acccurrentData.getMasterId());
                if (!queryVoucherAccts.contains(acccurrentData.getAcctPKId())) continue;
                vchEntryIds.add(acccurrentData.getVchEntryId());
                vchIds.add(acccurrentData.getVoucherId());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dSet != null) {
                if (object != null) {
                    try {
                        dSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dSet.close();
                }
            }
        }
        if (!vchEntryIds.isEmpty()) {
            dSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".handle"), (String)"gl_voucher", (String)"entries.id,entries.assgrp", (QFilter[])new QFilter[]{new QFilter(ENTRIES_ID, "in", vchEntryIds), new QFilter("id", "in", vchIds)}, null);
            object = null;
            try {
                for (Row row : dSet) {
                    context.addVchEntryAndAssgrpMap(row.getLong(ENTRIES_ID), row.getLong(ENTRIES_ASSGRP));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dSet != null) {
                    if (object != null) {
                        try {
                            dSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dSet.close();
                    }
                }
            }
        }
        Set<Long> futureMasterIds = this.queryRefRecords(context, masterIds);
        for (AcccurrentData acccurrentData : acccurrentDatas) {
            if (futureMasterIds.contains(acccurrentData.getMasterId())) continue;
            context.addOldBalData(acccurrentData);
        }
    }

    private Set<Long> queryRefRecords(SingleAccountRefContext context, Set<Long> masterIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("masterid", "in", masterIds));
        filters.add(new QFilter("effectivedate", ">=", (Object)context.getDate()));
        HashSet<Long> futureMasterIds = new HashSet<Long>(1024);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"masterid", (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : dSet) {
                futureMasterIds.add(row.getLong("masterid"));
            }
        }
        return futureMasterIds;
    }

    protected Set<Long> checkValidateAcccAccount(SingleAccountRefContext context, Set<Long> queryVoucherAccts) {
        HashSet<Long> newAccountIds = new HashSet<Long>(1024);
        AccountTableRef accountTableRef = context.getAcctTblRef();
        Set<Long> oldAccontIds = context.getOldAccountIds();
        Map<Long, DynamicObject> accCheckOldAcctIds = BalanceTransferUtils.queryAccountInfos(oldAccontIds, true);
        for (Long accCheckOldAcctId : accCheckOldAcctIds.keySet()) {
            Long newAccountId = accountTableRef.getNewAccountId(accCheckOldAcctId);
            if (null == newAccountId) continue;
            newAccountIds.add(newAccountId);
        }
        Map<Long, DynamicObject> accCheckNewAcctIds = BalanceTransferUtils.queryAccountInfos(newAccountIds, true);
        HashSet<Long> oldActIds = new HashSet<Long>(1024);
        for (Map.Entry<Long, DynamicObject> entry : accCheckNewAcctIds.entrySet()) {
            Long newAccountId = entry.getKey();
            DynamicObject newAccount = entry.getValue();
            Set oldIds = accountTableRef.getOldAccountIds(newAccountId);
            for (Long oldId : oldIds) {
                DynamicObject oldAccount = accCheckOldAcctIds.get(oldId);
                if (null == oldAccount) continue;
                if (this.checkNeedBalTrans(newAccount, oldAccount)) {
                    oldActIds.add(oldId);
                }
                List<String> newAssists = this.getAccCheckFlexFields(newAccount);
                DynamicObjectCollection oldAssistEntry = oldAccount.getDynamicObjectCollection("checkitementry");
                for (DynamicObject assistRow : oldAssistEntry) {
                    Boolean enaccheck;
                    String fieldName = assistRow.getString(ASSTACTITEM_FLEXFIELD);
                    if (!newAssists.contains(fieldName) || (enaccheck = Boolean.valueOf(assistRow.getBoolean("enaccheck"))).booleanValue()) continue;
                    queryVoucherAccts.add(oldAccount.getLong("id"));
                }
            }
        }
        return oldActIds;
    }

    private boolean checkNeedBalTrans(DynamicObject newAccount, DynamicObject oldAccount) {
        long oldMasterId;
        long newMasterId = newAccount.getLong("masterid");
        if (newMasterId != (oldMasterId = oldAccount.getLong("masterid"))) {
            return true;
        }
        List<String> newAssists = this.getAccCheckFlexFields(newAccount);
        List<String> oldAssists = this.getAccCheckFlexFields(oldAccount);
        int newSize = newAssists.size();
        if (newSize != oldAssists.size()) {
            return true;
        }
        newAssists.retainAll(oldAssists);
        int retainSize = newAssists.size();
        return newSize != retainSize;
    }

    private List<String> getAccCheckFlexFields(DynamicObject account) {
        DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
        ArrayList<String> lstFields = new ArrayList<String>(assistEntry.size());
        for (DynamicObject assistRow : assistEntry) {
            String fieldName = assistRow.getString(ASSTACTITEM_FLEXFIELD);
            Boolean enaccheck = assistRow.getBoolean("enaccheck");
            if (!enaccheck.booleanValue()) continue;
            lstFields.add(fieldName);
        }
        return lstFields;
    }

    protected AcccurrentData buildAcccurrentData(SingleAccountRefContext context, Row row, boolean isOldData) {
        AcccurrentData acccurrentData = new AcccurrentData();
        acccurrentData.setId(row.getLong("id"));
        Long masterId = row.getLong("account");
        acccurrentData.setAcctMasterId(masterId);
        if (isOldData) {
            acccurrentData.setAcctPKId(context.getAccountCache().getOldAccountId(masterId));
        }
        acccurrentData.setAssgrpId(row.getLong("assgrp"));
        acccurrentData.setAssval(row.getString(ASSVAL));
        acccurrentData.setCurrencyId(row.getLong("currency"));
        acccurrentData.setLocalCurrency(row.getLong("localcurrency"));
        acccurrentData.setPeriodId(row.getLong("period"));
        acccurrentData.setAmount(row.getBigDecimal("amount"));
        acccurrentData.setAmountFor(row.getBigDecimal("amountfor"));
        acccurrentData.setAmountBal(row.getBigDecimal("amountbal"));
        acccurrentData.setAmountBalFor(row.getBigDecimal("amountbalfor"));
        acccurrentData.setBizDate(row.getDate("bizdate"));
        acccurrentData.setBizNum(row.getString("biznum"));
        acccurrentData.setDescription(row.getString("description"));
        acccurrentData.setExpireDate(row.getDate("expiredate"));
        acccurrentData.setSourceType(row.getString("sourcetype"));
        acccurrentData.setStatus(row.getString("status"));
        acccurrentData.setVchEntryId(row.getLong("voucherentry"));
        acccurrentData.setVoucherId(row.getLong("voucherid"));
        acccurrentData.setMasterId(row.getLong("masterid"));
        acccurrentData.setEntryDc(row.getString("entrydc"));
        acccurrentData.setCreator(row.getLong("creator"));
        acccurrentData.setWriteOffPerson(row.getLong("writeoffperson"));
        acccurrentData.setBookedDate(row.getDate("bookeddate"));
        return acccurrentData;
    }

    private DataSet queryOldAcccurrentData(SingleAccountRefContext context) {
        List<QFilter> filters = this.getOldAcccurrentFilter(context);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)SELECT_FIELDS, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private List<QFilter> getOldAcccurrentFilter(SingleAccountRefContext context) {
        Long prePeriodId = context.getPrePeriodId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)context.getOrgId()));
        filters.add(new QFilter("booktype", "=", (Object)context.getBookTypeId()));
        filters.add(new QFilter("accounttable", "=", (Object)context.getAcctTblRef().getOldAccountTableId()));
        filters.add(new QFilter("period", "<=", (Object)prePeriodId));
        HashSet<Long> acctMasterIdSet = new HashSet<Long>(1024);
        try (DataSet acctSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", context.getOldAccountIds())}, null);){
            for (Row row : acctSet) {
                acctMasterIdSet.add(row.getLong("masterid"));
            }
        }
        filters.add(new QFilter("account", "in", acctMasterIdSet));
        filters.add(new QFilter("status", "not in", (Object)WRITEOFF_STATUS_COMPLETE));
        filters.add(new QFilter("effectivedate", "<", (Object)context.getDate()));
        filters.add(new QFilter("uneffectivedate", ">=", (Object)context.getDate()));
        return filters;
    }

    protected String getBalKey(Row row) {
        return BalanceTransferUtils.getAcccurrentKey(row.getLong("masterid"));
    }
}

